<?php
 namespace Moto\Website; use Moto; class PageType { protected $_params = null; protected $provider; protected static $_cache = array(); protected $attributes = [ 'type' => 'page', 'section' => 'website', 'entity' => 'page', 'isTemplate' => false, ]; public function __construct($type) { $this->attributes['type'] = $type; if (preg_match('/^(?<template>template\.)?(?<section>[^.]+)\.(?<entity>[^.]+)/', $type, $match)) { $this->attributes['isTemplate'] = (boolean) $match['template']; $this->attributes['section'] = $match['section']; $this->attributes['entity'] = $match['entity']; } else { $parts = explode('.', $type, 2); $this->attributes['section'] = $parts[0]; $this->attributes['isTemplate'] = ($parts[0] === 'template'); } if ($this->attributes['isTemplate']) { return; } $manager = Moto\System::app(Moto\System\ContentSection\ContentSectionManager::class); try { $this->provider = $manager->getProvider($this->attributes['section']); if ($this->provider) { $this->_params = $this->provider->getProperties(); } } catch (\Exception $e) { if (Moto\System::isDevelopmentStage()) { Moto\System\Log::critical(__METHOD__ . ' : Please, change logic'); } } } public function getAttributes() { return $this->attributes; } public function getContentProvider() { return $this->provider; } public function getParam($name, $default = null) { return Moto\Util::getValue($this->_params, $name, $default); } public function getMainPageId() { return $this->getParam('page_id', 0); } public function getSectionName() { return $this->attributes['section']; } public function getEntityName() { return $this->attributes['entity']; } public function isPage() { return ($this->attributes['type'] === 'page'); } public function isTemplate() { return $this->attributes['isTemplate']; } public function isPost() { return !$this->isTemplate() && ($this->attributes['entity'] === 'post'); } public static function get($type) { if (is_object($type)) { $type = Moto\Util::getValue($type, 'type'); } if (!is_string($type)) { return null; } if (!array_key_exists($type, static::$_cache)) { static::$_cache[$type] = new static($type); } return static::$_cache[$type]; } } 