<?php
namespace Moto\Website; use Moto; use Zend\Stdlib\ArrayUtils; class RobotsTxtService { protected static $_primaryFile = '@seoRobotTxtFile'; protected static $_settingKey = 'seo_robots_txt_settings'; public static function getPrimaryFilePath() { return Moto\System::getAbsolutePath(static::$_primaryFile); } public static function getPrimaryFileUrl() { return Moto\System::getAbsoluteUrl(static::$_primaryFile); } public static function isPrimaryFileExists() { return file_exists(static::getPrimaryFilePath()); } public static function getPrimaryFileInformation() { $path = static::getPrimaryFilePath(); $result = array( 'url' => static::getPrimaryFileUrl(), 'exists' => static::isPrimaryFileExists(), 'last_modified' => null, 'is_writable' => null, ); if ($result['exists']) { $result['last_modified'] = date('Y-m-d H:i:s', filemtime($path)); $result['is_writable'] = is_writable($path); } return $result; } public static function getSettings() { return (array) Moto\Website\Settings::get(static::$_settingKey, Moto\Website\RobotsTxtGenerator::getDefaultSettings()); } public static function saveSettings($settings) { if (!is_array($settings)) { return false; } $settings = ArrayUtils::merge(static::getSettings(), $settings); Moto\Website\Settings::add(static::$_settingKey, $settings, 'array'); return true; } public static function getFailedDependency() { $dependency = array(); $path = static::getPrimaryFilePath(); $dir = dirname($path); if (file_exists($path)) { if (!is_writable($path)) { $dependency[] = 'PRIMARY_FILE_NOT_WRITABLE'; } } elseif (!is_writable($dir)) { $dependency[] = 'WEBSITE_DIR_NOT_WRITABLE'; } $dependency = Moto\Hook::trigger(Moto\Hook::ROBOTS_TXT_CHECK_DEPENDENCIES, $dependency); return count($dependency) ? $dependency : null; } protected static function _checkDependency() { $dependency = static::getFailedDependency(); if (is_array($dependency) && count($dependency)) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_FAILED_DEPENDENCY_MESSAGE, Moto\System\Exception::ERROR_FAILED_DEPENDENCY_CODE, $dependency); } return true; } public static function createNewGenerator($settings = null) { return new Moto\Website\RobotsTxtGenerator($settings); } public static function generateFileContent($settings = null) { if ($settings === null) { $settings = static::getSettings(); } if (!is_array($settings)) { return null; } $generator = static::createNewGenerator($settings); Moto\Hook::trigger(Moto\Hook::ROBOTS_TXT_GENERATOR_CREATED, $generator); $content = $generator->generateContent(); $content = Moto\Hook::trigger(Moto\Hook::ROBOTS_TXT_GENERATED_CONTENT, $content, $generator); return $content; } public static function generateFile() { static::_checkDependency(); Moto\Hook::trigger(Moto\Hook::ROBOTS_TXT_GENERATING); $content = static::generateFileContent(); if ($content) { $filePath = static::getPrimaryFilePath(); if (!Moto\Util::filePutContents($filePath, $content)) { } } Moto\Hook::trigger(Moto\Hook::ROBOTS_TXT_GENERATED); } } class RobotsTxtGenerator { const VERSION = '1.0.0'; const BUILD = 1; protected static $_defaultSettings = [ 'system' => [ 'enabled' => true, 'indexing' => true, 'sitemapType' => 'system', 'sitemapUrl' => '', ], 'custom' => [ 'enabled' => true, 'content' => '', ], ]; protected $_settings = []; public static function getDefaultSettings() { return static::$_defaultSettings; } public function __construct($settings = null) { $this->_settings = static::getDefaultSettings(); if (is_array($settings)) { $this->_settings = ArrayUtils::merge($this->_settings, $settings); } else { $this->_settings = ArrayUtils::merge($this->_settings, Moto\Website\RobotsTxtService::getSettings()); } } public function getSettings() { return $this->_settings; } public function setSetting($name, $value) { return Moto\Util::setToArrayDeep($this->_settings, $name, $value); } public function getSetting($name, $default = null) { return Moto\Util::getValue($this->_settings, $name, $default); } public function generateContentHeader() { return '### Created with "Website Builder RobotsTxt Generator" (' . static::VERSION . '/' . static::BUILD . ')' . "\n\n"; } public function generateSystemContentPart() { if (!$this->getSetting('system.enabled')) { return ''; } $content = "### <system>\n"; $content .= "User-Agent: *\n"; $url = '/'; if ($this->getSetting('system.indexing')) { $content .= "Allow: $url\n"; } else { $content .= "Disallow: $url\n"; } $sitemapType = $this->getSetting('system.sitemapType'); if ($sitemapType === 'system') { if (Moto\Website\SitemapService::isPrimaryFileExists()) { $content .= 'Sitemap: ' . Moto\Website\SitemapService::getPrimaryFileUrl() . "\n"; } } elseif ($sitemapType === 'custom') { $content .= 'Sitemap: ' . $this->getSetting('system.sitemapUrl') . "\n"; } $content .= "### </system>\n"; return $content; } public function generateCustomContentPart() { if (!$this->getSetting('custom.enabled')) { return ''; } $content = trim((string) $this->getSetting('custom.content')); if ($content !== '') { $content = "### <custom>\n" . $content . "\n### </custom>\n"; } return $content; } public function generateContent() { $content = $this->generateContentHeader(); $content .= $this->generateSystemContentPart(); $content .= $this->generateCustomContentPart(); return $content; } } 