<?php
namespace Moto\Website; use Moto; class Settings extends Moto\System\Settings { const SETTING_NAMESPACE = 'website'; protected static $_webmaster = null; protected static $_webmasterModel = null; protected static $_isLazyLoadingEnabled = false; protected static $_lazyLoadingDisabled; public static function init() { if (static::$_initialized) { return; } parent::init(); Moto\Config::set('settings.' . self::SETTING_NAMESPACE, self::getPublicData()); Moto\System::setUrl('website', Moto\Website\Settings::get('address')); if ($timezone = static::get('timezone')) { date_default_timezone_set($timezone); } if (!Moto\System\Request::isPreviewMode()) { static::$_isLazyLoadingEnabled = Moto\Util::getValue(static::get('lazy_loading'), 'enabled', false); } } protected static function _onLoadData() { $address = Moto\Website\Settings::get('address'); if (!empty($address) && substr($address, -1) !== '/') { Moto\Website\Settings::set('address', $address . '/'); } } public static function getWebmasterModel() { if (null === static::$_webmasterModel) { $query = Moto\Database\Models\User::query(); $query->whereIn('role_id', [ Moto\Database\Models\Role::ROOT_ID, Moto\Database\Models\Role::ADMIN_ID, ]); $query->orderBy('role_id'); $query->orderBy('id'); $webmaster = $query->first(); if ($webmaster) { static::$_webmasterModel = $webmaster; } } return static::$_webmasterModel; } public static function getWebmaster() { if (null === static::$_webmaster) { $webmaster = static::getWebmasterModel(); if ($webmaster) { static::$_webmaster = $webmaster->toArrayObject(); } } return static::$_webmaster; } public static function onUpdated() { Moto\System::setUrl('website', static::get('address')); } public static function getPublicData() { $data = self::_get(self::SETTING_NAMESPACE); unset($data['installed_plugins']); unset($data['plugins']); unset($data['widgets']); unset($data['custom_code_header']); unset($data['custom_code_footer']); unset($data['default_mail_options']); unset($data['redirection_rules']); unset($data['sitemap_settings']); unset($data['activated_plugins']); if (!Moto\System::getUser()) { unset($data['content_sections']); unset($data['integrations']); unset($data['colors']); unset($data['content_section_blog']); unset($data['custom_code_execution']); unset($data['layouts']); unset($data['main_page']); unset($data['maintenance_mode']); unset($data['maintenance_mode']); unset($data['maintenance_mode_message']); unset($data['notfound_page_id']); unset($data['password_protected_page_id']); unset($data['password_protection']); unset($data['spacings']); unset($data['theme_grid']); unset($data['theme_presets']); unset($data['thumbnails']); unset($data['title_format']); unset($data['under_construction']); unset($data['widget_embed_execution']); unset($data['back_to_top_button']); unset($data['google_analytics']); unset($data['google_webmaster_tools_tag']); unset($data['yandex_metrica_counter']); unset($data['yandex_webmaster_code']); unset($data['google_tag_manager']); unset($data['facebook_pixel']); } return $data; } public static function isLazyLoadingEnabled() { if (static::$_lazyLoadingDisabled) { return false; } return static::$_isLazyLoadingEnabled; } public static function disableLazyLoadingByWidget($widget) { if (static::$_lazyLoadingDisabled) { return false; } static::$_lazyLoadingDisabled = $widget; return true; } public static function resetDisablingLazyLoadingByWidget($widget) { if (static::$_lazyLoadingDisabled !== $widget) { return false; } static::$_lazyLoadingDisabled = null; return false; } } 