<?php
namespace Moto\Website\Sitemap; use Moto; abstract class AbstractFile { const PARENT_NODE_NAME = 'abstract'; protected $_fileName; protected $_filePath; protected $_fileUrl; protected $_items = array(); public function setFileName($file) { if (!is_string($file) || empty($file) || $file[0] !== '@') { throw new \InvalidArgumentException('Please specify valid file path.'); } $this->_fileName = $file; $this->_filePath = Moto\System::getAbsolutePath($file); $this->_fileUrl = Moto\System::getAbsoluteUrl($file); } public function getFileName() { return $this->_fileName; } public function getAbsoluteFilePath() { return $this->_filePath; } public function getAbsoluteFileUrl() { return $this->_fileUrl; } public function isFileExists() { return file_exists($this->_filePath); } public function getModificationTime($format = null) { $time = filemtime($this->getAbsoluteFilePath()); if (is_string($format)) { return date($format, $time); } return $time; } public function addLocation($location, $attributes = null) { if (!$this->isValidLocation($location, $attributes)) { return false; } if ($location[0] === '@') { $location = Moto\System::getAbsoluteUrl($location); } $this->_items[] = array( 'location' => $location, 'attributes' => $attributes, ); return true; } public function isValidLocation($path, $attributes = null) { if (!is_string($path)) { return false; } if (empty($path)) { return false; } if ($attributes !== null && !is_array($attributes)) { return false; } return true; } abstract protected function _generateHeader(); abstract protected function _generateFooter(); protected function _createNewFile() { return Moto\Util::filePutContents($this->_filePath, '<?xml version="1.0" encoding="UTF-8"?>' . "\n"); } protected function _writeToFile($string) { return Moto\Util::filePutContents($this->_filePath, $string, FILE_APPEND); } protected function _writeHeader() { $this->_writeToFile($this->_generateHeader()); $this->_writeToFile('<!-- Created with Moto Website (' . Moto\Version::getCurrentVersion() . '/' . Moto\Version::getCurrentBuild() . ') Sitemap Generator -->' . "\n"); } public function getParentNode() { return static::PARENT_NODE_NAME; } protected function _writeContent() { $node = $this->getParentNode(); foreach ($this->_items as $item) { $location = $item['location']; $attributes = $item['attributes']; $content = '<' . $node . '>'; $content .= '<loc>' . $location . '</loc>'; if (is_array($attributes)) { foreach ($attributes as $attribute => $value) { $value = trim($value); if (empty($value)) { continue; } $content .= '<' . $attribute . '>' . $value . '</' . $attribute . '>'; } } $content .= '</' . $node . '>'; $this->_writeToFile($content . "\n"); } } protected function _writeFooter() { $this->_writeToFile($this->_generateFooter()); } public function write() { $this->_createNewFile(); $this->_writeHeader(); $this->_writeContent(); $this->_writeFooter(); } public function delete() { if ($this->isFileExists()) { @unlink($this->getAbsoluteFilePath()); } return true; } public function isEmpty() { return count($this->_items) < 1; } } 