<?php
 namespace Moto\Website; use Moto; use Zend\Db\Sql\Where as SqlWhere; class SitemapService { static protected $_primaryFile = '@primarySitemapFile'; protected static $_contentPreferences; public static function getPrimaryFilePath() { return Moto\System::getAbsolutePath(static::$_primaryFile); } public static function getPrimaryFileUrl() { return Moto\System::getAbsoluteUrl(static::$_primaryFile); } public static function isPrimaryFileExists() { return file_exists(static::getPrimaryFilePath()); } public static function getPrimaryFileInformation() { $path = static::getPrimaryFilePath(); $result = array( 'url' => static::getPrimaryFileUrl(), 'exists' => static::isPrimaryFileExists(), 'last_modified' => null, 'is_writable' => null, ); if ($result['exists']) { $result['last_modified'] = date('Y-m-d H:i:s', filemtime($path)); $result['is_writable'] = is_writable($path); } return $result; } public static function getSettings() { return Moto\Website\Settings::get('sitemap_settings', array('external_sitemaps' => array(), 'content_preferences' => static::getDefaultContentPreferences())); } public static function saveSettings($settings) { if (!is_array($settings)) { return false; } if (empty($settings['content_preferences'])) { $settings['content_preferences'] = static::getDefaultContentPreferences(); } Moto\Website\Settings::add('sitemap_settings', $settings, 'array'); return true; } public static function getFailedDependency() { $dependency = array(); $path = static::getPrimaryFilePath(); $dir = dirname($path); if (file_exists($path)) { if (!is_writable($path)) { $dependency[] = 'PRIMARY_FILE_NOT_WRITABLE'; } } elseif (!is_writable($dir)) { $dependency[] = 'WEBSITE_DIR_NOT_WRITABLE'; } $dir = Moto\System::getAbsolutePath('@additionalSitemapsDir'); if (!is_writable($dir)) { $dependency[] = 'ADDITIONAL_SITEMAP_DIR_NOT_WRITABLE'; } $dependency = Moto\Hook::trigger(Moto\Hook::SITEMAP_CHECK_DEPENDENCIES, $dependency); return count($dependency) ? $dependency : null; } protected static function _checkDependency() { $dependency = static::getFailedDependency(); if (is_array($dependency) && count($dependency)) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_FAILED_DEPENDENCY_MESSAGE, Moto\System\Exception::ERROR_FAILED_DEPENDENCY_CODE, $dependency); } return true; } public static function getDefaultContentPreferences() { return array( [ 'type' => '@main_page', 'priority' => '1.0', 'frequency' => null, ], [ 'type' => 'page', 'priority' => '0.8', 'frequency' => null, ], [ 'type' => 'blog.index', 'priority' => '0.8', 'frequency' => null, ], [ 'type' => 'blog.post', 'priority' => '0.5', 'frequency' => null, ], ); } public static function getContentPreferences($type = null) { if (static::$_contentPreferences === null) { static::$_contentPreferences = []; $preferences = Moto\Util::getValue(static::getSettings(), 'content_preferences'); if (!is_array($preferences)) { $preferences = static::getDefaultContentPreferences(); } $preferences = (array) $preferences; foreach ($preferences as $preference) { $preferenceType = Moto\Util::getValue($preference, 'type'); if (!is_string($preferenceType) || empty($preferenceType) || array_key_exists($preferenceType, static::$_contentPreferences)) { continue; } static::$_contentPreferences[$preferenceType] = $preference; } } if ($type === null) { return static::$_contentPreferences; } return array_key_exists($type, static::$_contentPreferences) ? static::$_contentPreferences[$type] : null; } public static function fillUrlFromPage($entity) { if (!($entity instanceof Moto\Application\Pages\PageModel)) { return null; } $type = Moto\Util::getValue($entity, 'type'); if ($entity->isMainPage()) { $type = '@main_page'; } $item = static::getContentPreferences($type); return array( 'url' => $entity->getAbsoluteUrl(), 'updated_at' => $entity->modified, 'priority' => Moto\Util::getValue($item, 'priority', '0.5'), 'frequency' => Moto\Util::getValue($item, 'frequency'), ); } public static function fillUrlFromTaxonomy($entity) { if (!($entity instanceof Moto\Database\Models\ContentTaxonomy)) { return null; } $item = static::getContentPreferences($entity->type); if (empty($item)) { $item = $entity->getContentProvider() ->resolveSitemapPreferenceForTaxonomy($entity, static::getContentPreferences()); } return array( 'url' => $entity->getAbsoluteUrl(), 'updated_at' => $entity->updated_at, 'priority' => Moto\Util::getValue($item, 'priority', '0.5'), 'frequency' => Moto\Util::getValue($item, 'frequency'), ); } protected static function _isCanBeAdded($item) { if (!is_object($item)) { return false; } $properties = Moto\Util::getValue($item, 'properties'); if (!is_object($properties) && !is_array($properties)) { return true; } if (Moto\Util::getValue($properties, 'meta.noindex')) { return false; } if (method_exists($item, 'getAbsoluteUrl')) { $canonicalUrl = (string) Moto\Util::getValue($properties, 'meta.canonical_url'); $canonicalUrl = trim($canonicalUrl); if ($canonicalUrl !== '') { $absoluteUrl = $item->getAbsoluteUrl(); $absoluteUrl = trim($absoluteUrl); $absoluteUrl = rtrim($absoluteUrl, '/'); $absoluteUrl = strtolower($absoluteUrl); $canonicalUrl = rtrim($canonicalUrl, '/'); $canonicalUrl = strtolower($canonicalUrl); if ($canonicalUrl !== $absoluteUrl) { return false; } } } return true; } public static function getPublicWebsiteUrls() { $result = array(); $table = Moto\System::getDbTable('pages'); $table->useResultAsModel(true); $manager = Moto\System::app(Moto\System\ContentSection\ContentSectionManager::class); $providers = $manager->getAvailableProviders(); $types = [ 'main' => [], 'pages' => ['page'], 'taxonomies' => [], ]; foreach ($providers as $provider) { $types['main'][] = $provider->getMainPageType(); $types['pages'][] = $provider->getPostPageType(); $types['taxonomies'] = array_merge($types['taxonomies'], (array) $provider->getTaxonomyTypes()); } $where = new SqlWhere(); $tempWhere = new SqlWhere(); $tempWhere->addPredicates(array( 'type' => $types['pages'], 'status' => 'publish', 'visibility' => 'public', 'is_system' => 0, )); $tempWhere->lessThan('published', date('Y-m-d H:s:i')); $where->addPredicate($tempWhere, SqlWhere::COMBINED_BY_OR); if (!empty($types['main'])) { $tempWhere = new SqlWhere(); $tempWhere->addPredicates(array( 'type' => $types['main'], 'status' => 'publish', 'visibility' => 'public', )); $where->addPredicate($tempWhere, SqlWhere::COMBINED_BY_OR); } Moto\Hook::trigger(Moto\Hook::SITEMAP_WEBSITE_URLS_WHERE_CONDITION, $where); $select = $table->createSelect(); $select->where($where); $select->order(array('id' => 'ASC')); $items = $table->selectWith($select); foreach ($items as $item) { if ($item->getPageType()->isTemplate()) { continue; } if (!static::_isCanBeAdded($item)) { continue; } $record = static::fillUrlFromPage($item); if ($record && !empty($record['url'])) { if ($item->isMainPage()) { array_unshift($result, $record); } else { $result[] = $record; } } } $query = Moto\Database\Models\ContentTaxonomy::query(); $query->whereIn('type', $types['taxonomies']); Moto\Hook::trigger(Moto\Hook::SITEMAP_WEBSITE_CONTENT_TAXONOMY_QUERY, $query); $items = $query->get(); foreach ($items as $item) { if (!static::_isCanBeAdded($item)) { continue; } $record = static::fillUrlFromTaxonomy($item); if ($record && !empty($record['url'])) { $result[] = $record; } } $result = Moto\Hook::trigger(Moto\Hook::SITEMAP_WEBSITE_URLS, $result); return $result; } public static function generateAll() { static::_checkDependency(); Moto\Hook::trigger(Moto\Hook::SITEMAP_GENERATING); $settings = static::getSettings(); $sitemap = new Sitemap\UrlSetFile(); $sitemap->setFileName('@additionalSitemapsDir/website.xml'); $records = static::getPublicWebsiteUrls(); foreach ($records as $record) { $lastmod = $record['updated_at']; if (!empty($lastmod)) { $lastmod = explode(' ', $lastmod); $lastmod = $lastmod[0]; } $sitemap->addLocation($record['url'], array( 'lastmod' => $lastmod, 'priority' => $record['priority'], 'changefreq' => $record['frequency'], )); } $sitemap->write(); $indexFile = new Sitemap\IndexFile(); $indexFile->setFileName(static::$_primaryFile); $indexFile->addLocation($sitemap->getAbsoluteFileUrl(), array( 'lastmod' => $sitemap->getModificationTime('Y-m-d'), )); try { $externals = Moto\Util::getValue($settings, 'external_sitemaps'); $sitemap = new Sitemap\IndexFile(); $sitemap->setFileName('@additionalSitemapsDir/externals.xml'); $filter = new Moto\Filter\UriNormalize(array( 'removeFragment' => true, 'escapePath' => true, 'escapeQuery' => true, )); if (is_array($externals)) { foreach ($externals as $url) { $url = $filter->filter($url); $sitemap->addLocation($url); } } $externals = Moto\Hook::trigger(Moto\Hook::SITEMAP_EXTERNAL_SITEMAPS_LIST, array()); if (is_array($externals)) { foreach ($externals as $url) { $url = $filter->filter($url); $sitemap->addLocation($url); } } if ($sitemap->isEmpty()) { $sitemap->delete(); } else { $sitemap->write(); $indexFile->addLocation($sitemap->getAbsoluteFileUrl(), array( 'lastmod' => $sitemap->getModificationTime('Y-m-d'), )); } } catch (\Exception $e) { if (Moto\System::isDevelopmentStage()) { Moto\System\Log::emergency(__CLASS__ . '::' . __FUNCTION__ . ' catch Exception', array( 'code' => $e->getCode(), 'message' => $e->getMessage(), 'class' => get_class($e), )); } } $indexFile->write(); Moto\Hook::trigger(Moto\Hook::SITEMAP_GENERATED); } public static function addContentPreference($type, $options = []) { if (empty($options['owner']) || !is_string($options['owner'])) { throw new \Exception('Empty owner'); } $settings = static::getSettings(); foreach ($settings['content_preferences'] as $index => $preference) { if ($preference['type'] === $type) { return false; } } if (!array_key_exists('label', $options)) { $options['label'] = ucwords(str_replace(['.', '_', '-'], ' ', $type)); } $data = array_merge([ 'priority' => '0.5', 'frequency' => null, 'owner' => '', ], $options); $data['type'] = $type; $settings['content_preferences'][] = $data; static::saveSettings($settings); } public static function removeContentPreferences($types) { if (is_string($types)) { $types = [$types]; } if (!is_array($types)) { return false; } $settings = static::getSettings(); foreach ($types as $type) { foreach ($settings['content_preferences'] as $index => $preference) { if ($preference['type'] === $type) { $settings['content_preferences'][$index] = null; } } } $settings['content_preferences'] = array_filter($settings['content_preferences']); $settings['content_preferences'] = array_values($settings['content_preferences']); static::saveSettings($settings); } } 