<?php
 namespace Moto\Website; use Moto; use Zend\EventManager\Event; use Zend\Stdlib\ArrayUtils; use Illuminate; class Theme { const INFO_FILE = 'theme.json'; protected static $_defaultValues = array( 'headings' => array( 'type' => 'object', 'value' => array( 'heading1' => '0.67em', 'heading2' => '0em', 'heading3' => '0em', 'heading4' => '0em', ) ) ); protected static $_themesInfo = array(); protected static $_initialized = false; protected static $_options = array(); public static function setOption($name, $value) { static::$_options[$name] = $value; } public static function getOption($name, $default = null) { return Moto\Util::getFrom(static::$_options, $name, $default); } public static function init() { if (static::$_initialized) { return; } static::$_initialized = true; static::updateCurrentTheme(); } public static function updateCurrentTheme($name = null) { if (empty($name)) { $name = Moto\Website\Settings::get('theme'); } Moto\System::setPath('currentTheme', Moto\System::getPath('themes') . '/' . $name); } public static function activate($name, $mode = 'unknown') { $name = ($name instanceof Event ? $name->getTarget() : $name); static::deactivate(); Moto\Website\Settings::set('theme', $name); static::updateCurrentTheme($name); static::importFeatures($name); static::importColorTheme($name); static::importBackgrounds($name); static::importFonts($name); static::importTextStyles($name, $mode); $options = [ 'upgradeResponsive' => true, 'upgradeTextList' => true, 'properties' => [], ]; if ((bool) Moto\Features::isEnabled('theme_customized_lists_styles')) { $options['properties'] = array_merge($options['properties'], [ 'desktop.base.^ul li&', 'desktop.base.^ol li&', 'tablet.base.^ul li&', 'tablet.base.^ol li&', 'mobile-h.base.^ul li&', 'mobile-h.base.^ol li&', 'mobile-v.base.^ul li&', 'mobile-v.base.^ol li&', ]); } if (!Moto\Website\Theme::updateTextStylesFromNormal($options)) { throw new Moto\Exception('Cant update text styles from normal'); } static::importSpacings($name); static::importGridOptions($name); static::importHeadingSpacings($name); static::importPresetsEditKeys($name); static::importPresets($name, $mode); static::importCommonPresets($name); Moto\System\Style::rebuildAll(); return true; } public static function deactivate() { Moto\Features::disableByMask('theme'); } public static function getInfo($name = null) { if (null === $name) { $name = Moto\Website\Settings::get('theme'); } if (!array_key_exists($name, static::$_themesInfo)) { $infoFile = Moto\System::getAbsolutePath('@themes/' . $name . '/' . static::INFO_FILE); if (file_exists($infoFile)) { $info = file_get_contents($infoFile); static::$_themesInfo[$name] = json_decode($info, true); } } return (array_key_exists($name, static::$_themesInfo) ? static::$_themesInfo[$name] : null); } public static function getFeatures($name = null, $default = null) { $info = static::getInfo($name); if (array_key_exists('features', $info)) { return $info['features']; } return $default; } public static function importFeatures($name = null) { if (empty($name)) { $name = Moto\Website\Settings::get('theme'); } $features = static::getFeatures($name); Moto\Features::enable($features); } public static function importColorTheme($name = null) { if (empty($name)) { $name = Moto\Website\Settings::get('theme'); } $file = Moto\System::getAbsolutePath('@themes/' . $name . '/settings/colors.json'); if (!is_file($file)) { return false; } $data = file_get_contents($file); $data = json_decode($data, true); if (empty($data)) { return false; } Moto\Application\Styles\Service::setColorTheme($data); return true; } public static function importSpacings($name = null, $mode = 'activate') { if (empty($name)) { $name = Moto\Website\Settings::get('theme'); } $file = Moto\System::getAbsolutePath('@themes/' . $name . '/settings/values.json'); if (!is_file($file)) { return false; } $data = file_get_contents($file); $data = json_decode($data, true); if (empty($data) || empty($data['spacings'])) { return false; } if ($mode === 'activate') { Moto\Application\Theme\Service::setSpacings($data['spacings']); } return true; } public static function importGridOptions($name = null, $mode = 'activate') { if (empty($name)) { $name = Moto\Website\Settings::get('theme'); } $file = Moto\System::getAbsolutePath('@themes/' . $name . '/settings/values.json'); if (!is_file($file)) { return false; } $data = file_get_contents($file); $data = json_decode($data, true); if (empty($data) || empty($data['grid'])) { return false; } if ($mode === 'update') { $currentValue = Moto\Application\Theme\Service::getGridOptions(); if (is_object($currentValue)) { $currentValue = json_decode(json_encode($currentValue), true); } $data['grid'] = ArrayUtils::merge($data['grid'], $currentValue); } try { Moto\Application\Theme\Service::setGridOptions($data['grid']); } catch (Moto\Exception $e) { Moto\System\Log::critical('COMMON.ERROR.THEME_ACTIVATION_FAILED:BAG_GRID_OPTIONS', array('theme' => $name, 'errors' => $e->getErrors())); throw $e; } return true; } public static function importHeadingSpacings($name = null, $mode = 'activate') { if (empty($name)) { $name = Moto\Website\Settings::get('theme'); } $file = Moto\System::getAbsolutePath('@themes/' . $name . '/settings/values.json'); if (!is_file($file)) { return false; } $data = file_get_contents($file); $data = json_decode($data, true); if (empty($data) || empty($data['headings'])) { return false; } if ($mode === 'update') { $currentValue = Moto\Application\Theme\Service::getHeadingSpacings(); if (is_object($currentValue)) { $currentValue = json_decode(json_encode($currentValue), true); } $data['headings'] = ArrayUtils::merge($data['headings'], $currentValue); } try { Moto\Application\Theme\Service::setHeadingSpacings($data['headings']); } catch (Moto\Exception $e) { Moto\System\Log::critical('COMMON.ERROR.THEME_ACTIVATION_FAILED:BAD_HEADING_SPACINGS', array('theme' => $name, 'errors' => $e->getErrors())); throw $e; } return true; } public static function importPresetsEditKeys($name = null) { if (empty($name)) { $name = Moto\Website\Settings::get('theme'); } $file = Moto\System::getAbsolutePath('@themes/' . $name . '/settings/config.json'); if (!is_file($file)) { Moto\Website\Settings::set('theme_presets', '{}'); return false; } $data = file_get_contents($file); $data = json_decode($data, true); if (!$data || empty($data) || empty($data['presets'])) { Moto\Website\Settings::set('theme_presets', '{}'); return false; } Moto\Website\Settings::set('theme_presets', $data['presets']); return true; } public static function importBackgrounds($name = null) { if (empty($name)) { $name = Moto\Website\Settings::get('theme'); } $file = Moto\System::getAbsolutePath('@themes/' . $name . '/settings/backgrounds.json'); if (!is_file($file)) { return false; } $data = file_get_contents($file); $data = json_decode($data, true); if (empty($data)) { return false; } $table = new Moto\Application\Styles\StylesTable(); $table->useResultAsModel(true); foreach ($data as $background) { if (!array_key_exists('class_name', $background)) { continue; } if (array_key_exists('id', $background)) { unset($background['id']); } if (array_key_exists('name', $background)) { unset($background['name']); } $item = $table->getByClassName($background['class_name']); if (!$item) { continue; } $item->setFromArray($background); $table->save($item); } return true; } public static function importFonts($name = null) { if (empty($name)) { $name = Moto\Website\Settings::get('theme'); } $file = Moto\System::getAbsolutePath('@themes/' . $name . '/settings/fonts.json'); if (!is_file($file)) { return false; } $data = file_get_contents($file); $data = json_decode($data, true); if (empty($data)) { return false; } try { Moto\Database\Models\Font::query()->update(['is_protected' => false]); } catch (\Exception $e) { } foreach ($data as $font) { if (!array_key_exists('family', $font)) { continue; } if (empty($font['name'])) { $font['name'] = $font['family']; } if (!empty($font['lastModified']) && empty($font['last_modified'])) { $font['last_modified'] = $font['lastModified']; } if (!empty($font['provider']) && $font['provider'] === 'google' && !strpos($font['family'], ',') && !empty($font['category'])) { $font['family'] = "'$font[family]', $font[category]"; } if (empty($font['is_protected'])) { $font['is_protected'] = 1; } $item = Moto\Database\Models\Font::where('name', $font['name'])->first(); if (!$item) { $item = new Moto\Database\Models\Font(); } $item->fill($font); $item->save(); } return true; } public static function importTextStyles($name = null, $mode = 'install') { $debug = false; if (empty($name)) { $name = Moto\Website\Settings::get('theme'); } if ($debug) { Moto\System\Log::debug(__FUNCTION__ . " " . var_export([ 'name' => $name, 'mode' => $mode, ], true)); } $file = Moto\System::getAbsolutePath('@themes/' . $name . '/settings/text-styles.json'); if (!is_file($file)) { return false; } $data = file_get_contents($file); $data = json_decode($data, true); if (empty($data)) { return false; } $table = new Moto\Application\Styles\StylesTable(); $table->useResultAsModel(true); $default = array( 'is_responsive' => 0, 'properties' => array( 'desktop' => array( 'base' => array( 'font-weight' => '400', 'font-style' => 'normal', ), ) ), 'link' => array( 'desktop' => array( 'base' => array( 'font-weight' => '400', 'font-style' => 'normal', ), 'hover' => array( 'font-weight' => '400', 'font-style' => 'normal', ), ) ), ); $nameIsRewritable = ($mode === 'install'); $query = Moto\Database\Models\Style::query() ->where('type', 'text'); $collection = new Illuminate\Support\Collection($data); $normal = $collection->firstWhere('class_name', 'moto-text_normal'); if ($normal) { if ($debug) { Moto\System\Log::debug('Normal style founded'); } $normal['properties'] = ArrayUtils::merge($default['properties'], $normal['properties']); $normal = (object) $normal; Moto\Update\Upgrade::upgradeResponsiveTextStyle($normal); Moto\Update\Upgrade::fixTextListStylePrefix($normal); $normal = (array) $normal; } else { Moto\System\Log::critical('[' . __CLASS__ . '::' . __FUNCTION__ . '] : Normal style not found on text-styles.json for theme ' . var_export($name, true)); } foreach ($collection as $index => $style) { if (!array_key_exists('class_name', $style)) { continue; } if (array_key_exists('id', $style)) { unset($style['id']); } $style['is_system'] = (boolean) Moto\Util::getValue($style, 'is_system'); $item = $table->getByClassName($style['class_name']); $isExists = (boolean) $item; if ($debug) { Moto\System\Log::debug("Dump => " . var_export([ 'style' => Moto\Util::arrayOnly($style, ['id', 'name', 'class_name', 'is_system']), 'mode' => $mode, 'isExists' => $isExists, ], true)); } if ($mode === 'update') { if ($isExists) { Moto\Update\Upgrade::upgradeResponsiveTextStyle($item); Moto\Update\Upgrade::fixTextListStylePrefix($item); $table->save($item); continue; } if (!$style['is_system']) { continue; } } if (!$item) { $item = new Moto\Application\Styles\StyleModel(); $check = clone $query; $check->where('name', $style['name']); if ($check->exists()) { for ($i = 2; $i < 255; $i++) { $newName = $style['name'] . ' ' . $i; $check = clone $query; $check->where('name', $newName); if (!$check->exists()) { $style['name'] = $newName; break; } } } $item->name = $style['name']; } if (!$nameIsRewritable) { unset($style['name']); } $item->is_responsive = 0; if ($normal && $style['class_name'] !== $normal['class_name']) { if (!empty($normal['properties'])) { $style['properties'] = ArrayUtils::merge($normal['properties'], $style['properties']); } if (!empty($normal['link'])) { $style['link'] = ArrayUtils::merge($normal['link'], $style['link']); } } $style = (object) $style; Moto\Update\Upgrade::upgradeResponsiveTextStyle($style); Moto\Update\Upgrade::fixTextListStylePrefix($style); $style = (array) $style; $item->setFromArray($style); Moto\Update\Upgrade::upgradeResponsiveTextStyle($item); Moto\Update\Upgrade::fixTextListStylePrefix($item); $table->save($item); } return true; } public static function updateTextStylesFromNormal($options = []) { $normal = Moto\Database\Models\Style::query() ->where('type', 'text') ->where('class_name', 'moto-text_normal') ->first(); if (!$normal) { Moto\System\Log::critical('Default text style not found'); return false; } Moto\Update\Upgrade::fixTextListStylePrefix($normal); $options['upgradeResponsive'] = Moto\Util::getValue($options, 'upgradeResponsive', false); $options['upgradeTextList'] = Moto\Util::getValue($options, 'upgradeTextList', false); $options['properties'] = Moto\Util::getValue($options, 'properties', []); $options['link'] = Moto\Util::getValue($options, 'link', []); $defaults = [ 'properties' => [], 'link' => [], ]; if (is_array($options['properties'])) { foreach ($options['properties'] as $property) { $temp = Moto\Util::getValue($normal->properties, $property); if ($temp) { Moto\Util::setToArrayDeep($defaults['properties'], $property, $temp); } } } elseif ($options['properties']) { $defaults['properties'] = $normal->properties; } if (is_array($options['link'])) { foreach ($options['link'] as $property) { $temp = Moto\Util::getValue($normal->link, $property); if ($temp) { Moto\Util::setToArrayDeep($defaults['link'], $property, $temp); } } } elseif ($options['link']) { $defaults['link'] = $normal->link; } $query = Moto\Database\Models\Style::query() ->where('type', 'text'); $ignore = Moto\Util::getValue($options, 'ignore'); if (is_array($ignore)) { $query->whereNotIn('id', $ignore); } $styles = $query->get(); foreach ($styles as $style) { if ($options['upgradeResponsive']) { Moto\Update\Upgrade::upgradeResponsiveTextStyle($style); } if ($options['upgradeTextList']) { Moto\Update\Upgrade::fixTextListStylePrefix($style); } if (!empty($defaults['properties'])) { $style['properties'] = ArrayUtils::merge($defaults['properties'], $style['properties']); } if (!empty($defaults['link'])) { $style['link'] = ArrayUtils::merge($defaults['link'], $style['link']); } $style->save(); } return true; } public static function importPresets($name = null, $mode = 'install') { if (empty($name)) { $name = Moto\Website\Settings::get('theme'); } $isUpdate = ($mode === 'update'); if (!$isUpdate) { Moto\Database\Models\Preset::query()->where('is_system', true)->delete(); } $file = Moto\System::getAbsolutePath('@themes/' . $name . '/settings/presets.json'); if (!is_file($file)) { return false; } $data = file_get_contents($file); $data = json_decode($data, true); if (!$data || empty($data)) { return false; } foreach ($data as $preset) { if (!array_key_exists('class_name', $preset)) { continue; } if (!array_key_exists('widget_name', $preset)) { continue; } $preset['class_name'] = trim($preset['class_name']); $preset['widget_name'] = trim($preset['widget_name']); if (Moto\Util::getValue($preset, 'provider') !== 'custom' && !empty($preset['is_system']) && $preset['is_system'] && preg_match('/^moto-preset-(.+)$/', $preset['class_name'], $match)) { $name = trim($match[1]); if ($name === 'default') { $name = '1'; } $name = 'Preset ' . $name; $preset['name'] = $name; } $item = null; if ($isUpdate) { $item = Moto\Database\Models\Preset::where([ 'widget_name' => $preset['widget_name'], 'class_name' => $preset['class_name'], 'is_system' => true, ])->first(); } if ($item) { $current = $item->properties; if (is_object($current)) { $current = json_encode($current); } if (is_string($current)) { $current = json_decode($current, true); } if (is_array($current)) { $mergedProperties = ArrayUtils::merge($preset['properties'], $current); } else { $mergedProperties = $preset['properties']; } $item->properties = $mergedProperties; } else { $item = new Moto\Database\Models\Preset($preset); } $item->save(); } return true; } public static function importCommonPresets() { Moto\Update\Upgrade::checkAndCreateAudioPlayerPreset(); Moto\Update\Upgrade::checkAndCreateCountdownPresets(); Moto\Update\Upgrade::checkAndCreateAccordionPresets(); Moto\Update\Upgrade::checkAndCreateSocialLinksExtendedPresets(); Moto\Update\Upgrade::upgradeBackToTopButton(); Moto\Update\Upgrade::checkAndCreateTabsPresets(); Moto\Update\Upgrade::checkAndCreateCookieNotificationPresets(); Moto\Update\Upgrade::upgradeTabsPresetsForVerticalMode(); Moto\Update\Upgrade::checkAndCreateTileGalleryPresets(); Moto\Update\Upgrade::checkAndCreateTagListPresets(); Moto\Update\Upgrade::checkAndCreateCategoryListPresets(); Moto\Update\Upgrade::checkAndCreateContentSliderPresets(); Moto\Update\Upgrade::checkAndCreateMotoCallbackPresets(); Moto\Update\Upgrade::checkAndCreateBreadcrumbsPresets(); Moto\Update\Upgrade::upgradeBreadcrumbsPreset(); Moto\Update\Upgrade::checkAndCreateFormElementsPresets(); Moto\Update\Upgrade::upgradeContentSliderPresetForAutoControls(); Moto\Update\Upgrade::updateCategoryListPresetsForPostsCounter(); Moto\Update\Upgrade::checkAndCreateTablePresets(); Moto\Update\Upgrade::updateDividerPresetsForDirections(); Moto\Update\Upgrade::updateSliderPresetsForThumbnailPagination(); Moto\Update\Upgrade::checkAndCreateBlogFiltersPresets(); Moto\Update\Upgrade::checkAndCreateCalendarPresets(); if (Moto\Features::isEnabled('theme_content_blog')) { $preset = Moto\Database\Models\Preset::where([ 'widget_name' => 'pagination', 'class_name' => 'moto-preset-default', 'is_system' => true, ])->first(); if (!$preset) { $preset = new Moto\Database\Models\Preset(); $preset->fill(array( 'name' => 'Pagination 1', 'widget_name' => 'pagination', 'class_name' => 'moto-preset-default', 'is_system' => 1, 'is_responsive' => 0, 'properties' => '{"pagination":{"desktop":{"base":{"font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400","font-size":"14px"}}},"item":{"desktop":{"base":{"margin-right":"5px"}}},"item_link_active":{"desktop":{"base":{"font-style":"normal","font-weight":"700","color":"#2e3a46","background-color":"","border-color":"transparent","text-decoration":"none"}}},"item_link":{"desktop":{"base":{"color":"#81868c","background-color":"transparent","border-color":"transparent","border-width":"1px","border-radius":"0%","border-style":"solid","text-decoration":"none","width":"31px","height":"31px"},"hover":{"color":"#d3d8db","background-color":"","border-color":"","text-decoration":""}}}}', 'template' => 'default', )); try { $preset->save(); } catch (\Exception $e) { } } } } public static function importContentSections($name = null, $types = array('blog')) { Moto\System\Log::info('[Theme] : Import Content Sections : start'); if (empty($name)) { $name = Moto\Website\Settings::get('theme'); } if (!is_array($types)) { $types = array($types); } $config = array(); $file = Moto\System::getAbsolutePath('@themes/' . $name . '/settings/config.json'); if (is_file($file)) { $config = file_get_contents($file); $config = json_decode($config, true); } $manager = Moto\System::app(Moto\System\ContentSection\ContentSectionManager::class); foreach ($types as $type) { if (!Moto\Features::isEnabled('theme_content_' . $type)) { continue; } $provider = $manager->getProvider($type); if (!$provider) { Moto\System\Log::warning('[Theme] Content Provider "' . $type . '" is not registered'); continue; } $helper = $provider->getHelper(); if ($helper->isConfigured()) { continue; } $settings = Moto\Util::getValue($config, 'content_section_' . $type, null); if ($settings) { unset($settings['page_id']); $helper->updateDefaultSettings($settings); } $helper->checkOrInstall(); } $manager->saveConfiguration(); Moto\System\Log::info('[Theme] : Import Content Sections : done'); return true; } public static function getDefaultValue($name) { $data = Moto\Util::getValue(static::$_defaultValues, $name); if (!$data) { return null; } return Moto\Util::decodeValue($data['value'], $data['type']); } } 