<?php
 namespace Website\Widgets\Blog; use Illuminate\Database\Eloquent\Builder; use Illuminate\Support\Facades\Event; use Moto; use Website; class RecentPostsWidget extends Website\Widgets\Blog\AbstractPostsWidget { protected $_name = 'blog.recent_posts'; protected static $_defaultProperties = array( 'visible_on' => 'mobile-v', 'spacing' => array( 'top' => 'auto', 'right' => 'auto', 'bottom' => 'auto', 'left' => 'auto', ), 'item_count' => 5, 'filter' => [ 'type' => 'none', 'categories' => [], 'tags' => [], ], 'layout' => [ 'name' => 'default', 'settings' => [ ], 'elements' => [ 'post' => [ 'properties' => [ 'styles' => [ 'background-color' => '', ], 'spacing' => [ 'top' => 'small', 'right' => 'auto', 'bottom' => 'auto', 'left' => 'auto', ], ], 'children' => [ 'heading' => [ 'properties' => [ 'spacing' => [ 'top' => 'small', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ], ], ], 'title' => [ 'properties' => [ 'spacing' => [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ], ], ], 'image' => [ 'visible' => true, 'properties' => [ 'align' => [ 'desktop' => 'left', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '', ], 'spacing' => [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ], ], ], 'date' => [ 'visible' => false, 'properties' => [ 'font_style' => 'moto-text_system_11', 'align' => [ 'desktop' => 'left', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '', ], 'spacing' => [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ], ], ], 'author' => [ 'visible' => false, 'properties' => [ 'font_style' => 'moto-text_system_11', 'align' => [ 'desktop' => 'left', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '', ], 'spacing' => [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ], ], ], 'description' => [ 'visible' => false, 'properties' => [ 'spacing' => [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ], ], ], 'button' => [ 'visible' => false, 'properties' => [ 'label' => 'Read More', 'preset' => 'default', 'size' => 'small', 'align' => [ 'desktop' => 'left', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '', ], 'spacing' => [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ], ], ], ], ], ], ], 'label' => '', 'style' => array( 'heading' => array( 'font_style' => 'moto-text_system_7', 'align' => [ 'desktop' => 'left', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '', ], ), 'title' => array( 'font_style' => 'moto-text_system_8', 'align' => [ 'desktop' => 'left', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '', ], ), 'feature_image' => array( 'preset' => 'default', ), ), ); protected $_posts = null; protected $_paginator = null; protected $_slots = [ 'date' => [ 'path' => 'layout.elements.post.children.date', 'widget' => '@post_published_on', ], ]; public function getTemplatePath($preset = null) { return '@websiteWidgets/content_sections/templates/recent_records.twig.html'; } public function getPosts() { if ($this->_posts === null) { $this->_posts = $this->getPaginator() ->getCurrentItems(); } return $this->_posts; } public function getPaginator() { if ($this->_paginator) { return $this->_paginator; } $count_post = $this->getPropertyValue('item_count') * 1; $count_post = max(1, $count_post); $count_post = min(20, $count_post); $query = Moto\Database\Models\Page::query(); $with = []; if ($this->getPropertyValue('layout.elements.post.children.author.visible')) { $with[] = 'author'; } if ($this->getPropertyValue('layout.elements.post.children.taxonomy.visible')) { $with[] = 'taxonomies'; } if (count($with) > 0) { $query->with($with); } $query->where('type', $this->getFirstName() . '.post'); Moto\Database\Models\Page::addPublishedPageCondition($query); $this->applyPostQuery($query); Event::dispatch(new Events\RecentPostsQueryEvent($query, $this)); $query->orderBy('published', 'DESC'); $query->limit($count_post); $this->_paginator = $query->paginate($count_post, [ 'id', 'parent_id', 'author_id', 'category_id', ], 'page', 1); $this->_paginator = new Helper\PaginatorWrapper($this->_paginator); return $this->_paginator; } protected function applyPostQuery(Builder $query) { $type = $this->getPropertyValue('filter.type'); if ($type === 'none' || empty($type)) { return $query; } if ($type === 'categories') { $categories = (array) $this->getPropertyValue('filter.categories'); if (!empty($categories)) { $query->whereIn('category_id', $categories); } } else { $taxonomies = (array) $this->getPropertyValue('filter.' . $type); if (!empty($taxonomies)) { $query->whereHas('taxonomies', function ($query) use ($taxonomies) { $query->whereIn('id', $taxonomies); return $query; }); } } return $query; } public function getColumnWidth() { return (int) round(12 / max(1, (int) $this->getPropertyValue('layout.settings.columns', 1))); } public function getInnerWidgetProperties($name, $post = null) { $properties = []; $prefix = $this->getFirstName(); switch ($name) { case $prefix . '.post_published_on': case '#date': case '@post_published_on': $properties = [ 'font_style' => $this->getPropertyValue('layout.elements.post.children.date.properties.font_style', 'moto-text_system_11'), 'align' => $this->getPropertyValue('layout.elements.post.children.date.properties.align', 'left'), 'spacing' => $this->getPropertyValue('layout.elements.post.children.date.properties.spacing', [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ]), ]; break; case $prefix . '.post_author': case '@post_author': $properties = [ 'font_style' => $this->getPropertyValue('layout.elements.post.children.author.properties.font_style', 'moto-text_system_11'), 'align' => $this->getPropertyValue('layout.elements.post.children.author.properties.align', 'left'), 'spacing' => $this->getPropertyValue('layout.elements.post.children.author.properties.spacing', [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ]), ]; break; case 'image': if (!is_object($post) || !method_exists($post, 'getAbsoluteUrl')) { return null; } $properties = [ 'link' => [ 'action' => 'url', 'properties' => [ 'url' => $post->getAbsoluteUrl(), ], ], 'src' => Moto\Util::getValue($post, 'properties.feature_media.src'), 'alt' => Moto\Util::getValue($post, 'properties.feature_media.alt'), 'title' => Moto\Util::getValue($post, 'properties.feature_media.title'), 'preset' => $this->getDesignOption('feature_image.preset', 'default'), 'align' => $this->getPropertyValue('layout.elements.post.children.image.properties.align', 'left'), 'animation' => '', 'spacing' => $this->getPropertyValue('layout.elements.post.children.image.properties.spacing', [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ]), ]; break; case 'button': if (!is_object($post) || !method_exists($post, 'getAbsoluteUrl')) { return null; } $properties = [ 'link' => [ 'action' => 'url', 'properties' => [ 'url' => $post->getAbsoluteUrl(), ], ], 'label' => $this->getPropertyValue('layout.elements.post.children.button.properties.label', 'Read More'), 'preset' => $this->getPropertyValue('layout.elements.post.children.button.properties.preset', 'default'), 'size' => $this->getPropertyValue('layout.elements.post.children.button.properties.size', 'small'), 'align' => $this->getPropertyValue('layout.elements.post.children.button.properties.align', 'left'), 'animation' => '', 'spacing' => $this->getPropertyValue('layout.elements.post.children.button.properties.spacing', [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ]), ]; break; } return $properties; } public function getInnerWidget($name, $post = null) { $properties = $this->getInnerWidgetProperties($name, $post); $widgetName = $this->resolveInnerWidgetName($name, $properties, $post); $widget = Moto\System\Widgets\Factory::create([ 'name' => $widgetName, 'properties' => $properties, ]); if ($widget instanceof PostTaxonomyWidget) { $widget->setCurrentPage($post); } return $widget; } protected function resolveInnerWidgetName($name, array $properties, $post = null) { $widgetName = $name; if ($widgetName[0] === '@') { $widgetName = str_replace('@', $this->getFirstName() . '.', $widgetName); } if (Moto\Util::getValue($properties, 'taxonomy.name') === 'category') { $widgetName = $this->getFirstName() . '.post_category'; } return $widgetName; } public function getWidgetForSlot($name, $post) { if (!array_key_exists($name, $this->_slots)) { if (Moto\System::isDevelopmentStage()) { Moto\System\Log::emergency(__METHOD__ . ' slot ' . var_export($name, true) . ' not defined'); } return null; } $slot = $this->_slots[$name]; $properties = $this->getInnerWidgetProperties('#' . $name, $post); if (empty($properties)) { if (Moto\System::isDevelopmentStage()) { Moto\System\Log::emergency(__METHOD__ . ' empty properties for slot ' . var_export($name, true)); } return null; } $widgetName = $this->getPropertyValue($slot['path'] . '.widget'); if (empty($widgetName)) { $widgetName = $slot['widget']; } $widgetName = $this->resolveInnerWidgetName($widgetName, $properties, $post); $widget = Moto\System\Widgets\Factory::create([ 'name' => $widgetName, 'properties' => $properties, ]); if ($widget instanceof PostTaxonomyWidget) { $widget->setCurrentPage($post); } if ($widget instanceof WidgetAboutPostInterface) { $widget->setCurrentPost($post); } return $widget; } public function getInnerRecordListWidgetProperties() { return [ 'version' => 1, 'item_count' => $this->getPropertyValue('item_count', 5), 'page' => 1, 'read_more_label' => $this->getPropertyValue('layout.elements.post.children.button.properties.label', ''), 'style' => [ 'title' => [ 'font_style' => $this->getDesignOption('title.font_style', 'moto-text_system_8'), ], 'meta' => [ 'font_style' => $this->getPropertyValue('layout.elements.post.children.date.properties.font_style', 'moto-text_system_11'), ], 'author' => [ 'font_style' => $this->getPropertyValue('layout.elements.post.children.author.properties.font_style', 'moto-text_system_11'), ], 'button' => [ 'preset' => $this->getPropertyValue('layout.elements.post.children.button.properties.preset', 'default'), 'size' => $this->getPropertyValue('layout.elements.post.children.button.properties.size', 'small'), ], ], 'layout' => [ 'name' => $this->getPropertyValue('layout.name', 'default'), 'settings' => $this->getPropertyValue('layout.settings', []), 'elements' => [ 'post' => [ 'name' => 'blog.post_list.post', 'properties' => [ 'styles' => [ 'background-color' => $this->getPropertyValue('layout.elements.post.properties.styles.background-color', ''), ], ], 'children' => [ 'image' => [ 'name' => 'blog.post_list.featured_image', 'visible' => $this->getPropertyValue('layout.elements.post.children.image.visible', true), 'properties' => [ 'spacing' => $this->getPropertyValue('layout.elements.post.children.image.properties.spacing', [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ]), ], ], 'content' => [ 'name' => 'blog.post_list.content', 'properties' => [ 'spacing' => $this->getPropertyValue('layout.elements.post.properties.spacing', [ 'top' => 'small', 'right' => 'auto', 'bottom' => 'auto', 'left' => 'auto', ]), ], 'children' => [ 'title' => [ 'properties' => [ 'spacing' => $this->getPropertyValue('layout.elements.post.children.title.properties.spacing', [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ]), ], ], 'description' => [ 'visible' => $this->getPropertyValue('layout.elements.post.children.description.visible', false), 'properties' => [ 'spacing' => $this->getPropertyValue('layout.elements.post.children.description.properties.spacing', [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ]), ], ], 'button' => [ 'visible' => $this->getPropertyValue('layout.elements.post.children.button.visible', false), 'properties' => [ 'spacing' => $this->getPropertyValue('layout.elements.post.children.button.properties.spacing', [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ]), ], ], 'date' => [ 'widget' => $this->getPropertyValue('layout.elements.post.children.date.widget', '@post_published_on'), 'visible' => $this->getPropertyValue('layout.elements.post.children.date.visible', false), 'properties' => [ 'spacing' => $this->getPropertyValue('layout.elements.post.children.date.properties.spacing', [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ]), ], ], 'author' => [ 'visible' => $this->getPropertyValue('layout.elements.post.children.author.visible', false), 'properties' => [ 'spacing' => $this->getPropertyValue('layout.elements.post.children.author.properties.spacing', [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ]), ], ], ], ], ], ], 'pagination' => [ 'visible' => false, ], ], ], 'contentAlignment' => [ 'title' => $this->getPropertyValue('style.title.align', [ 'desktop' => 'left', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '', ]), 'date' => $this->getPropertyValue('layout.elements.post.children.date.properties.align', [ 'desktop' => 'left', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '', ]), 'author' => $this->getPropertyValue('layout.elements.post.children.author.properties.align', [ 'desktop' => 'left', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '', ]), 'image' => $this->getPropertyValue('layout.elements.post.children.image.properties.align', [ 'desktop' => 'left', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '', ]), 'button' => $this->getPropertyValue('layout.elements.post.children.button.properties.align', [ 'desktop' => 'left', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '', ]), ], ]; } public function getInnerRecordListWidget() { $widget = Moto\System\Widgets\Factory::create([ 'id' => $this->getWidgetId() . '_post_list', 'name' => $this->getFirstName() . '.post_list', 'properties' => $this->getInnerRecordListWidgetProperties(), ]); $widget->setRenderingOption('showingContent', true); $widget->setRenderingOption('ignoreQueryFilter', true); $widget->setPaginator($this->getPaginator()); return $widget; } } 