<?php
namespace Website\Widgets\GoogleSearch; use Moto; use Website\Widgets\GoogleSearch; class ResultsWidget extends Moto\System\Widgets\AbstractWidget { protected $_name = 'google_search.results'; protected static $_defaultProperties = array( 'noResultsMessage' => 'No Results', 'resultLinksTarget' => '_blank', 'resultsPerPage' => 10, 'language' => '', 'cacheLifetimeHours' => 3, 'searchEngine' => '', 'useHtmlSnippet' => false, 'item' => [ 'spacing' => [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ], ], 'divider' => [ 'enabled' => true, 'properties' => [ 'preset' => 'default', 'spacing' => [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'small', 'left' => 'auto', ], ], ], 'textStyles' => [ 'title' => 'moto-text_normal', 'link' => 'moto-text_normal', 'snippet' => 'moto-text_normal', 'noResultsMessage' => 'moto-text_normal', ], 'align' => [ 'desktop' => 'left', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '', ], 'spacing' => [ 'top' => 'auto', 'right' => 'auto', 'bottom' => 'auto', 'left' => 'auto' ], 'animation' => '' ); protected $_templateType = 'templates'; protected $_widgetId = true; public function getTemplatePath($preset = null) { return '@websiteWidgets/google_search/templates/results.twig.html'; } public function getCurrentQuery() { return Moto\System\Request::getPost('searchQuery'); } public function getBlankResults() { $BLANK_CONTENT = [ 'title' => 'Lorem ipsum dolor sit amet', 'link' => Moto\Website\Settings::get('address'), 'htmlSnippet' => 'Lorem <b>ipsum</b> dolor sit amet, <b>consectetur</b> adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 'snippet' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', ]; $result = []; for ($i = 1; $i <= $this->getPropertyValue('resultsPerPage'); $i++) { $result[] = $BLANK_CONTENT; } return $result; } public function getTokenRequest() { if ($this->isPreviewMode()) { return null; } $engine = GoogleSearch\Service::getSearchEngine($this->getPropertyValue('searchEngine')); if (!$engine) { return null; } $params = [ 'engine' => $this->getPropertyValue('searchEngine'), 'language' => $this->getPropertyValue('language'), 'perPage' => (int) $this->getPropertyValue('resultsPerPage', 10), 'cacheLifetime' => ((int) $this->getPropertyValue('cacheLifetimeHours')) * 60, ]; return GoogleSearch\Service::generateToken($this->getCurrentQuery(), $params); } public function exportFrontendSettings() { return [ 'searchQuery' => $this->getCurrentQuery(), 'link' => [ 'target' => $this->getPropertyValue('resultLinksTarget'), ], 'item' => [ 'classes' => $this->getSpacingClasses($this->getPropertyValue('item.spacing')), 'textStyles' => [ 'title' => $this->getPropertyValue('textStyles.title'), 'link' => $this->getPropertyValue('textStyles.link'), 'snippet' => $this->getPropertyValue('textStyles.snippet'), 'noResultsMessage' => $this->getPropertyValue('textStyles.noResultsMessage'), ], ], 'divider' => [ 'enabled' => $this->getPropertyValue('divider.enabled'), 'preset' => $this->getPropertyValue('divider.properties.preset'), 'classes' => $this->getSpacingClasses($this->getPropertyValue('divider.properties.spacing')) . ' moto-preset-' . $this->getPropertyValue('divider.properties.preset'), ], ]; } public function getItemSnippet($item) { if ($this->getPropertyValue('useHtmlSnippet')) { return new \Twig_Markup(Moto\Util::getValue($item, 'htmlSnippet', ''), 'UTF-8'); } return Moto\Util::getValue($item, 'snippet', ''); } } 