<?php
namespace Website\Widgets\MailChimp; use Moto; use Zend; class Api extends Moto\AbstractClass { protected $_apikey; protected $_options = array( 'defaultUrl' => 'https://{{apiLogin}}:{{apiKey}}@{{dataCenter}}.api.mailchimp.com/3.0', 'apiLogin' => 'apikey', 'dataCenter' => '', 'curlOptions' => array( CURLOPT_CONNECTTIMEOUT => 15, CURLOPT_TIMEOUT => 25, CURLOPT_SSL_VERIFYHOST => 0, CURLOPT_SSL_VERIFYPEER => false, ) ); public function setApikey($key) { $key = trim($key); $this->_options['apikey'] = $key; if (preg_match('/-([0-9a-z]+)$/', $key, $match)) { $this->setOption('dataCenter', $match[1]); } } public function getApiUrl($apiMethod = '') { $url = $this->getOption('defaultUrl'); $data = array( 'dataCenter' => $this->getOption('dataCenter'), 'apiLogin' => $this->getOption('apiLogin', 'apikey'), 'apiKey' => $this->getOption('apikey'), ); $url = Moto\Util::simpleRender($url, $data); return $url . '/' . ltrim($apiMethod, '/'); } public function get($method, $params = array()) { return $this->_makeRequest($method, 'GET', $params); } public function postListMembers($id, $data = array()) { $method = 'lists/' . $id . '/members'; $params = array( 'email_address' => $data['email'], 'status' => $data['status'], ); if (!empty($data['merge_fields'])) { $params['merge_fields'] = $data['merge_fields']; } else { if (!empty($data['name'])) { $params['merge_fields']['FNAME'] = $data['name']; } if (!empty($data['surname'])) { $params['merge_fields']['LNAME'] = $data['surname']; } if (!empty($data['checkbox'])) { $params['merge_fields']['AGREEMENT'] = 'YES'; } } $params['ip_signup'] = (empty($data['ip_signup']) ? Moto\System\Request::getIp() : $data['ip_signup']); return $this->post($method, $params); } public function post($method, $params = array()) { return $this->_makeRequest($method, 'POST', $params); } protected function _makeRequest($apiMethod, $httpMethod = 'GET', $params = array()) { $url = $this->getApiUrl($apiMethod); $curlOptions = $this->getOption('curlOptions'); $options = array( 'maxredirects' => 1, 'curloptions' => $curlOptions, ); $client = new Moto\Http\Client($url, $options); $client->setMethod($httpMethod); switch($httpMethod) { case 'POST': $client->setRawBody(json_encode($params, JSON_FORCE_OBJECT)); break; case 'GET': $client->setParameterGet($params); break; } $client->send(); $adapter = $client->getAdapter(); $httpError = []; if ($adapter instanceof Zend\Http\Client\Adapter\Curl) { $handle = $adapter->getHandle(); $httpError['code'] = curl_errno($handle); $httpError['message'] = curl_error($handle); $httpError['name'] = Moto\Http\Client::getCurlErrorName($httpError['code']); } $response = $client->getResponse(); $adapter->close(); $result = $response->getBody(); $result = json_decode($result, true); if ($client->hasErrors() || $response->getStatusCode() >= 400) { $status = (empty($result['status']) ? $response->getStatusCode() : $result['status']); $message = (empty($result['title']) ? 'COMMON.ERROR.NETWORK' : 'COMMON.ERROR.' . strtoupper(str_replace(' ', '_', $result['title']))); $error = array( 'status' => $status ); if (!empty($result['title'])) { $error['title'] = $result['title']; } if (!empty($result['type'])) { $error['type'] = $result['type']; } if (!empty($result['detail'])) { $error['detail'] = $result['detail']; } if (!empty($httpError)) { $error['httpError'] = $httpError; } throw new Moto\System\Exception($message, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $error); } $result = $this->_sanitizeResult($result, $apiMethod); return $result; } protected function _sanitizeResult($result, $key) { $key = trim($key); $key = trim($key, '/'); if (!empty($key) && array_key_exists($key, $result)) { $result = $result[$key]; } if (!empty($result['_links'])) { unset($result['_links']); } return $result; } } 