<?php
namespace Website\Widgets\SocialButtons; use Moto; class Widget extends Moto\System\Widgets\AbstractWidget { protected $_name = 'social_buttons'; protected $_currentPage; protected $_currentPageUrl = ''; protected static $_defaultProperties = array( 'preset' => 'default', 'spacing' => array( 'top' => 'auto', 'right' => 'auto', 'bottom' => 'auto', 'left' => 'auto', ), 'align' => array( 'desktop' => 'left', 'tablet' => '', 'mobile-v' => '', 'mobile-h' => '', ), 'buttons' => array(), ); protected $_templateType = 'templates'; protected $_widgetId = true; public function init() { $this->_migrateProperties(); parent::init(); } protected function _migrateProperties() { $version = Moto\Util::getValue($this->properties, 'version', 0); if ($version === 0) { foreach ($this->properties['buttons'] as $index => $button) { if (Moto\Util::getValue($button, 'provider') === 'google_plus') { unset($this->properties['buttons'][$index]); } } $this->properties['buttons'] = array_values($this->properties['buttons']); $this->properties['version'] = 1; } } public function setCurrentPage($currentPage) { if (!$currentPage) { return ; } $this->_currentPage = $currentPage; $this->_currentPageUrl = $currentPage->getAbsoluteUrl(); } public function getSocialButtonTemplate($widget, $provider) { $social_btn = ''; switch ($widget) { case 'facebook_share': $social_btn = '<div class="fb-share-button" data-href="' . $this->_currentPageUrl . '" data-layout="button_count" moto-dependency-require="' . $provider . '"></div>'; break; case 'facebook_like': $social_btn = '<div class="fb-like" data-href="' . $this->_currentPageUrl . '" data-layout="button_count"' . ' data-action="like" data-show-faces="false" data-share="false" moto-dependency-require="' . $provider . '"></div>'; break; case 'twitter_tweet': $social_btn = '<a href="' .$this->_currentPageUrl . '" class="twitter-share-button" moto-dependency-require="' . $provider . '"></a>'; break; case 'google_share': $social_btn = '<div class="g-plus" data-action="share" data-annotation="bubble" data-href="' . $this->_currentPageUrl . '" moto-dependency-require="' .$provider . '"></div>'; break; case 'google_like': $social_btn = '<div class="g-plusone" data-href="' . $this->_currentPageUrl . '" data-size="medium" moto-dependency-require="' . $provider . '"></div>'; break; case 'linkedIn_share': $social_btn = '<span type="IN/Share" data-url="' . $this->_currentPageUrl . '" data-counter="right" moto-dependency-require="' . $provider . '"></span>'; break; } return $social_btn; } } 