<?php
 namespace Moto\Update; use Moto; class UpdaterEngine extends Core { public function init() { $this->_type = static::TYPE_ENGINE; parent::init(); } protected function _getDestinationPath() { return Moto\System::getAbsolutePath('@website'); } public function processCheckFilesAction($params = null) { $result = parent::processCheckFilesAction($params); if (!$result) { return $result; } $dir = $this->getUpdateDir(); $path = $dir . '/mt-admin/update/library/Moto/Update/Upgrade.php'; if (file_exists($path)) { $this->info('Main Upgrade file from temp folder => ', [ 'size' => number_format(filesize($path)), 'md5' => md5_file($path), 'sha1' => sha1_file($path), ]); } else { $this->info('Main Upgrade file not exists on temp folder'); } return !$this->isError(); } public function processUpdateFilesAction($params = null) { $files = $this->_getFilesForUpdates(); if (!is_array($files) || count($files) < 1) { $this->_throwError(array('name' => 'CANT_UPGRADE', 'params' => array('error' => 'EMPTY_FILE_LIST')), 'updateFiles'); } $this->info('Files : ' . count($files)); $this->_applyFiles(); return !$this->isError(); } public function processUpdateDatabaseAction($params = null) { $this->_preCheck(); $this->_doUpgrade(); $this->_postCheck(); return !$this->isError(); } public function processSaveCurrentBuildAction($params = null) { if (!class_exists('Moto\Update\Upgrade')) { $this->_throwError(array('name' => 'CLASS_NOT_EXISTS', 'params' => array('class' => 'Moto\\Update\\Upgrade')), 'upgradeVersion'); } try { return Moto\Update\Upgrade::saveCurrentBuild(); } catch (\Exception $e) { $this->_addLog(__FUNCTION__, 'exception'); Moto\Update\Upgrade::addError($e->getMessage()); $this->addErrors(Moto\Update\Upgrade::getErrors(), 'Upgrade.execute'); } return false; } public function execute() { $this->_throwError(array('name' => 'UNKNOWN_ACTION', 'params' => array('class' => __CLASS__)), __FUNCTION__); } } 