<?php
namespace Moto\Update; use Moto; class UpdaterPlugin extends Core { protected $_plugin; public function init() { $this->_type = static::TYPE_PLUGIN; parent::init(); } protected function _onSetUpdateItem() { if (!is_array($this->_updateItem) || empty($this->_updateItem['name']) || empty($this->_updateItem['url']) || empty($this->_updateItem['archivePath']) ) { $this->_throwError(array('name' => 'INVALID_UPDATE_ITEM')); } $plugin = Moto\System\PluginManager::findLocalPluginByName($this->_updateItem['name']); if (!$plugin) { $this->_throwError(array('name' => 'PLUGIN_NOT_EXISTS', 'params' => array('name' => $this->_updateItem['name']))); } $this->_plugin = $plugin; } public function getArchiveAbsolutePath() { return Moto\System::getAbsolutePath($this->_updateItem['archivePath']); } public function getArchiveRelativePath() { return Moto\System::getRelativePath($this->_updateItem['archivePath']); } protected function _getUpdateSourceDir() { $archiveFilePath = $this->getArchiveAbsolutePath(); $info = pathinfo($archiveFilePath); return $info['dirname'] . '/' . $info['filename']; } protected function _getDestinationPath() { return $this->_plugin->getAbsolutePath(); } public function processUpdateFilesAction($params = null) { $files = $this->_getFilesForUpdates(); if (!is_array($files) || count($files) < 1) { $this->_throwError(array('name' => 'CANT_UPGRADE', 'params' => array('error' => 'EMPTY_FILE_LIST')), 'updateFiles'); } $this->info('Files : ' . count($files)); $this->_applyFiles($files); return !$this->isError(); } public function processUpdateDatabaseAction($params = null) { $result = true; $connector = Moto\System\PluginManager::getConnector($this->_updateItem['name']); if ($connector) { try { $result = $connector->updateDatabase(array( 'from' => $this->_updateItem['from'], )); } catch (Moto\System\Exception $e) { if ($e->getMessage() === 'UPDATE_ERROR') { $this->addError($e->getErrors()); } } } return $result; } public function processCustomAction($params, $action) { $connector = Moto\System\PluginManager::getConnector($this->_updateItem['name']); if (!$connector) { $this->_throwError(array('name' => 'PLUGIN_CONNECTOR_NOT_EXISTS', 'params' => array('name' => $this->_updateItem['name']))); } try { $action = substr($action, 1); $connector->processAction($action, $params); } catch (\Exception $e) { if ($e instanceof Moto\Exception && $e->getCode() === 404) { $this->_throwError(array( 'name' => 'PLUGIN_ACTION_NOT_EXISTS', 'params' => array( 'name' => $this->_updateItem['name'], 'action' => $action, ) )); } $this->_throwError(array( 'name' => 'PLUGIN_EXCEPTION', 'params' => array( 'name' => $this->_updateItem['name'], 'action' => $action, 'exception' => array( 'code' => $e->getCode(), 'message' => $e->getMessage(), ) ) )); } } public function processCleanCacheAction($params = null) { $connector = Moto\System\PluginManager::getConnector($this->_updateItem['name']); parent::processCleanCacheAction(); $connector->fireEvent('cache.cleaned'); return !$this->isError(); } public function processRebuildStylesAction($params = null) { $connector = Moto\System\PluginManager::getConnector($this->_updateItem['name']); parent::processRebuildStylesAction(); $connector->fireEvent('styles.updated'); return !$this->isError(); } public function processFinishUpdateAction($params = null) { $connector = Moto\System\PluginManager::getConnector($this->_updateItem['name']); parent::processFinishUpdateAction(); $connector->fireEvent('update.finished'); return !$this->isError(); } public function execute() { $this->_throwError(array('name' => 'UNKNOWN_ACTION', 'params' => array('class' => __CLASS__)), __FUNCTION__); } } 