<?php
 namespace Moto\Update; use Illuminate\Support\Arr; use Moto; use Zend; class Upgrade extends Moto\Update\AbstractClass { const VERSION = '3.4.4'; const BUILD = 430; public static function saveCurrentBuild() { Moto\System\Settings::set('build', self::BUILD); Moto\System\Settings::set('version', self::VERSION); return true; } public static function execute() { try { return static::_execute(); } catch (\Exception $e) { if ($e->getMessage() == 'CANT_UPGRADE') { $trace = $e->getTrace(); for ($i = 0, $len = min(3, count($trace)); $i < $len; $i++) { if (!empty($trace[$i]['function']) && preg_match('/updateTo_([0-9]+)_Build/', $trace[$i]['function'], $match)) { static::addError('CANT_UPGRADE', $match[1]); break; } } } else { static::addError('CANT_UPGRADE'); } throw $e; } return false; } protected static function _execute() { self::$_currentBuild = Moto\Version::getCurrentBuild(true); if (self::BUILD <= self::$_currentBuild) { return true; } if (self::$_currentBuild < 100) { self::updateTo_100_Build(); } if (self::$_currentBuild < 110) { self::updateTo_110_Build(); } if (static::$_currentBuild < 120) { static::updateTo_120_Build(); } if (static::$_currentBuild < 130) { static::updateTo_130_Build(); } if (static::$_currentBuild < 140) { static::updateTo_140_Build(); } if (static::$_currentBuild < 150) { static::updateTo_150_Build(); } if (static::$_currentBuild < 160) { static::updateTo_160_Build(); } if (static::$_currentBuild < 180) { static::updateTo_180_Build(); } if (static::$_currentBuild < 200) { static::updateTo_200_Build(); } if (static::$_currentBuild < 210) { static::updateTo_210_Build(); } if (static::$_currentBuild < 230) { static::updateTo_230_Build(); } if (static::$_currentBuild < 240) { static::updateTo_240_Build(); } if (static::$_currentBuild < 250) { static::updateTo_250_Build(); } if (static::$_currentBuild < 260) { static::updateTo_260_Build(); } if (static::$_currentBuild < 280) { static::updateTo_280_Build(); } if (static::$_currentBuild < 290) { static::updateTo_290_Build(); } if (static::$_currentBuild < 310) { static::updateTo_310_Build(); static::checkAndCreateUnderConstructionPage(); } if (static::$_currentBuild < 320) { static::updateTo_320_Build(); } if (static::$_currentBuild < 330) { static::updateTo_330_Build(); } if (static::$_currentBuild < 340) { static::updateTo_340_Build(); } if (static::$_currentBuild < 350) { static::updateTo_350_Build(); } if (static::$_currentBuild < 380) { static::updateTo_380_Build(); } if (static::$_currentBuild < 390) { static::updateTo_390_Build(); } if (static::$_currentBuild < 410) { static::updateTo_410_Build(); } if (static::$_currentBuild < 430) { static::updateTo_430_Build(); } return true; } protected static function _getTablePrefix() { return Moto\Config::get('database.prefix'); } protected static function _getDatabaseAdapter() { return Moto\Config::get('databaseAdapter'); } protected static function _compressContainers($params) { $result = array( 'removed' => 0, 'type' => '', ); $isDebug = Moto\Util::getFrom($params, 'isDebug', false); if ($isDebug) { Moto\System\Log::debug(__FUNCTION__ . ': params ', $params); } $type = Moto\Util::getFrom($params, 'type'); if (!in_array($type, array('header', 'content', 'footer'))) { if ($isDebug) { Moto\System\Log::debug(__FUNCTION__ . ': Unknown type ' . $type); } $result['isError'] = true; $result['error'] = 'UNKNOWN_TYPE'; return $result; } if ($isDebug) { Moto\System\Log::debug(__FUNCTION__ . ': type ' . $type); } $table = new Moto\Application\Styles\StylesTable(); $select = new Zend\Db\Sql\Select($table->getTable()); $select->columns(array('id', 'class_name')); $select->where(array( 'type' => 'widget', 'is_system' => 0, )); $select->where(new Zend\Db\Sql\Predicate\Like('class_name', 'moto-container_' . $type . '_%')); $statement = $table->getSql()->prepareStatementForSqlObject($select); $collection = $statement->execute(); if ($isDebug) { Moto\System\Log::debug(__FUNCTION__ . ': Founded ' . $collection->count() . ' container(s)'); } if ($collection->count() < Moto\Util::getFrom($params, 'minimum', 0)) { if ($isDebug) { Moto\System\Log::debug(__FUNCTION__ . ': Skipped low containers'); } $result['isError'] = true; $result['error'] = 'IGNORE_BY_MINIMUM_CONTAINERS'; return $result; } $allContainers = array(); foreach ($collection as $item) { $allContainers[] = $item['class_name']; } $where = null; switch ($type) { case 'content': $contentTable = new Moto\Application\Pages\PagesTable(); break; default: $contentTable = new Moto\Application\Content\Table\ContentBlocks(); $where = array( 'type' => $type, ); break; } $contentTable->useResultAsModel(false); $items = $contentTable->select($where); foreach ($items as $item) { if (empty($item->content)) { continue; } $containers = Moto\Application\Content\Util::findContainers(trim($item->content)); if (empty($containers)) { continue; } $allContainers = array_diff($allContainers, $containers); } if (count($allContainers)) { $result['removed'] = count($allContainers); $table = new Moto\Application\Styles\StylesTable(); if ($isDebug) { Moto\System\Log::info(__FUNCTION__ . ': Removing ' . count($allContainers) . ' containers'); } $allContainers = array_values($allContainers); $table->deleteByClassName($allContainers); } elseif ($isDebug) { Moto\System\Log::info(__FUNCTION__ . ': Nothing to remove'); } return $result; } public static function checkAndCreateAudioPlayerPreset() { $table = new Moto\Application\Presets\PresetsTable(); $table->useResultAsModel(true); $preset = $table->getWidgetPreset('audio_player', 'moto-preset-default'); if (!$preset) { $preset = $table->create(array( 'name' => 'Preset 1', 'widget_name' => 'audio_player', 'class_name' => 'moto-preset-default', 'is_system' => 1, 'is_responsive' => 0, 'properties' => '{"widget_container":{"desktop":{"base":{"font-family":"tahoma, arial, helvetica, sans-serif","font-weight":"400","font-style":"normal","color":"#81868c","background-color":"#ffffff","font-size":"12px","border-color":"#d3d8db"}}},"buttons_normal":{"desktop":{"base":{"before":{"color":"#d3d8db"},"background-color":"transparent"},"hover":{"before":{"color":"#7f878a"},"background-color":""}}},"buttons_active":{"desktop":{"base":{"background-color":"#d3d8db","before":{"color":"#55616d"}},"hover":{"background-color":"","before":{"color":""}}}},"progress_bar":{"desktop":{"base":{"background-color":"#7f878a"}}},"volume_bar":{"desktop":{"base":{"background-color":"#7f878a"}}}}', 'template' => 'default', )); try { if ($table->save($preset)) { Moto\System\Log::info('Audio player preset saved'); } else { Moto\System\Log::info('Audio player preset not saved'); } } catch (\Exception $e) { Moto\System\Log::info('Audio player preset not saved. Exception:', $e); } } else { Moto\System\Log::info('Audio player preset already exist.'); } Moto\Database\Models\Preset::query() ->where(['widget_name' => 'audio_player']) ->whereIn('class_name', ['moto-preset-default']) ->get() ->each(function ($preset) { $properties = $preset->properties; if (!Moto\Util::getValue($properties, 'playlist')) { $properties['playlist'] = [ 'desktop' => [ 'base' => [ "border-color" => $properties['widget_container']['desktop']['base']['border-color'], ], ], ]; } if (!Moto\Util::getValue($properties, 'playlist_item')) { $properties['playlist_item'] = [ 'desktop' => [ 'base' => [ "font-family" => $properties['widget_container']['desktop']['base']['font-family'], "font-style" => $properties['widget_container']['desktop']['base']['font-style'], "font-size" => $properties['widget_container']['desktop']['base']['font-size'], 'color' => $properties['widget_container']['desktop']['base']['color'], 'background-color' => $properties['widget_container']['desktop']['base']['background-color'], ], 'hover' => [], ], ]; } if (!Moto\Util::getValue($properties, 'playlist_item_active')) { $properties['playlist_item_active'] = [ 'desktop' => [ 'base' => [ 'color' => $properties['buttons_active']['desktop']['base']['before']['color'], 'background-color' => $properties['buttons_normal']['desktop']['base']['background-color'], ], 'hover' => [ 'color' => $properties['buttons_active']['desktop']['hover']['before']['color'], 'background-color' => $properties['buttons_normal']['desktop']['hover']['background-color'], ], ], ]; } if (Moto\Util::getValue($properties, 'playlist_item_active.desktop.base.color') === null) { $properties['playlist_item_active']['desktop']['base']['color'] = $properties['buttons_active']['desktop']['base']['before']['color']; } if (Moto\Util::getValue($properties, 'playlist_item_active.desktop.base.background-color') === null) { $properties['playlist_item_active']['desktop']['base']['background-color'] = $properties['buttons_normal']['desktop']['base']['background-color']; } if (Moto\Util::getValue($properties, 'playlist_item_active.desktop.hover.color') === null) { $properties['playlist_item_active']['desktop']['hover']['color'] = $properties['buttons_active']['desktop']['hover']['before']['color']; } if (Moto\Util::getValue($properties, 'playlist_item_active.desktop.hover.background-color') === null) { $properties['playlist_item_active']['desktop']['hover']['background-color'] = $properties['buttons_normal']['desktop']['hover']['background-color']; } $preset->properties = $properties; try { $preset->save(); } catch (\Exception $e) { Moto\System\Log::error('checkAndCreateAudioPlayerPreset: preset ' . $preset->class_name . ' not saved. Exception:', $e); throw $e; } Moto\System\Log::info('checkAndCreateAudioPlayerPreset: preset ' . $preset->class_name . ' saved'); }); } public static function checkAndCreateCountdownPresets() { $table = new Moto\Application\Presets\PresetsTable(); $table->useResultAsModel(true); $preset = $table->getWidgetPreset('countdown', 'moto-preset-default'); if (!$preset) { $preset = $table->create(array( 'name' => 'Preset 1', 'widget_name' => 'countdown', 'class_name' => 'moto-preset-default', 'is_system' => 1, 'is_responsive' => 0, 'properties' => '{"general":{"desktop":{"base":{"font-family":"tahoma, arial, helvetica, sans-serif","font-weight":"400","font-style":"normal","color":"#81868c","background-color":"#d3d8db","font-size":"12px","height":"80px","width":"80px"}}},"delimiter":{"desktop":{"base":{"min-width":"20px","font-size":"22px","color":"#d3d8db"}}},"text":{"desktop":{"base":{"color":"#81868c","font-style":"normal","font-weight":"400","font-size":"13px"}}},"digits":{"desktop":{"base":{"color":"#2e3a46","font-style":"normal","font-weight":"400","font-size":"30px"}}},"border":{"desktop":{"base":{"border-color":"","border-top-width":"0px","border-left-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-style":"none","border-radius":"40px"}}}}', 'template' => 'default' )); try { $table->save($preset); } catch (\Exception $e) { Moto\System\Log::info('Countdown preset 1 not saved. Exception:', $e); } } $preset = $table->getWidgetPreset('countdown', 'moto-preset-2'); if (!$preset) { $preset = $table->create(array( 'name' => 'Preset 2', 'widget_name' => 'countdown', 'class_name' => 'moto-preset-2', 'is_system' => 1, 'is_responsive' => 0, 'properties' => '{"general":{"desktop":{"base":{"font-family":"tahoma, arial, helvetica, sans-serif","font-weight":"400","font-style":"normal","color":"#81868c","background-color":"#d3d8db","font-size":"12px","height":"80px","width":"80px"}}},"delimiter":{"desktop":{"base":{"min-width":"20px","font-size":"22px","color":"#d3d8db"}}},"text":{"desktop":{"base":{"color":"#81868c","font-style":"normal","font-weight":"400","font-size":"14px"}}},"digits":{"desktop":{"base":{"color":"#2e3a46","font-style":"normal","font-weight":"400","font-size":"30px"}}},"border":{"desktop":{"base":{"border-color":"","border-top-width":"0px","border-left-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-style":"none","border-radius":"0px"}}}}', 'template' => 'default' )); try { $table->save($preset); } catch (\Exception $e) { Moto\System\Log::info('Countdown preset 2 not saved. Exception:', $e); } } $preset = $table->getWidgetPreset('countdown', 'moto-preset-3'); if (!$preset) { $preset = $table->create(array( 'name' => 'Preset 3', 'widget_name' => 'countdown', 'class_name' => 'moto-preset-3', 'is_system' => 1, 'is_responsive' => 0, 'properties' => '{"general":{"desktop":{"base":{"font-family":"tahoma, arial, helvetica, sans-serif","font-weight":"400","font-style":"normal","color":"#81868c","background-color":"","font-size":"12px","height":"80px","width":"80px"}}},"delimiter":{"desktop":{"base":{"min-width":"20px","font-size":"30px","color":"#81868c"}}},"text":{"desktop":{"base":{"color":"#81868c","font-style":"normal","font-weight":"400","font-size":"13px"}}},"digits":{"desktop":{"base":{"color":"#2e3a46","font-style":"normal","font-weight":"400","font-size":"30px"}}},"border":{"desktop":{"base":{"border-color":"#81868c","border-top-width":"3px","border-left-width":"3px","border-right-width":"3px","border-bottom-width":"3px","border-style":"solid","border-radius":"40px"}}}}', 'template' => 'default' )); try { $table->save($preset); } catch (\Exception $e) { Moto\System\Log::info('Countdown preset 3 not saved. Exception:', $e); } } } public static function checkAndCreatePasswordProtectedPage() { if (Moto\Website\Settings::get('password_protected_page_id')) { return; } $pageTable = new Moto\Application\Pages\PagesTable(); $url = 'password-protected'; $receivedUrl = $url; for ($index = 1; $index < 1000; $index++) { $page = $pageTable->getByUrl($receivedUrl); if (!$page) { $page = Moto\Application\Pages\Service::save(array( 'name' => 'Password Protected', 'url' => $receivedUrl )); $page->is_system = 1; $page->status = Moto\Application\Pages\PageModel::STATUS_PUBLISH; $page->properties = '{"meta":{"noindex":true}}'; $page->content = '<div class="moto-widget moto-widget-row row-fixed" data-widget="row"><div class="container-fluid"><div class="row"><div class="moto-cell col-sm-12" data-container="container">{{ widget("auth_form", {"preset":"default","spacing":{"top":"large","right":"auto","bottom":"large","left":"auto"},"fields":{"password":{"enabled":true,"required":true,"type":"text","placeholder":"Password"}},"messages":{"required":"Field is required","wrong_password":"Wrong password","error":"Server unavailable. Please try again."},"buttons":{"submit":{"preset":"default","size":"medium","align":"left","label":"OK"}},"settings":[]}) }}</div></div></div></div>'; $pageTable->save($page); Moto\Website\Settings::add('password_protected_page_id', $page->id); Moto\System\Log::info('Password protected page created'); break; } $receivedUrl = $url . '-' . ($index + 1); } } public static function checkAndCreateUnderConstructionPage() { $options = Moto\Website\Settings::get('under_construction'); if ($options) { $page = Moto\Database\Page::query() ->where('id', '=', Moto\Util::getValue($options, 'page_id')) ->first(); if ($page) { if (!$page->is_system) { $page->is_system = true; $page->save(); } return; } } $pageTable = new Moto\Application\Pages\PagesTable(); $url = 'under-construction'; $receivedUrl = $url; for ($index = 1; $index < 1000; $index++) { $page = $pageTable->getByUrl($receivedUrl); if (!$page) { $page = Moto\Application\Pages\Service::save(array( 'name' => 'Under Construction', 'url' => $receivedUrl )); $page->is_system = 1; $page->status = Moto\Application\Pages\PageModel::STATUS_PUBLISH; $page->properties = '{"meta":{"noindex":true}}'; $page->layout = '{"name":"default","sections":{"header":{"id":1,"visible":false},"footer":{"id":2,"visible":false}}}'; $page->content = '<div class="moto-widget moto-widget-row row-fixed" data-widget="row"><div class="container-fluid"><div class="row"><div class="moto-cell col-sm-12" data-container="container"><div class="moto-widget moto-widget-text moto-preset-default moto-spacing-top-large moto-spacing-right-auto moto-spacing-bottom-large moto-spacing-left-auto" data-widget="text" data-preset="default" data-spacing="lala"><div class="moto-widget-text-content moto-widget-text-editable"><p class="moto-text_system_4" style="text-align: center;">Under Construction</p></div></div></div></div></div></div>'; $pageTable->save($page); Moto\Website\Settings::add('under_construction', '{"enabled":false, "page_id":' . $page->id . '}', 'object'); Moto\System\Log::info('Under construction page created'); break; } $receivedUrl = $url . '-' . ($index + 1); } } public static function checkAndUpgradeHomePageProvider() { if (!Moto\Website\Settings::isExists('home_page_provider')) { Moto\System\Log::warning('[UPGRADE] : Setting "home_page_provider" is not defined - create them'); Moto\Website\Settings::add('home_page_provider', '{"name": "page"}', 'object'); return true; } $homePageProvider = Moto\Website\Settings::get('home_page_provider'); if (Moto\Util::getValue($homePageProvider, 'name') === 'default') { $homePageProvider->name = 'page'; Moto\Website\Settings::set('home_page_provider', $homePageProvider); } return true; } public static function checkAndCreateAccordionPresets() { $table = new Moto\Application\Presets\PresetsTable(); $table->useResultAsModel(true); $preset = $table->getWidgetPreset('accordion', 'moto-preset-default'); if (!$preset) { $preset = $table->create(array( 'name' => 'Preset 1', 'widget_name' => 'accordion', 'class_name' => 'moto-preset-default', 'is_system' => 1, 'is_responsive' => 0, 'properties' => '{"collapse_icon":{"desktop":{"base":{"before":{"content":{"id":"angle-right","provider":"FontAwesome","unicode":"f105"}},"color":"#80868b","font-size":"20px"},"hover":{"color":"#54616d"}},"mobile-h":{"base":{"font-size":""}},"mobile-v":{"base":{"font-size":""}},"tablet":{"base":{"font-size":""}}},"collapse_icon_opened":{"desktop":{"base":{"before":{"content":{"id":"angle-down","provider":"FontAwesome","unicode":"f107"}},"color":"#54616d"},"hover":{"color":""}}},"content_opened":{"desktop":{"base":{"background-color":"transparent","border-bottom-width":"0px","border-right-width":"0px","border-left-width":"0px","border-top-width":"0px","border-color":"transparent","border-radius":"0px","border-style":"none"},"hover":{}}},"header":{"desktop":{"base":{"background-color":"transparent","border-bottom-width":"0px","border-right-width":"0px","border-left-width":"0px","border-top-width":"0px","border-color":"transparent","border-radius":"0px","border-style":"none","color":"#80868b","font-family":"tahoma, arial, helvetica, sans-serif","font-size":"18px","font-style":"normal","font-weight":"400"},"hover":{"background-color":"","border-color":"","color":"#54616d"}},"mobile-h":{"base":{"font-size":""}},"mobile-v":{"base":{"font-size":""}},"tablet":{"base":{"font-size":""}}},"header_icon":{"desktop":{"base":{"color":"#80868b","font-size":"20px"},"hover":{"color":"#54616d"}},"mobile-h":{"base":{"font-size":""}},"mobile-v":{"base":{"font-size":""}},"tablet":{"base":{"font-size":""}}},"header_icon_opened":{"desktop":{"base":{"color":"#80868b"},"hover":{"color":"#54616d"}}},"header_opened":{"desktop":{"base":{"background-color":"transparent","border-bottom-width":"0px","border-right-width":"0px","border-left-width":"0px","border-top-width":"0px","border-color":"transparent","border-radius":"0px","border-style":"none","color":"#54616d"},"hover":{"border-color":"","color":""}}},"header_title":{"desktop":{"base":{"text-decoration":"none"},"hover":{"text-decoration":""}}},"header_title_opened":{"desktop":{"base":{"text-decoration":"none"},"hover":{"text-decoration":""}}},"item":{"desktop":{"base":{"border-bottom-width":"1px","border-right-width":"0px","border-left-width":"0px","border-top-width":"0px","border-color":"#d3d8db","border-radius":"0px","border-style":"solid","margin-bottom":"0px"},"hover":{"border-color":""}}},"item_opened":{"desktop":{"base":{"border-bottom-width":"1px","border-right-width":"0px","border-left-width":"0px","border-top-width":"0px","border-color":"#d3d8db","border-radius":"0px","border-style":"solid"},"hover":{}}}}', 'template' => 'default' )); try { $table->save($preset); } catch (\Exception $e) { Moto\System\Log::info('Accordion preset 1 not saved. Exception:', $e); } } $preset = $table->getWidgetPreset('accordion', 'moto-preset-2'); if (!$preset) { $preset = $table->create(array( 'name' => 'Preset 2', 'widget_name' => 'accordion', 'class_name' => 'moto-preset-2', 'is_system' => 1, 'is_responsive' => 0, 'properties' => '{"collapse_icon":{"desktop":{"base":{"before":{"content":{"id":"plus","provider":"FontAwesome","unicode":"f067"}},"color":"#80868b","font-size":"14px"},"hover":{"color":"#54616d"}},"mobile-h":{"base":{"font-size":""}},"mobile-v":{"base":{"font-size":""}},"tablet":{"base":{"font-size":""}}},"collapse_icon_opened":{"desktop":{"base":{"before":{"content":{"id":"times","provider":"FontAwesome","unicode":"f00d"}},"color":"#54616d"},"hover":{"color":""}}},"content_opened":{"desktop":{"base":{"background-color":"#ffffff","border-bottom-width":"0px","border-right-width":"0px","border-left-width":"0px","border-top-width":"0px","border-color":"transparent","border-radius":"0px","border-style":"none"},"hover":{"background-color":""}}},"header":{"desktop":{"base":{"background-color":"#ffffff","border-color":"transparent","border-bottom-width":"0px","border-right-width":"0px","border-left-width":"0px","border-top-width":"0px","border-radius":"0px","border-style":"none","color":"#80868b","font-family":"tahoma, arial, helvetica, sans-serif","font-size":"18px","font-style":"normal","font-weight":"400"},"hover":{"background-color":"#ffffff","border-color":"","color":"#54616d"}},"mobile-h":{"base":{"font-size":""}},"mobile-v":{"base":{"font-size":""}},"tablet":{"base":{"font-size":""}}},"header_icon":{"desktop":{"base":{"color":"#80868b","font-size":"20px"},"hover":{"color":"#54616d"}},"mobile-h":{"base":{"font-size":""}},"mobile-v":{"base":{"font-size":""}},"tablet":{"base":{"font-size":""}}},"header_icon_opened":{"desktop":{"base":{"color":"#54616d"},"hover":{}}},"header_opened":{"desktop":{"base":{"background-color":"#ffffff","border-bottom-width":"0px","border-right-width":"0px","border-left-width":"0px","border-top-width":"0px","border-color":"transparent","border-radius":"0px","border-style":"none","color":"#54616d"},"hover":{"border-color":"","color":"#80868b"}}},"header_title":{"desktop":{"base":{"text-decoration":"none"},"hover":{"text-decoration":""}}},"header_title_opened":{"desktop":{"base":{"text-decoration":"none"},"hover":{"text-decoration":""}}},"item":{"desktop":{"base":{"border-bottom-width":"1px","border-color":"#d3d8db","border-left-width":"1px","border-radius":"0px","border-right-width":"1px","border-style":"solid","border-top-width":"1px","margin-bottom":"10px"},"hover":{"border-color":""}}},"item_opened":{"desktop":{"base":{"border-bottom-width":"1px","border-color":"#54616d","border-left-width":"1px","border-radius":"0px","border-right-width":"1px","border-style":"solid","border-top-width":"1px"},"hover":{}}}}', 'template' => 'default' )); try { $table->save($preset); } catch (\Exception $e) { Moto\System\Log::info('Accordion preset 2 not saved. Exception:', $e); } } $preset = $table->getWidgetPreset('accordion', 'moto-preset-3'); if (!$preset) { $preset = $table->create(array( 'name' => 'Preset 3', 'widget_name' => 'accordion', 'class_name' => 'moto-preset-3', 'is_system' => 1, 'is_responsive' => 0, 'properties' => '{"collapse_icon":{"desktop":{"base":{"before":{"content":{"id":"angle-right","provider":"FontAwesome","unicode":"f105"}},"color":"#80868b","font-size":"12px"},"hover":{"color":"#ffffff"}},"mobile-h":{"base":{"font-size":""}},"mobile-v":{"base":{"font-size":""}},"tablet":{"base":{"font-size":""}}},"collapse_icon_opened":{"desktop":{"base":{"before":{"content":{"id":"angle-down","provider":"FontAwesome","unicode":"f107"}},"color":"#ffffff"},"hover":{"color":""}}},"content_opened":{"desktop":{"base":{"background-color":"#ffffff","border-bottom-width":"0px","border-right-width":"0px","border-left-width":"0px","border-top-width":"0px","border-color":"transparent","border-radius":"0px","border-style":"none"},"hover":{}}},"header":{"desktop":{"base":{"background-color":"#d3d8db","border-bottom-width":"0px","border-color":"transparent","border-left-width":"0px","border-radius":"0px","border-right-width":"0px","border-style":"none","border-top-width":"0px","color":"#54616d","font-family":"tahoma, arial, helvetica, sans-serif","font-size":"18px","font-style":"normal","font-weight":"400"},"hover":{"background-color":"#54616d","border-color":"","color":"#ffffff"}},"mobile-h":{"base":{"font-size":""}},"mobile-v":{"base":{"font-size":""}},"tablet":{"base":{"font-size":""}}},"header_icon":{"desktop":{"base":{"color":"#54616d","font-size":"20px"},"hover":{"color":"#ffffff"}},"mobile-h":{"base":{"font-size":""}},"mobile-v":{"base":{"font-size":""}},"tablet":{"base":{"font-size":""}}},"header_icon_opened":{"desktop":{"base":{"color":"#ffffff"},"hover":{}}},"header_opened":{"desktop":{"base":{"background-color":"#54616d","border-bottom-width":"0px","border-right-width":"0px","border-left-width":"0px","border-top-width":"0px","border-color":"transparent","border-radius":"0px","border-style":"none","color":"#ffffff"},"hover":{"background-color":"#54616d","border-color":"","color":""}}},"header_title":{"desktop":{"base":{"text-decoration":"none"},"hover":{"text-decoration":""}}},"header_title_opened":{"desktop":{"base":{"text-decoration":"none"},"hover":{"text-decoration":""}}},"item":{"desktop":{"base":{"border-bottom-width":"0px","border-color":"transparent","border-left-width":"0px","border-radius":"0px","border-right-width":"0px","border-style":"none","border-top-width":"0px","margin-bottom":"5px"},"hover":{"border-color":""}}},"item_opened":{"desktop":{"base":{"border-bottom-width":"0px","border-right-width":"0px","border-left-width":"0px","border-top-width":"0px","border-color":"transparent","border-radius":"0px","border-style":"none"},"hover":{}}}}', 'template' => 'default' )); try { $table->save($preset); } catch (\Exception $e) { Moto\System\Log::info('Accordion preset 3 not saved. Exception:', $e); } } } public static function checkAndCreateSocialLinksExtendedPresets() { $table = new Moto\Application\Presets\PresetsTable(); $table->useResultAsModel(true); $preset = $table->getWidgetPreset('social_links_extended', 'moto-preset-default'); if (!$preset) { $preset = $table->create(array( 'name' => 'Preset 1', 'widget_name' => 'social_links_extended', 'class_name' => 'moto-preset-default', 'is_system' => 1, 'is_responsive' => 0, 'properties' => '{"general":{"desktop":{"base":{"font-size":"26px","width":"46px","height":"46px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-left-width":"0px","border-radius":"0px","border-style":"none","color":"#ffffff","background-color":"#2e3a46","border-color":"transparent"},"hover":{"color":"#2e3a46","background-color":"#d3d8db","border-color":"transparent"}},"tablet":{"base":{"font-size":""}}},"spacing":{"desktop":{"base":{"margin-bottom":"5px","margin-left":"5px","margin-right":"5px"}},"tablet":{"base":{"margin-left":"","margin-right":""}},"mobile-v":{"base":{"margin-bottom":""}}}}', 'template' => 'default' )); try { $table->save($preset); } catch (\Exception $e) { Moto\System\Log::info('Social Links Extended preset 1 not saved. Exception:', $e); } } $preset = $table->getWidgetPreset('social_links_extended', 'moto-preset-2'); if (!$preset) { $preset = $table->create(array( 'name' => 'Preset 2', 'widget_name' => 'social_links_extended', 'class_name' => 'moto-preset-2', 'is_system' => 1, 'is_responsive' => 0, 'properties' => '{"general":{"desktop":{"base":{"font-size":"26px","width":"46px","height":"46px","border-top-width":"2px","border-right-width":"2px","border-bottom-width":"2px","border-left-width":"2px","border-radius":"25px","border-style":"solid","color":"#55616d","background-color":"#ffffff","border-color":"#55616d"},"hover":{"color":"#d3d8db","background-color":"#2e3a46","border-color":""}},"tablet":{"base":{"font-size":""}}},"spacing":{"desktop":{"base":{"margin-bottom":"10px","margin-left":"10px","margin-right":"10px"}},"tablet":{"base":{"margin-left":"","margin-right":""}},"mobile-v":{"base":{"margin-bottom":""}}}}', 'template' => 'default' )); try { $table->save($preset); } catch (\Exception $e) { Moto\System\Log::info('Social Links Extended preset 2 not saved. Exception:', $e); } } $preset = $table->getWidgetPreset('social_links_extended', 'moto-preset-3'); if (!$preset) { $preset = $table->create(array( 'name' => 'Preset 3', 'widget_name' => 'social_links_extended', 'class_name' => 'moto-preset-3', 'is_system' => 1, 'is_responsive' => 0, 'properties' => '{"general":{"desktop":{"base":{"font-size":"20px","width":"32px","height":"32px","border-top-width":"2px","border-right-width":"2px","border-bottom-width":"2px","border-left-width":"2px","border-radius":"0px","border-style":"solid","color":"#55616d","background-color":"#d3d8db","border-color":"transparent"},"hover":{"color":"","background-color":"#ffffff","border-color":"#d3d8db"}},"tablet":{"base":{"font-size":""}}},"spacing":{"desktop":{"base":{"margin-bottom":"10px","margin-left":"10px","margin-right":"10px"}},"tablet":{"base":{"margin-left":"","margin-right":""}},"mobile-v":{"base":{"margin-bottom":""}}}}', 'template' => 'default' )); try { $table->save($preset); } catch (\Exception $e) { Moto\System\Log::info('Social Links Extended preset 3 not saved. Exception:', $e); } } } public static function upgradeBackToTopButton() { $table = new Moto\Application\Presets\PresetsTable(); $table->useResultAsModel(true); $preset = $table->getWidgetPreset('back_to_top', 'moto-preset-default'); if (!$preset) { $preset = $table->create(array( 'name' => 'Preset 1', 'widget_name' => 'back_to_top', 'class_name' => 'moto-preset-default', 'is_system' => 1, 'is_responsive' => 0, 'properties' => '{"position":{"type":"bottom_right","desktop":{"horizontal":"40px","vertical":"60px"},"tablet":{"horizontal":"20px","vertical":"20px"},"mobile-h":{"horizontal":"","vertical":""},"mobile-v":{"horizontal":"","vertical":""}},"common_styles":{"desktop":{"base":{"font-size":"24px","background-color":"rgba(211, 216, 219, 0.8)","color":"#2e3a46","border-color":"#ffffff","border-style":"solid","border-bottom-width":"1px","border-top-width":"1px","border-left-width":"1px","border-right-width":"1px","border-radius":"0px"},"hover":{"color":"#d3d8db","background-color":"#2e3a46","border-color":"#d3d8db"}}},"box_model":{"desktop":{"base":{"width":"48px","height":"48px"}}},"animation":"","icon":{"desktop":{"base":{"before":{"content":{"provider":"FontAwesome","id":"chevron-up","unicode":"f077"}}}}}}', 'template' => 'default' )); try { $table->save($preset); } catch (\Exception $e) { Moto\System\Log::info('Back To Top preset 1 not saved. Exception:', $e); } } try { $databaseAdapter = Moto\Config::get('databaseAdapter'); $prefix = Moto\Config::get('database.prefix'); $sql = 'UPDATE `' . $prefix . 'settings` SET `type` = "object" WHERE `name` IN ("website.back_to_top_button") AND `type` = ""'; $databaseAdapter->query($sql)->execute(); Moto\Website\Settings::loadData(true); $value = Moto\Website\Settings::get('back_to_top_button'); if (!isset($value->type)) { $value->type = 'theme'; if (!Moto\Features::isEnabled('theme_back_to_top_button') || (isset($value->enabled) && !$value->enabled)) { $value->type = 'none'; } } unset($value->enabled); Moto\Website\Settings::set('back_to_top_button', $value); } catch (\Exception $e) { return false; } return true; } public static function checkAndCreateTabsPresets() { $table = new Moto\Application\Presets\PresetsTable(); $table->useResultAsModel(true); $preset = $table->getWidgetPreset('tabs', 'moto-preset-default'); if (!$preset) { $preset = $table->create(array( 'name' => 'Preset 1', 'widget_name' => 'tabs', 'class_name' => 'moto-preset-default', 'is_system' => 1, 'is_responsive' => 0, 'properties' => '{"header":{"desktop":{"base":{"font-size":"14px","border-style":"solid","border-left-width":"1px","border-top-width":"1px","border-right-width":"1px","border-bottom-width":"1px","border-radius":"3px","border-color":"transparent","background-color":"transparent","padding-top":"10px","padding-right":"20px","padding-bottom":"10px","padding-left":"20px"},"hover":{"border-color":"#d3d8db","background-color":""}}},"header_title":{"desktop":{"base":{"font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400","color":"#54616d","text-decoration":"none"},"hover":{"color":"#2e3a46","text-decoration":""}}},"header_icon":{"desktop":{"base":{"font-size":"18px","margin-right":"10px","color":"#54616d"},"hover":{"color":"#2e3a46"}}},"header_opened":{"desktop":{"base":{"border-style":"solid","border-left-width":"1px","border-top-width":"1px","border-right-width":"1px","border-bottom-width":"1px","border-radius":"3px","background-color":"#d3d8db","border-color":"#d3d8db"},"hover":{"background-color":"","border-color":""}},"mobile-h":{"base":{"margin-bottom":"10px"}}},"header_title_opened":{"desktop":{"base":{"color":"#2e3a46","text-decoration":"none"},"hover":{"color":"","text-decoration":""}}},"header_icon_opened":{"desktop":{"base":{"color":"#2e3a46"},"hover":{"color":""}}},"header_desktop":{"desktop":{"base":{"margin-right":"10px"},"hover":{}}},"header_mobile":{"desktop":{"base":{},"hover":{}}},"content":{"desktop":{"base":{"border-style":"solid","border-left-width":"1px","border-top-width":"1px","border-right-width":"1px","border-bottom-width":"1px","border-radius":"3px","background-color":"","border-color":"#d3d8db","padding-top":"20px","padding-right":"20px","padding-bottom":"20px","padding-left":"20px"},"hover":{}}},"headers_wrapper":{"desktop":{"base":{"margin-bottom":"10px"},"hover":{}}},"items_wrapper":{"desktop":{"base":{},"hover":{}}},"item":{"desktop":{"base":{},"hover":{}},"mobile-h":{"base":{"margin-bottom":"10px"},"hover":{}}},"extra":{"stickyHeaders":0}}', 'template' => 'default' )); try { $table->save($preset); } catch (\Exception $e) { Moto\System\Log::info('Tabs preset 1 not saved. Exception:', $e); } } $preset = $table->getWidgetPreset('tabs', 'moto-preset-2'); if (!$preset) { $preset = $table->create(array( 'name' => 'Preset 2', 'widget_name' => 'tabs', 'class_name' => 'moto-preset-2', 'is_system' => 1, 'is_responsive' => 0, 'properties' => '{"header":{"desktop":{"base":{"font-size":"14px","border-style":"none","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","border-color":"transparent","background-color":"transparent","padding-top":"14px","padding-right":"30px","padding-bottom":"14px","padding-left":"30px"},"hover":{"border-color":"transparent","background-color":""}},"mobile-h":{"base":{"font-size":""}}},"header_title":{"desktop":{"base":{"font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400","color":"#54616d","text-decoration":"none"},"hover":{"color":"#2e3a46","text-decoration":""}}},"header_icon":{"desktop":{"base":{"font-size":"18px","margin-right":"10px","color":"#54616d"},"hover":{"color":"#2e3a46"}}},"header_opened":{"desktop":{"base":{"border-style":"none","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","background-color":"#d3d8db","border-color":"transparent"},"hover":{"background-color":"","border-color":""}},"mobile-h":{"base":{"margin-bottom":"0px"}}},"header_title_opened":{"desktop":{"base":{"color":"#54616d","text-decoration":"none"},"hover":{"color":"#2e3a46","text-decoration":""}}},"header_icon_opened":{"desktop":{"base":{"color":"#54616d"},"hover":{"color":"#2e3a46"}}},"header_desktop":{"desktop":{"base":{"margin-right":"0px"},"hover":{}}},"header_mobile":{"desktop":{"base":{},"hover":{}}},"content":{"desktop":{"base":{"border-style":"none","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","background-color":"#d3d8db","border-color":"transparent","padding-top":"20px","padding-right":"20px","padding-bottom":"20px","padding-left":"20px"},"hover":{}}},"headers_wrapper":{"desktop":{"base":{"margin-bottom":"0px"},"hover":{}}},"items_wrapper":{"desktop":{"base":{},"hover":{}}},"item":{"desktop":{"base":{},"hover":{}},"mobile-h":{"base":{"margin-bottom":"0px"},"hover":{}}},"extra":{"stickyHeaders":1}}', 'template' => 'default' )); try { $table->save($preset); } catch (\Exception $e) { Moto\System\Log::info('Tabs preset 2 not saved. Exception:', $e); } } $preset = $table->getWidgetPreset('tabs', 'moto-preset-3'); if (!$preset) { $preset = $table->create(array( 'name' => 'Preset 3', 'widget_name' => 'tabs', 'class_name' => 'moto-preset-3', 'is_system' => 1, 'is_responsive' => 0, 'properties' => '{"header":{"desktop":{"base":{"font-size":"14px","border-style":"solid","border-left-width":"1px","border-top-width":"1px","border-right-width":"1px","border-bottom-width":"0px","border-radius":"0px","border-color":"transparent","background-color":"#d3d8db","padding-top":"18px","padding-right":"30px","padding-bottom":"18px","padding-left":"30px"},"hover":{"border-color":"","background-color":"#54616d"}}},"header_title":{"desktop":{"base":{"font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400","color":"#54616d","text-decoration":"none"},"hover":{"color":"#ffffff","text-decoration":""}}},"header_icon":{"desktop":{"base":{"font-size":"18px","margin-right":"10px","color":"#54616d"},"hover":{"color":"#ffffff"}}},"header_opened":{"desktop":{"base":{"border-style":"solid","border-left-width":"1px","border-top-width":"1px","border-right-width":"1px","border-bottom-width":"0px","border-radius":"0px","background-color":"#ffffff","border-color":"#d3d8db"},"hover":{"background-color":"","border-color":""}},"mobile-h":{"base":{"margin-bottom":"0px"}}},"header_title_opened":{"desktop":{"base":{"color":"#54616d","text-decoration":"none"},"hover":{"color":"","text-decoration":""}}},"header_icon_opened":{"desktop":{"base":{"color":"#54616d"},"hover":{"color":""}}},"header_desktop":{"desktop":{"base":{"margin-right":"1px"},"hover":{}}},"header_mobile":{"desktop":{"base":{},"hover":{}}},"content":{"desktop":{"base":{"border-style":"solid","border-left-width":"1px","border-top-width":"1px","border-right-width":"1px","border-bottom-width":"1px","border-radius":"0px","background-color":"#ffffff","border-color":"#d3d8db","padding-top":"20px","padding-right":"20px","padding-bottom":"20px","padding-left":"20px"},"hover":{}}},"headers_wrapper":{"desktop":{"base":{"margin-bottom":"0px"},"hover":{}}},"items_wrapper":{"desktop":{"base":{},"hover":{}}},"item":{"desktop":{"base":{},"hover":{}},"mobile-h":{"base":{"margin-bottom":"1px"},"hover":{}}},"extra":{"stickyHeaders":1}}', 'template' => 'default' )); try { $table->save($preset); } catch (\Exception $e) { Moto\System\Log::info('Tabs preset 3 not saved. Exception:', $e); } } } public static function checkAndCreateCookieNotificationPresets() { $table = new Moto\Application\Presets\PresetsTable(); $table->useResultAsModel(true); $preset = $table->getWidgetPreset('cookie_notification', 'moto-preset-default'); if (!$preset) { $preset = $table->create(array( 'name' => 'Preset 1', 'widget_name' => 'cookie_notification', 'class_name' => 'moto-preset-default', 'is_system' => 1, 'is_responsive' => 0, 'properties' => '{"general":{"desktop":{"base":{"background-color":"#1f2228","color":"rgba(255, 255, 255, 0.4)"},"hover":{"color":"#ffffff"}}}}', 'template' => 'default' )); try { $table->save($preset); } catch (\Exception $e) { Moto\System\Log::info('Cookie Notification preset 1 not saved. Exception:', $e); } } } public static function upgradeTabsPresetsForVerticalMode() { $upgradePresetProperties = function ($properties) { if (is_array($properties['header_icon'])) { foreach ($properties['header_icon'] as $deviceName => $value) { if (!isset($properties['header_icon'][$deviceName]['base']['margin-left'])) { $properties['header_icon'][$deviceName]['base']['margin-left'] = Moto\Util::getValue($properties['header_icon'][$deviceName], 'base.margin-right'); } } } if (!isset($properties['headers_wrapper_vertical'])) { $properties['headers_wrapper_vertical'] = array( 'desktop' => array( 'base' => array( 'margin-left' => Moto\Util::getValue($properties, 'headers_wrapper.desktop.base.margin-bottom'), 'margin-right' => Moto\Util::getValue($properties, 'headers_wrapper.desktop.base.margin-bottom'), ), ), ); } if (!isset($properties['header_desktop_vertical'])) { $properties['header_desktop_vertical'] = array( 'desktop' => array( 'base' => array( 'margin-bottom' => Moto\Util::getValue($properties, 'header_desktop.desktop.base.margin-right'), ), ), ); } return $properties; }; $upgradePreset = function ($presetName) use ($upgradePresetProperties) { $table = new Moto\Application\Presets\PresetsTable(); $table->useResultAsModel(true); $preset = $table->getWidgetPreset('tabs', $presetName); if ($preset) { $properties = json_decode($preset->properties, true); $properties = $upgradePresetProperties($properties); $preset->properties = json_encode($properties); try { $table->save($preset); } catch (\Exception $e) { Moto\System\Log::error('Update for tabs presets not saved. Exception:', $e); } } }; $upgradePreset('moto-preset-default'); $upgradePreset('moto-preset-2'); $upgradePreset('moto-preset-3'); } public static function checkAndCreateTileGalleryPresets() { $table = new Moto\Application\Presets\PresetsTable(); $table->useResultAsModel(true); $preset = $table->getWidgetPreset('tile_gallery', 'moto-preset-default'); if (!$preset) { $preset = $table->create(array( 'name' => 'Preset 1', 'widget_name' => 'tile_gallery', 'class_name' => 'moto-preset-default', 'is_system' => 1, 'is_responsive' => 0, 'properties' => '{"caption":{"desktop":{"base":{"font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400","text-decoration":"none","color":"#ffffff","background-color":"rgba(46, 58, 70, 0.85)","font-size":"16px","padding-top":"20px","padding-right":"20px","padding-bottom":"20px","padding-left":"20px"},"hover":{}},"tablet":{"base":{"padding-top":"16px","padding-right":"16px","padding-bottom":"16px","padding-left":"16px"}},"mobile-h":{"base":{"padding-top":"12px","padding-right":"12px","padding-bottom":"12px","padding-left":"12px","font-size":"14px"}}},"layer_icon":{"desktop":{"base":{"before":{"content":{"provider":"FontAwesome","id":"plus","unicode":"f067"}},"font-size":"0","color":"transparent"},"hover":{"font-size":"42px","color":"#ffffff"}},"mobile-h":{"hover":{"font-size":"30px"}}},"item":{"desktop":{"base":{"border-style":"none","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","border-color":"transparent"},"hover":{}}},"layer":{"desktop":{"base":{"background-color":"transparent","border-style":"none","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","border-color":"transparent"},"hover":{"background-color":"rgba(85, 97, 109, 0.45)"}}},"extra":{"layer_appearance":{"type":"default"},"caption_position":{"type":"absolute","direction":"bottom"}}}', 'template' => 'default' )); try { $table->save($preset); } catch (\Exception $e) { Moto\System\Log::info('Tile Gallery preset 1 not saved. Exception:', $e); } } $preset = $table->getWidgetPreset('tile_gallery', 'moto-preset-2'); if (!$preset) { $preset = $table->create(array( 'name' => 'Preset 2', 'widget_name' => 'tile_gallery', 'class_name' => 'moto-preset-2', 'is_system' => 1, 'is_responsive' => 0, 'properties' => '{"caption":{"desktop":{"base":{"font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400","text-decoration":"none","color":"#2e3a48","background-color":"transparent","font-size":"16px","padding-top":"10px","padding-right":"10px","padding-bottom":"10px","padding-left":"10px"},"hover":{}},"mobile-h":{"base":{"padding-top":"8px","padding-right":"8px","padding-bottom":"8px","padding-left":"8px","font-size":"14px"}}},"layer_icon":{"desktop":{"base":{"before":{"content":{"provider":"FontAwesome","id":"search-plus","unicode":"f00e"}},"font-size":"40px","color":"transparent"},"hover":{"color":"#2e3a48"}},"mobile-h":{"base":{"font-size":"30px"}}},"item":{"desktop":{"base":{"border-style":"none","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","border-color":"transparent"},"hover":[]}},"layer":{"desktop":{"base":{"background-color":"transparent","border-style":"none","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","border-color":"transparent"},"hover":{"background-color":"rgba(255, 255, 255, 0.75)"}}},"extra":{"layer_appearance":{"type":"padding","direction":"top","value":"30px"},"caption_position":{"type":"relative"}}}', 'template' => 'default' )); try { $table->save($preset); } catch (\Exception $e) { Moto\System\Log::info('Tile Gallery preset 2 not saved. Exception:', $e); } } $preset = $table->getWidgetPreset('tile_gallery', 'moto-preset-3'); if (!$preset) { $preset = $table->create(array( 'name' => 'Preset 3', 'widget_name' => 'tile_gallery', 'class_name' => 'moto-preset-3', 'is_system' => 1, 'is_responsive' => 0, 'properties' => '{"caption":{"desktop":{"base":{"font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400","text-decoration":"none","color":"#ffffff","background-color":"transparent","font-size":"16px","padding-top":"10px","padding-right":"10px","padding-bottom":"10px","padding-left":"10px"},"hover":{}},"mobile-h":{"base":{"padding-top":"8px","padding-right":"8px","padding-bottom":"8px","padding-left":"8px","font-size":"14px"}}},"layer_icon":{"desktop":{"base":{"before":{"content":{"provider":"FontAwesome","id":"search-plus","unicode":"f00e"}},"font-size":"40px","color":"transparent"},"hover":{"color":"#ffffff"}},"mobile-h":{"base":{"font-size":"30px"}}},"item":{"desktop":{"base":{"border-style":"none","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","border-color":"transparent"},"hover":{}}},"layer":{"desktop":{"base":{"background-color":"transparent","border-style":"solid","border-left-width":"16px","border-top-width":"16px","border-right-width":"16px","border-bottom-width":"16px","border-radius":"0px","border-color":"transparent"},"hover":{"background-color":"rgba(46, 58, 72, 0.85)"}}},"extra":{"layer_appearance":{"type":"padding","direction":"bottom","value":"16px"},"caption_position":{"type":"relative"}}}', 'template' => 'default' )); try { $table->save($preset); } catch (\Exception $e) { Moto\System\Log::info('Tile Gallery preset 3 not saved. Exception:', $e); } } } public static function updateTo_100_Build() { Moto\System\Log::info('@UPDATE 100 : Start'); $prefix = static::_getTablePrefix(); $databaseAdapter = static::_getDatabaseAdapter(); try { Moto\System\Log::info('@UPDATE 100 : Try to change field type of `settings`.`value` to MEDIUMTEXT'); $sql = "ALTER TABLE `{$prefix}settings` CHANGE `value` `value` MEDIUMTEXT"; $databaseAdapter->query($sql)->execute(); } catch (\Exception $e) { Moto\System\Log::critical('@UPDATE 100 : DataBase : ' . $e->getMessage()); throw $e; } if (Moto\Website\Settings::isExists('google_analytics_id')) { Moto\System\Log::info('@UPDATE 100 : Transform google_analytics_id to google_analytics'); Moto\Website\Settings::add('google_analytics', array( 'id' => Moto\Website\Settings::get('google_analytics_id'), "options" => array( 'anonymize_ip' => false, ), ), 'object'); Moto\Website\Settings::delete('google_analytics_id'); } Moto\System\Log::info('@UPDATE 100 : End'); } public static function updateTo_110_Build() { try { Moto\System\Log::info('@UPDATE 110 : Try to add `theme_headings` field to website'); if (!Moto\Website\Settings::isExists('theme_headings')) { Moto\Website\Settings::add('theme_headings', '{"heading1":"0.67em","heading2":"0em","heading3":"0em","heading4":"0em"}', 'object'); Moto\Website\Theme::importHeadingSpacings(); } Moto\System\Log::info('@UPDATE 110 : add `theme_headings` field to website Successful!'); } catch (\Exception $e) { throw new \Exception('CANT_UPGRADE'); } return true; } public static function updateTo_120_Build() { Moto\System\Log::info('@UPDATE 120 : Start'); $prefix = static::_getTablePrefix(); $databaseAdapter = static::_getDatabaseAdapter(); try { Moto\System\Log::info('@UPDATE : Try add category field for pages'); $sql = "SHOW COLUMNS FROM `{$prefix}pages` WHERE `Field` = 'category_id'"; $isExists = $databaseAdapter->query($sql)->execute()->current(); if (!$isExists) { $sql = "ALTER TABLE `{$prefix}pages` ADD `category_id` INT UNSIGNED NULL DEFAULT NULL AFTER `parent_id`"; $databaseAdapter->query($sql)->execute(); $sql = "ALTER TABLE `{$prefix}pages` ADD INDEX ( `category_id` )"; $databaseAdapter->query($sql)->execute(); } } catch (\Exception $e) { Moto\System\Log::critical('@UPDATE : DataBase : ' . $e->getMessage()); throw $e; } try { Moto\System\Log::info('@UPDATE : Try to change field type of `presets`.`template` to VARCHAR(255)'); $sql = "ALTER TABLE `{$prefix}presets` CHANGE `template` `template` VARCHAR(255) NOT NULL DEFAULT 'default'"; $databaseAdapter->query($sql)->execute(); Moto\System\Log::info('@UPDATE : Check and create post_tags presets'); static::checkAndCreateTagListPresets(); } catch (\Exception $e) { Moto\System\Log::critical('@UPDATE : DataBase : ' . $e->getMessage()); throw $e; } Moto\System\Log::info('@UPDATE : Installing Tags & Categories'); try { $contentSectionHelper = Moto\System\ContentSectionHelper::get('blog'); $contentSectionHelper->checkOrInstall(); } catch (\Exception $e) { Moto\System\Log::error('@UPDATE : Cant create new Templates for Blog by [ ' . $e->getCode() . ' ] ' . $e->getMessage()); throw new \Exception('CANT_UPGRADE'); } if (!Moto\Application\Content\TaxonomyProvider::update(static::$_currentBuild)) { Moto\System\Log::error('@UPDATE : Tags & Categories Not Installed'); } static::upgradeDatabaseTableCollate(); Moto\System\Log::info('@UPDATE 120 : End'); return true; } public static function checkAndCreateTagListPresets() { $table = new Moto\Application\Presets\PresetsTable(); $table->useResultAsModel(true); $preset = $table->getWidgetPreset('blog.post_tags', 'moto-preset-default'); if (!$preset) { $preset = $table->create(array( 'name' => 'Preset 1', 'widget_name' => 'blog.post_tags', 'class_name' => 'moto-preset-default', 'is_system' => 1, 'is_responsive' => 0, 'properties' => '{"general":{"desktop":{"base":{"font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400","font-size":"13px","padding-left":"10px","padding-right":"10px","padding-top":"4px","padding-bottom":"4px","border-style":"solid","border-left-width":"1px","border-top-width":"1px","border-right-width":"1px","border-bottom-width":"1px","border-radius":"10px","text-decoration":"none","color":"#2e3a46","background-color":"#ffffff","border-color":"#d3d8db"},"hover":{"font-style":"normal","font-weight":"400","background-color":"#d3d8db","color":""}},"mobile":{"base":[],"hover":[]}},"indents":{"desktop":{"base":{"margin-right":"4px","margin-bottom":"4px"},"hover":[]},"mobile":{"base":[],"hover":[]}},"title_indents":{"desktop":{"base":{"margin-right":"15px"},"hover":[]}}}', 'template' => '@websiteWidgets/content_sections/templates/record_taxonomy/many.twig.css' )); try { $table->save($preset); } catch (\Exception $e) { Moto\System\Log::critical('Tag List preset 1 not saved. Exception:', $e); } } static::checkAndCreateWidgetPreset('blog.post_tags', 2 , '{"general":{"desktop":{"base":{"font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400","font-size":"12px","padding-left":"10px","padding-right":"10px","padding-top":"4px","padding-bottom":"4px","border-style":"none","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","text-decoration":"none","color":"#2e3a46","background-color":"#d3d8db","border-color":"transparent"},"hover":{"font-style":"normal","font-weight":"400","background-color":"#55616d","color":"#ffffff","border-color":""}},"mobile":{"base":[],"hover":[]}},"indents":{"desktop":{"base":{"margin-right":"4px","margin-bottom":"4px"},"hover":[]},"mobile":{"base":[],"hover":[]}},"title_indents":{"desktop":{"base":{"margin-right":"15px"},"hover":[]}}}' , '@websiteWidgets/content_sections/templates/record_taxonomy/many.twig.css'); } public static function updateTo_130_Build() { Moto\System\Log::info('@UPDATE 130 : Start'); Moto\System\Log::info('@UPDATE 130: Check and create category_list presets'); static::checkAndCreateCategoryListPresets(); $pageUpdated = Moto\Database\Page::where('type', '=', 'blog.index')->update(array('name' => 'Blog Main Page')); if ($pageUpdated) { Moto\System\Log::notice('@UPDATE 130 : rename Blog to Blog Main Page successfully'); } if (Moto\Website\Settings::isExists('sitemap_settings')) { $settings = Moto\Website\Settings::get('sitemap_settings'); $preferences = (array) Moto\Util::getValue($settings, 'content_preferences', []); $needToAdd = [ 'blog.category' => true, 'blog.tag' => true, ]; foreach ($preferences as $preference) { reset($needToAdd); foreach ($needToAdd as $type => $need) { if (Moto\Util::getValue($preference, 'type') === $type) { $needToAdd[$type] = false; } } } reset($needToAdd); foreach ($needToAdd as $type => $need) { if ($need) { $preferences[] = [ 'type' => $type, 'priority' => '0.5', 'frequency' => null ]; } } $settings['content_preferences'] = $preferences; Moto\Website\Settings::set('sitemap_settings', $settings); Moto\System\Log::info('@UPDATE 130: Update website.sitemap_settings by category and tag'); } else { Moto\System\Log::info('@UPDATE 130: Add website.sitemap_settings'); Moto\Website\Settings::add('sitemap_settings', '{"external_sitemaps":[],"content_preferences":[{"type":"@main_page","priority":"1.0","frequency":null},{"type":"page","priority":"0.8","frequency":null},{"type":"blog.index","priority":"0.8","frequency":null},{"type":"blog.post","priority":"0.5","frequency":null},{"type":"blog.category","priority":"0.5","frequency":null},{"type":"blog.tag","priority":"0.5","frequency":null}]}', 'array'); } Moto\Website\Settings::loadData(true); Moto\System\Log::info('@UPDATE 130 : End'); } public static function checkAndCreateCategoryListPresets() { $table = new Moto\Application\Presets\PresetsTable(); $table->useResultAsModel(true); $preset = $table->getWidgetPreset('blog.category_list', 'moto-preset-default'); if (!$preset) { $preset = $table->create(array( 'name' => 'Preset 1', 'widget_name' => 'blog.category_list', 'class_name' => 'moto-preset-default', 'is_system' => 1, 'is_responsive' => 0, 'properties' => '{"item":{"desktop":{"base":{"padding-bottom":"10px","border-bottom-style":"solid","border-bottom-color":"#d3d8db","border-bottom-width":"1px","margin-bottom":"10px"},"hover":[]}},"link":{"desktop":{"base":{"font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400","font-size":"16px","color":"#55616d"},"hover":{"color":"#2e3a46"}}},"icon":{"desktop":{"base":{"font-size":"8px","margin-right":"10px","color":"#2e3a46"},"hover":{"color":"#81868c"}}},"text":{"desktop":{"base":{"font-size":"16px","text-decoration":"none"},"hover":{"text-decoration":"underline"}}}}', 'template' => '@websiteWidgets/content_sections/templates/taxonomy_list/one.twig.css' )); try { $table->save($preset); } catch (\Exception $e) { Moto\System\Log::critical('Category List preset 1 not saved. Exception:', $e); } } $preset = $table->getWidgetPreset('blog.category_list', 'moto-preset-2'); if (!$preset) { $preset = $table->create(array( 'name' => 'Preset 2', 'widget_name' => 'blog.category_list', 'class_name' => 'moto-preset-2', 'is_system' => 1, 'is_responsive' => 0, 'properties' => '{"item":{"desktop":{"base":{"padding-bottom":"10px","border-bottom-style":"solid","border-bottom-color":"#2e3a46","border-bottom-width":"1px","margin-bottom":"10px"},"hover":[]}},"link":{"desktop":{"base":{"font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400","font-size":"16px","color":"#81868c"},"hover":{"color":"#ffffff","font-style":"normal","font-weight":"400"}}},"icon":{"desktop":{"base":{"font-size":"10px","margin-right":"10px","color":"#d3d8db"},"hover":{"color":"#55616d"}}},"text":{"desktop":{"base":{"font-size":"16px","text-decoration":"none"},"hover":{"text-decoration":""}}}}', 'template' => '@websiteWidgets/content_sections/templates/taxonomy_list/one.twig.css' )); try { $table->save($preset); } catch (\Exception $e) { Moto\System\Log::info('Category List preset 2 not saved. Exception:', $e); } } } public static function updateTo_140_Build() { Moto\System\Log::info('@UPDATE 140 : Start'); if (!Moto\Website\Settings::isExists('google_tag_manager')) { Moto\System\Log::info('@UPDATE 140: Add website.google_tag_manager'); Moto\Website\Settings::add('google_tag_manager', '{"id":""}', 'object'); } if (!Moto\Website\Settings::isExists('facebook_pixel')) { Moto\System\Log::info('@UPDATE 140: Add website.facebook_pixel'); Moto\Website\Settings::add('facebook_pixel', '{"id":""}', 'object'); } if (!Moto\Website\Settings::isExists('integration_feedback')) { Moto\System\Log::info('@UPDATE 140 : Create integration_feedback settings'); Moto\Website\Settings::add('integration_feedback', '{"provider":"none","options":{"visibility":{"notFoundPage":true,"underConstructionPage":true}},"providers":{"MotoCallback":{"thumbnails":{"openButton":{"type":"icon","icon":{"provider":"FontAwesome","id":"phone","unicode":"f095"},"image":[]},"agent":{"type":"icon","icon":{"provider":"FontAwesome","id":"user-circle-o","unicode":"f2be"},"image":[]}},"description":"<p class=\"moto-text_system_9\" style=\"text-align: center;\">John Smith<\/p><p class=\"moto-text_normal\" style=\"text-align: center;\">agent<\/p><p class=\"moto-text_system_8\" style=\"text-align: center;\"><a class=\"moto-link\" data-action=\"call\" href=\"tel:+112233445566\"><span class=\"fa\">\uf095<\/span> +112233445566<\/a><\/p>","moreDetails":{"properties":{"enabled":false,"displayByDefault":false},"items":[{"name":"telegram_chat","title":"Telegram","value":""},{"name":"whatsapp_chat","title":"WhatsApp","value":""},{"name":"viber_public_account","title":"Viber","value":""},{"name":"fb_messenger_chat","title":"Facebook Messenger","value":""},{"name":"skype_chat","title":"Skype (Chat)","value":""},{"name":"skype_call","title":"Skype (Call)","value":""},{"name":"vk_chat","title":"VK","value":""},{"name":"email","title":"Email","value":""}]}}}}', 'object'); } Moto\System\Log::info('@UPDATE 140 : Check and create moto callback preset'); static::checkAndCreateMotoCallbackPresets(); Moto\System\Log::info('@UPDATE 140 : End'); } public static function checkAndCreateMotoCallbackPresets() { $table = new Moto\Application\Presets\PresetsTable(); $table->useResultAsModel(true); $preset = $table->getWidgetPreset('moto_callback', 'moto-preset-default'); if (!$preset) { $preset = $table->create(array( 'name' => 'Preset 1', 'widget_name' => 'moto_callback', 'class_name' => 'moto-preset-default', 'is_system' => 1, 'is_responsive' => 0, 'properties' => '{"root":{"desktop":{"base":{"box-shadow":"0 4px 10px 0 rgba(46,58,70,.35)","background-color":"#ffffff","color":"#434f53","max-height":"80vh"}}},"root_open":{"desktop":{"base":{"border-radius":"3px","border-style":"none","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-color":"transparent"}}},"root_close":{"desktop":{"base":{"border-style":"none","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-color":"transparent","border-radius":"40px"}}},"position":{"direction":{"vertical":"bottom","horizontal":"right"},"values":{"desktop":{"vertical":"40px","horizontal":"40px"},"tablet":{"vertical":"35px","horizontal":"35px"},"mobile-h":{"vertical":"30px","horizontal":"30px"},"mobile-v":{"vertical":"25px","horizontal":"25px"}}},"open_button_overlay":{"desktop":{"base":{"background-color":"transparent"},"hover":{"background-color":"rgba(255, 255, 255, 0.35)"}}},"link_overlay":{"desktop":{"base":{"background-color":"transparent"},"hover":{"background-color":"rgba(255, 255, 255, .25)"}}},"divider":{"desktop":{"base":{"border-top-color":"#d3d8db","border-top-width":"1px"}}},"more_details_button":{"desktop":{"base":{"color":"#adb0b4"},"hover":{"color":"#81868c"}}},"close_button":{"desktop":{"base":{"color":"#adb0b4", "top": "9px", "right": "8px"},"hover":{"color":"#81868c"}}},"agent":{"desktop":{"base":{}}},"agent_image":{"desktop":{"base":{"border-radius":"40px","margin-bottom":"10px"}}},"agent_icon":{"desktop":{"base":{"font-size":"80px","margin-bottom":"10px"}}}}', 'template' => 'default' )); try { $table->save($preset); } catch (\Exception $e) { Moto\System\Log::critical('Moto Callback preset 1 not saved. Exception:', $e); } } Moto\Database\Models\Preset::query() ->where(['widget_name' => 'moto_callback']) ->whereIn('class_name', ['moto-preset-default']) ->get() ->each(function ($preset) { $properties = $preset->properties; if (!Moto\Util::arrayHas($properties, 'close_button.desktop.base.top')) { $properties['close_button']['desktop']['base']['top'] = '9px'; } if (!Moto\Util::arrayHas($properties, 'close_button.desktop.base.right')) { $properties['close_button']['desktop']['base']['right'] = '8px'; } $preset->properties = $properties; try { $preset->save(); } catch (\Exception $e) { Moto\System\Log::error('checkAndCreateMotoCallbackPresets: preset ' . $preset->class_name . ' not saved. Exception:', $e); throw $e; } Moto\System\Log::info('checkAndCreateMotoCallbackPresets: preset ' . $preset->class_name . ' saved'); }); } public static function checkAndCreateContentSliderPresets() { $table = new Moto\Application\Presets\PresetsTable(); $table->useResultAsModel(true); $preset = $table->getWidgetPreset('content_slider', 'moto-preset-default'); if (!$preset) { $preset = $table->create(array( 'name' => 'Preset 1', 'widget_name' => 'content_slider', 'class_name' => 'moto-preset-default', 'is_system' => 1, 'is_responsive' => 0, 'properties' => '{"preloader":{"desktop":{"base":{"color":"#181b27"}}},"arrows":{"desktop":{"base":{"background-color":"#899098","border-color":"#899098","color":"#ffffff","width":"50px","height":"50px","border-style":"none","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","top":"50%","transform":"translateY(-50%)","before":{"font-size":"30px"},"transition":".4s","font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400"},"hover":{"background-color":"#2e3a46","border-color":"#2e3a46","color":""}},"tablet":{"base":{"width":"40px","height":"40px","before":{"font-size":"20px"}}},"mobile-h":{"base":{"width":"24px","height":"24px","before":{"font-size":"12px"}}}},"arrow_prev":{"desktop":{"base":{"left":"40px","before":{"content":{"provider":"FontAwesome","id":"angle-left","unicode":"f104"}}}},"tablet":{"base":{"left":"40px"}},"mobile-h":{"base":{"left":"10px"}}},"arrow_next":{"desktop":{"base":{"right":"40px","before":{"content":{"provider":"FontAwesome","id":"angle-right","unicode":"f105"}}}},"tablet":{"base":{"right":"40px"}},"mobile-h":{"base":{"right":"10px"}}},"pagination":{"desktop":{"base":{"border-style":"none","width":"12px","height":"12px","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","background-color":"#d3d8db","color":"#2e3a46","transition":".4s","font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400"},"hover":{"background-color":"#81868c"}}},"pagination_selected":{"desktop":{"base":{"color":"#ffffff","background-color":"#2e3a46","border-color":"#2e3a46"},"hover":[]}},"pagination_wrapper":{"desktop":{"base":{"left":"50%","transform":"translateX(-50%)","bottom":"40px"}},"tablet":{"base":{"bottom":"20px"}}},"pagination_spacings":{"desktop":{"base":{"margin-right":"6px"},"hover":[]}}}', 'template' => 'default' )); try { $table->save($preset); } catch (\Exception $e) { Moto\System\Log::critical('Content Slider preset 1 not saved. Exception:', $e); } } $preset = $table->getWidgetPreset('content_slider', 'moto-preset-2'); if (!$preset) { $preset = $table->create(array( 'name' => 'Preset 2', 'widget_name' => 'content_slider', 'class_name' => 'moto-preset-2', 'is_system' => 1, 'is_responsive' => 0, 'properties' => '{"preloader":{"desktop":{"base":{"color":"#181b27"}}},"arrows":{"desktop":{"base":{"background-color":"#899098","border-color":"#899098","color":"#ffffff","width":"50px","height":"50px","border-style":"none","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"50px","top":"50%","transform":"translateY(-50%)","before":{"font-size":"30px"},"transition":".4s","font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400"},"hover":{"background-color":"#2e3a46","border-color":"#2e3a46","color":""}},"tablet":{"base":{"width":"40px","height":"40px","before":{"font-size":"20px"}}},"mobile-h":{"base":{"width":"24px","height":"24px","before":{"font-size":"12px"}}}},"arrow_prev":{"desktop":{"base":{"left":"40px","before":{"content":{"provider":"FontAwesome","id":"angle-left","unicode":"f104"}}}},"tablet":{"base":{"left":"40px"}},"mobile-h":{"base":{"left":"10px"}}},"arrow_next":{"desktop":{"base":{"right":"40px","before":{"content":{"provider":"FontAwesome","id":"angle-right","unicode":"f105"}}}},"tablet":{"base":{"right":"40px"}},"mobile-h":{"base":{"right":"10px"}}},"pagination":{"desktop":{"base":{"border-style":"none","width":"12px","height":"12px","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"50px","background-color":"#d3d8db","color":"#2e3a46","transition":".4s","font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400","font-size":"0px"},"hover":{"background-color":"#81868c","color":"#ffffff"}}},"pagination_selected":{"desktop":{"base":{"color":"#ffffff","background-color":"#2e3a46","border-color":"#2e3a46"},"hover":[]}},"pagination_wrapper":{"desktop":{"base":{"left":"50%","transform":"translateX(-50%)","bottom":"40px"}},"tablet":{"base":{"bottom":"20px"}}},"pagination_spacings":{"desktop":{"base":{"margin-right":"6px"},"hover":[]}}}', 'template' => 'default' )); try { $table->save($preset); } catch (\Exception $e) { Moto\System\Log::critical('Content Slider preset 2 not saved. Exception:', $e); } } } public static function checkAndCreateBreadcrumbsPresets() { static::checkAndCreateWidgetPreset('breadcrumbs', 1, '{"list":{"desktop":{"base":{"background-color":"transparent","border-bottom-width":"0px","border-right-width":"0px","border-left-width":"0px","border-top-width":"0px","border-color":"transparent","border-radius":"0px","border-style":"none"}}},"item_content":{"desktop":{"base":{"font-family":"tahoma, arial, helvetica, sans-serif","font-size":"12px","font-style":"normal","font-weight":"400","padding-bottom":"0px","padding-right":"0px","padding-left":"0px","padding-top":"0px","background-color":"transparent","border-bottom-width":"0px","border-right-width":"0px","border-left-width":"0px","border-top-width":"0px","border-color":"transparent","border-radius":"0px","border-style":"none"},"hover":[]}},"item_link":{"desktop":{"base":{"color":"#55616d","text-decoration":"none"},"hover":{"color":"#2e3a46","text-decoration":""}}},"item_current":{"desktop":{"base":{"color":"#55616d"}}},"delimiter":{"desktop":{"base":{"font-family":"tahoma, arial, helvetica, sans-serif","font-size":"12px","font-style":"normal","font-weight":"400","color":"#55616d"}}},"icon":{"desktop":{"base":{"color":"#55616d","font-size":"12px","margin-right":"5px"},"hover":{"color":"#2e3a46"}}},"spacing":{"desktop":{"base":{"margin-right":"10px"}}}}'); static::checkAndCreateWidgetPreset('breadcrumbs', 2, '{"list":{"desktop":{"base":{"background-color":"transparent","border-bottom-width":"0px","border-right-width":"0px","border-left-width":"0px","border-top-width":"0px","border-color":"transparent","border-radius":"0px","border-style":"none"}}},"item_content":{"desktop":{"base":{"font-family":"tahoma, arial, helvetica, sans-serif","font-size":"12px","font-style":"normal","font-weight":"400","padding-bottom":"0px","padding-right":"0px","padding-left":"0px","padding-top":"0px","background-color":"transparent","border-bottom-width":"0px","border-right-width":"0px","border-left-width":"0px","border-top-width":"0px","border-color":"transparent","border-radius":"0px","border-style":"none"},"hover":[]}},"item_link":{"desktop":{"base":{"color":"#ffffff","text-decoration":"none"},"hover":{"color":"#d3d8db","text-decoration":""}}},"item_current":{"desktop":{"base":{"color":"#ffffff"}}},"delimiter":{"desktop":{"base":{"font-family":"tahoma, arial, helvetica, sans-serif","font-size":"12px","font-style":"normal","font-weight":"400","color":"#ffffff"}}},"icon":{"desktop":{"base":{"color":"#ffffff","font-size":"12px","margin-right":"5px"},"hover":{"color":"#d3d8db"}}},"spacing":{"desktop":{"base":{"margin-right":"10px"}}}}'); } public static function updateTo_160_Build() { Moto\System\Log::info('@UPDATE 160 : Start'); $prefix = static::_getTablePrefix(); $databaseAdapter = static::_getDatabaseAdapter(); try { $sql = 'UPDATE `' . $prefix . 'settings` SET `type` = "int" WHERE `name` IN ("system.build", "website.main_page", "website.language_id", "website.notfound_page_id", "website.password_protected_page_id") AND `type` = ""'; $databaseAdapter->query($sql)->execute(); $sql = 'UPDATE `' . $prefix . 'settings` SET `type` = "object" WHERE `name` IN ("website.back_to_top_button", "website.password_protection") AND `type` = ""'; $databaseAdapter->query($sql)->execute(); Moto\Website\Settings::loadData(true); if (!Moto\Website\Settings::isExists('home_page_provider')) { Moto\System\Log::info('@UPDATE 160 : Add website.home_page_provider'); Moto\Website\Settings::add('home_page_provider', '{"name": "default"}', 'object'); } Moto\Website\Settings::loadData(true); } catch (\Exception $e) { Moto\System\Log::critical('@UPDATE : DataBase : ' . $e->getMessage()); throw $e; } try { Moto\System\Log::info('@UPDATE 160: Check and create breadcrumbs presets'); static::checkAndCreateBreadcrumbsPresets(); } catch (\Exception $e) { throw new \Exception('CANT_UPGRADE'); } Moto\System\Log::info('@UPDATE 160 : Add setting website.open_graph_settings'); try { Moto\Website\Settings::add('open_graph_settings', '{"default":true}', 'object'); } catch (\Exception $exception) { Moto\System\Log::critical('@UPDATE 160 : Updating settings : ' . $exception->getMessage()); throw $exception; } $records = Moto\Database\Models\ContentTaxonomy::query()->get(); if ($records->count()) { Moto\System\Log::info('@UPDATE 160 : Update Taxonomy meta structure - add Open Graph tags'); foreach ($records as $record) { $properties = $record->properties; if (is_object($properties)) { $properties = json_decode(json_encode($properties), true); } if (!is_array($properties)) { continue; } if (Moto\Util::arrayHas($properties, 'meta.og')) { continue; } $properties['meta']['og'] = [ 'title' => '', 'description' => '', 'url' => '', 'image' => [ 'id' => null, 'name' => '', 'size' => '', 'path' => '', ], ]; $record->properties = $properties; $record->save(); } } Moto\Website\Settings::loadData(true); Moto\System\Log::info('@UPDATE 160 : Done'); } public static function updateTo_180_Build() { Moto\System\Log::info('@UPDATE 180 : Start'); Moto\Website\Settings::loadData(true); if (!Moto\Website\Settings::isExists('control_panel_analytics')) { Moto\System\Log::info('@UPDATE 180: Add website.control_panel_analytics'); Moto\Website\Settings::add('control_panel_analytics', '{"enabled": null}', 'array'); } Moto\Website\Settings::loadData(true); Moto\System\Log::info('@UPDATE 180 : upgradeResponsiveTextStyles'); static::upgradeResponsiveTextStyles(); Moto\System\Log::info('@UPDATE 180 : end upgradeResponsiveTextStyles'); Moto\System\Log::info('@UPDATE 180 : Done'); } protected static function checkAndCreateWidgetPreset($widgetName, $presetNumber, $properties, $template = 'default') { Moto\System\Log::info('@checkAndCreateWidgetPreset: Start creating ' . $presetNumber . ' preset for ' . $widgetName); $table = new Moto\Application\Presets\PresetsTable(); $table->useResultAsModel(true); $presetClass = 'moto-preset-' . (($presetNumber === 1) ? 'default' : $presetNumber); $preset = $table->getWidgetPreset($widgetName, $presetClass); if (!$preset) { $preset = $table->create(array( 'name' => 'Preset ' . $presetNumber, 'widget_name' => $widgetName, 'class_name' => $presetClass, 'is_system' => 1, 'is_responsive' => 0, 'properties' => $properties, 'template' => $template )); try { $table->save($preset); Moto\System\Log::info('@checkAndCreateWidgetPreset: Created ' . $presetNumber . ' preset for ' . $widgetName); } catch (\Exception $e) { Moto\System\Log::critical('@checkAndCreateWidgetPreset: ' . $widgetName . ' preset ' . $presetNumber . ' not saved. Exception:', $e); } } } public static function upgradeResponsiveTextStyle($item) { if (!is_object($item)) { return false; } if (!property_exists($item, 'is_responsive') || !property_exists($item, 'properties')) { return false; } if ($item->is_responsive) { return false; } $defaultStyles = [ 'base' => [] ]; $properties = $item->properties; $propertiesAsString = is_string($properties); if ($propertiesAsString) { $properties = json_decode($properties, true); } if (!is_array($properties)) { return false; } $properties['tablet'] = $defaultStyles; $properties['mobile-h'] = $defaultStyles; $properties['mobile-v'] = $defaultStyles; if ($propertiesAsString) { $item->properties = json_encode($properties); } else { $item->properties = $properties; } $item->is_responsive = 1; return true; } public static function upgradeResponsiveTextStyles() { $table = new Moto\Application\Styles\StylesTable(); $table->useResultAsModel(false); $items = $table->select(array( 'type' => 'text', 'is_responsive' => 0, )); if ($items->count() < 1) { return; } foreach ($items as $item) { Moto\System\Log::info('upgradeResponsiveTextStyles: ' . $item->name); static::upgradeResponsiveTextStyle($item); $table->save($item); } } public static function updateTo_200_Build() { Moto\System\Log::info('@UPDATE 200 : Start'); Moto\System\Log::info('@UPDATE 200 : upgradeBreadcrumbsPreset'); static::upgradeBreadcrumbsPreset(); Moto\System\Log::info('@UPDATE 200 : end upgradeBreadcrumbsPreset'); Moto\System\Log::info('@UPDATE 200 : checkAndCreateWidgetPreset form_elements'); static::checkAndCreateFormElementsPresets(); Moto\System\Log::info('@UPDATE 200 : end checkAndCreateWidgetPreset form_elements'); Moto\System\Log::info('@UPDATE 200 : add bn_IN locale'); $language = Moto\Database\Models\Language::firstOrNew(['locale' => 'bn_IN']); if (!$language->exists) { $language->fill([ 'code' => 'bn', 'locale' => 'bn_IN', 'name' => 'বাংলা' ]); $language->save(); } Moto\System\Log::info('@UPDATE 200 : end add bn_IN locale'); Moto\System\Log::info('@UPDATE 200 : Done'); } public static function checkAndCreateFormElementsPresets() { static::checkAndCreateWidgetPreset('form_elements', 1, '{"field_with_icon":{"desktop":{"base":{"padding-left":"42px"}}},"field_icon":{"desktop":{"base":{"font-size":"18px","left":"10px","color":"#7e81a5"},"focus":{},"error":{"color":"#ff6464"}}},"field_control":{"desktop":{"base":{"font-size":"15px","line-height":"1.6","border-radius":"2px","border-style":"solid","border-top-width":"1px","border-left-width":"1px","border-right-width":"1px","border-bottom-width":"1px","font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400","moto-placeholder-color":"#7e81a5","border-color":"#d3d8db","color":"#353159","background-color":"#ffffff"},"focus":{"border-color":"#09a4fb"},"error":{"border-color":"#ff6464"}}},"field_controls_input_select":{"desktop":{"base":{"height":"44px","padding-top":"0","padding-bottom":"0","padding-left":"15px","padding-right":"15px"}}},"field_control_textarea":{"desktop":{"base":{"padding-top":"10px","padding-bottom":"10px","padding-left":"15px","padding-right":"15px"}}},"error_item":{"desktop":{"base":{"font-size":"12px","line-height":"1.2","font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400","color":"#ff6464","margin-top":"5px"}}},"radio_text":{"desktop":{"base":{"margin-left":"10px"}}},"checkbox_text":{"desktop":{"base":{"margin-left":"10px"}}},"checkbox_label_text":{"desktop":{"base":{"color":"#353159","font-size":"15px","line-height":"1.6","font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400"}}},"radio_label_text":{"desktop":{"base":{"color":"#353159","font-size":"15px","line-height":"1.6","font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400"}}},"checkbox_icon":{"desktop":{"base":{"color":"#7e81a5","font-size":"20px"},"before":{"content":{"provider":"FontAwesome","id":"square-o","unicode":"f096"}}}},"checkbox_icon_checked":{"desktop":{"base":{"color":"#353159"},"before":{"content":{"provider":"FontAwesome","id":"check-square","unicode":"f14a"}}}},"radio_icon":{"desktop":{"base":{"color":"#7e81a5","font-size":"20px"},"before":{"content":{"provider":"FontAwesome","id":"circle-thin","unicode":"f1db"}}}},"radio_icon_checked":{"desktop":{"base":{"color":"#353159"},"before":{"content":{"provider":"FontAwesome","id":"dot-circle-o","unicode":"f192"}}}},"radio_option_vertical":{"desktop":{"base":{"margin-bottom":"10px"}}},"radio_option_horizontal":{"desktop":{"base":{"margin-right":"30px"}}},"extra":{"field_icon_spacings":{"desktop":{"left":9,"right":9}}}}'); static::checkAndCreateWidgetPreset('form_elements', 2, '{"field_with_icon":{"desktop":{"base":{"padding-left":"42px"}}},"field_icon":{"desktop":{"base":{"font-size":"18px","left":"10px","color":"#4e5964"},"focus":{},"error":{"color":"#ff6464"}}},"field_control":{"desktop":{"base":{"font-size":"15px","line-height":"1.6","border-radius":"2px","border-style":"solid","border-top-width":"1px","border-left-width":"1px","border-right-width":"1px","border-bottom-width":"1px","font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400","moto-placeholder-color":"#4e5964","border-color":"#4e5964","color":"#ffffff","background-color":"#10151b"},"focus":{"border-color":"#8a98a5"},"error":{"border-color":"#ff6464"}}},"field_controls_input_select":{"desktop":{"base":{"height":"44px","padding-top":"0","padding-bottom":"0","padding-left":"15px","padding-right":"15px"}}},"field_control_textarea":{"desktop":{"base":{"padding-top":"10px","padding-bottom":"10px","padding-left":"15px","padding-right":"15px"}}},"error_item":{"desktop":{"base":{"font-size":"12px","line-height":"1.2","font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400","color":"#ff6464","margin-top":"5px"}}},"radio_text":{"desktop":{"base":{"margin-left":"10px"}}},"checkbox_text":{"desktop":{"base":{"margin-left":"10px"}}},"checkbox_label_text":{"desktop":{"base":{"color":"#8a98a5","font-size":"15px","line-height":"1.6","font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400"}}},"radio_label_text":{"desktop":{"base":{"color":"#8a98a5","font-size":"15px","line-height":"1.6","font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400"}}},"checkbox_icon":{"desktop":{"base":{"color":"#4e5964","font-size":"20px"},"before":{"content":{"provider":"FontAwesome","id":"square-o","unicode":"f096"}}}},"checkbox_icon_checked":{"desktop":{"base":{"color":"#8a98a5"},"before":{"content":{"provider":"FontAwesome","id":"check-square","unicode":"f14a"}}}},"radio_icon":{"desktop":{"base":{"color":"#4e5964","font-size":"20px"},"before":{"content":{"provider":"FontAwesome","id":"circle-thin","unicode":"f1db"}}}},"radio_icon_checked":{"desktop":{"base":{"color":"#8a98a5"},"before":{"content":{"provider":"FontAwesome","id":"dot-circle-o","unicode":"f192"}}}},"radio_option_vertical":{"desktop":{"base":{"margin-bottom":"10px"}}},"radio_option_horizontal":{"desktop":{"base":{"margin-right":"30px"}}},"extra":{"field_icon_spacings":{"desktop":{"left":9,"right":9}}}}'); static::checkAndCreateWidgetPreset('form_elements', 3, '{"field_with_icon":{"desktop":{"base":{"padding-left":"42px"}}},"field_icon":{"desktop":{"base":{"font-size":"18px","left":"10px","color":"#7e81a5"},"focus":{},"error":{"color":"#ff6464"}}},"field_control":{"desktop":{"base":{"font-size":"15px","line-height":"1.6","border-radius":"25px","border-style":"solid","border-top-width":"1px","border-left-width":"1px","border-right-width":"1px","border-bottom-width":"1px","font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400","moto-placeholder-color":"#7e81a5","border-color":"#d3d8db","color":"#353159","background-color":"#ffffff"},"focus":{"border-color":"#09a4fb"},"error":{"border-color":"#ff6464"}}},"field_controls_input_select":{"desktop":{"base":{"height":"44px","padding-top":"0","padding-bottom":"0","padding-left":"15px","padding-right":"15px"}}},"field_control_textarea":{"desktop":{"base":{"padding-top":"10px","padding-bottom":"10px","padding-left":"15px","padding-right":"15px"}}},"error_item":{"desktop":{"base":{"font-size":"12px","line-height":"1.2","font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400","color":"#ff6464","margin-top":"5px"}}},"radio_text":{"desktop":{"base":{"margin-left":"10px"}}},"checkbox_text":{"desktop":{"base":{"margin-left":"10px"}}},"checkbox_label_text":{"desktop":{"base":{"color":"#353159","font-size":"15px","line-height":"1.6","font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400"}}},"radio_label_text":{"desktop":{"base":{"color":"#353159","font-size":"15px","line-height":"1.6","font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400"}}},"checkbox_icon":{"desktop":{"base":{"color":"#7e81a5","font-size":"20px"},"before":{"content":{"provider":"FontAwesome","id":"square-o","unicode":"f096"}}}},"checkbox_icon_checked":{"desktop":{"base":{"color":"#353159"},"before":{"content":{"provider":"FontAwesome","id":"check-square","unicode":"f14a"}}}},"radio_icon":{"desktop":{"base":{"color":"#7e81a5","font-size":"20px"},"before":{"content":{"provider":"FontAwesome","id":"circle-thin","unicode":"f1db"}}}},"radio_icon_checked":{"desktop":{"base":{"color":"#353159"},"before":{"content":{"provider":"FontAwesome","id":"dot-circle-o","unicode":"f192"}}}},"radio_option_vertical":{"desktop":{"base":{"margin-bottom":"10px"}}},"radio_option_horizontal":{"desktop":{"base":{"margin-right":"30px"}}},"extra":{"field_icon_spacings":{"desktop":{"left":9,"right":9}}}}'); static::checkAndCreateWidgetPreset('form_elements', 4, '{"field_with_icon":{"desktop":{"base":{"padding-left":"42px"}}},"field_icon":{"desktop":{"base":{"font-size":"18px","left":"10px","color":"#4e5964"},"focus":{},"error":{"color":"#ff6464"}}},"field_control":{"desktop":{"base":{"font-size":"15px","line-height":"1.6","border-radius":"25px","border-style":"solid","border-top-width":"1px","border-left-width":"1px","border-right-width":"1px","border-bottom-width":"1px","font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400","moto-placeholder-color":"#4e5964","border-color":"#4e5964","color":"#ffffff","background-color":"#10151b"},"focus":{"border-color":"#8a98a5"},"error":{"border-color":"#ff6464"}}},"field_controls_input_select":{"desktop":{"base":{"height":"44px","padding-top":"0","padding-bottom":"0","padding-left":"15px","padding-right":"15px"}}},"field_control_textarea":{"desktop":{"base":{"padding-top":"10px","padding-bottom":"10px","padding-left":"15px","padding-right":"15px"}}},"error_item":{"desktop":{"base":{"font-size":"12px","line-height":"1.2","font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400","color":"#ff6464","margin-top":"5px"}}},"radio_text":{"desktop":{"base":{"margin-left":"10px"}}},"checkbox_text":{"desktop":{"base":{"margin-left":"10px"}}},"checkbox_label_text":{"desktop":{"base":{"color":"#8a98a5","font-size":"15px","line-height":"1.6","font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400"}}},"radio_label_text":{"desktop":{"base":{"color":"#8a98a5","font-size":"15px","line-height":"1.6","font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400"}}},"checkbox_icon":{"desktop":{"base":{"color":"#4e5964","font-size":"20px"},"before":{"content":{"provider":"FontAwesome","id":"square-o","unicode":"f096"}}}},"checkbox_icon_checked":{"desktop":{"base":{"color":"#8a98a5"},"before":{"content":{"provider":"FontAwesome","id":"check-square","unicode":"f14a"}}}},"radio_icon":{"desktop":{"base":{"color":"#4e5964","font-size":"20px"},"before":{"content":{"provider":"FontAwesome","id":"circle-thin","unicode":"f1db"}}}},"radio_icon_checked":{"desktop":{"base":{"color":"#8a98a5"},"before":{"content":{"provider":"FontAwesome","id":"dot-circle-o","unicode":"f192"}}}},"radio_option_vertical":{"desktop":{"base":{"margin-bottom":"10px"}}},"radio_option_horizontal":{"desktop":{"base":{"margin-right":"30px"}}},"extra":{"field_icon_spacings":{"desktop":{"left":9,"right":9}}}}'); } public static function upgradeBreadcrumbsPreset() { $upgradePresetProperties = function ($properties) { if (isset($properties['item_content']['desktop']['base']['border-style'])) { $properties['item_link']['desktop']['base']['border-bottom-width'] = $properties['item_current']['desktop']['base']['border-bottom-width'] = $properties['item_content']['desktop']['base']['border-bottom-width']; $properties['item_link']['desktop']['base']['border-right-width'] = $properties['item_current']['desktop']['base']['border-right-width'] = $properties['item_content']['desktop']['base']['border-right-width']; $properties['item_link']['desktop']['base']['border-left-width'] = $properties['item_current']['desktop']['base']['border-left-width'] = $properties['item_content']['desktop']['base']['border-left-width']; $properties['item_link']['desktop']['base']['border-top-width'] = $properties['item_current']['desktop']['base']['border-top-width'] = $properties['item_content']['desktop']['base']['border-top-width']; $properties['item_link']['desktop']['base']['border-radius'] = $properties['item_current']['desktop']['base']['border-radius'] = $properties['item_content']['desktop']['base']['border-radius']; $properties['item_link']['desktop']['base']['border-color'] = $properties['item_current']['desktop']['base']['border-color'] = $properties['item_content']['desktop']['base']['border-color']; $properties['item_link']['desktop']['base']['border-style'] = $properties['item_current']['desktop']['base']['border-style'] = $properties['item_content']['desktop']['base']['border-style']; unset($properties['item_content']['desktop']['base']['border-bottom-width']); unset($properties['item_content']['desktop']['base']['border-right-width']); unset($properties['item_content']['desktop']['base']['border-left-width']); unset($properties['item_content']['desktop']['base']['border-top-width']); unset($properties['item_content']['desktop']['base']['border-radius']); unset($properties['item_content']['desktop']['base']['border-color']); unset($properties['item_content']['desktop']['base']['border-style']); } return $properties; }; $upgradePreset = function ($presetName) use ($upgradePresetProperties) { $table = new Moto\Application\Presets\PresetsTable(); $table->useResultAsModel(true); $preset = $table->getWidgetPreset('breadcrumbs', $presetName); if ($preset) { $properties = json_decode($preset->properties, true); $properties = $upgradePresetProperties($properties); $preset->properties = json_encode($properties); try { $table->save($preset); } catch (\Exception $e) { Moto\System\Log::error('Update for breadcrumbs presets not saved. Exception:', $e); } } }; $upgradePreset('moto-preset-default'); $upgradePreset('moto-preset-2'); } public static function updateTo_210_Build() { Moto\System\Log::info('@UPDATE 210 : Start'); Moto\System\Log::info('@UPDATE 210 : upgradeContentSliderPresetForAutoControls'); static::upgradeContentSliderPresetForAutoControls(); Moto\System\Log::info('@UPDATE 210 : end upgradeContentSliderPresetForAutoControls'); $prefix = static::_getTablePrefix(); $databaseAdapter = static::_getDatabaseAdapter(); try { Moto\System\Log::info('@UPDATE 210 : Patching structure & content of table `fonts`'); $sql = "ALTER TABLE `{$prefix}fonts`
CHANGE `family` `family` VARCHAR( 100 ) NULL DEFAULT '',
CHANGE `category` `category` VARCHAR( 14 ) NULL DEFAULT '',
CHANGE `last_modified` `last_modified` VARCHAR( 10 ) NULL DEFAULT '',
CHANGE `variants` `variants` TEXT NULL DEFAULT NULL,
CHANGE `subsets` `subsets` TEXT NULL DEFAULT NULL,
CHANGE `active_variants` `active_variants` TEXT NULL DEFAULT NULL,
CHANGE `active_subsets` `active_subsets` TEXT NULL DEFAULT NULL
"; $databaseAdapter->query($sql)->execute(); $sql = "SHOW COLUMNS FROM `{$prefix}fonts` WHERE `Field` = 'properties'"; $isExists = $databaseAdapter->query($sql)->execute()->current(); if (!$isExists) { $sql = "ALTER TABLE `{$prefix}fonts` ADD `properties` TEXT NULL DEFAULT NULL AFTER `version`"; $databaseAdapter->query($sql)->execute(); } $db = Moto\Database\Provider::getDatabaseCapsule(); $db->table('fonts')->whereIn('variants', ['', 'null'])->update(['variants' => '[]']); $db->table('fonts')->whereIn('subsets', ['', 'null'])->update(['subsets' => '[]']); $db->table('fonts')->whereIn('active_variants', ['', 'null'])->update(['active_variants' => '[]']); $db->table('fonts')->whereIn('active_subsets', ['', 'null'])->update(['active_subsets' => '[]']); } catch (\Exception $e) { Moto\System\Log::critical('@UPDATE 210 : DataBase : ' . $e->getMessage()); throw $e; } Moto\Util::createNotWebIndexingDir('@customFontsDir'); Moto\System\Log::info('@UPDATE 210 : Done'); } public static function upgradeContentSliderPresetForAutoControls() { $upgradePresetProperties = function ($properties) { if (!isset($properties['auto'])) { $properties['auto'] = [ 'desktop' => [ 'base' => [ 'color' => '#d3d8db', 'transition' => '0.4s', 'before' => [ 'font-size' => '22px', ], ], 'hover' => [ 'color' => '#81868c', ], ], ]; } if (!isset($properties['auto_start'])) { $properties['auto_start'] = [ 'desktop' => [ 'before' => [ 'content' => [ 'provider' => 'FontAwesome', 'id' => 'play', 'unicode' => 'f04b', ], ], ], ]; } if (!isset($properties['auto_stop'])) { $properties['auto_stop'] = [ 'desktop' => [ 'before' => [ 'content' => [ 'provider' => 'FontAwesome', 'id' => 'pause', 'unicode' => 'f04c', ], ], ], ]; } if (!isset($properties['auto_wrapper'])) { $properties['auto_wrapper'] = [ 'desktop' => [ 'base' => [ 'right' => '65px', 'bottom' => '48px', ], ], 'tablet' => [ 'base' => [ 'right' => '60px', 'bottom' => '28px', ], ], 'mobile-h' => [ 'base' => [ 'right' => '22px', ], ], ]; } return $properties; }; $upgradePreset = function ($presetName) use ($upgradePresetProperties) { $table = new Moto\Application\Presets\PresetsTable(); $table->useResultAsModel(true); $preset = $table->getWidgetPreset('content_slider', $presetName); if ($preset) { $properties = json_decode($preset->properties, true); $properties = $upgradePresetProperties($properties); $preset->properties = json_encode($properties); try { $table->save($preset); } catch (\Exception $e) { Moto\System\Log::error('Update for content_slider presets not saved. Exception:', $e); } } }; $upgradePreset('moto-preset-default'); $upgradePreset('moto-preset-2'); } public static function updateCategoryListPresetsForPostsCounter() { $upgradePresetProperties = function ($properties) { if (!isset($properties['posts_count'])) { $properties['posts_count'] = [ 'desktop' => [ 'base' => [ 'color' => '#55616d', 'font-family' => 'tahoma, arial, helvetica, sans-serif', 'font-style' => 'normal', 'font-weight' => '400', 'font-size' => '16px', 'margin-left' => '10px', ], ], ]; } if (!isset($properties['posts_count']['desktop']['hover'])) { $properties['posts_count']['desktop']['hover'] = [ 'color' => '', ]; } return $properties; }; $upgradePreset = function ($presetName) use ($upgradePresetProperties) { $preset = Moto\Database\Models\Preset::where([ 'widget_name' => 'blog.category_list', 'class_name' => $presetName, ])->first(); if ($preset) { $preset->properties = $upgradePresetProperties($preset->properties); try { $preset->save(); } catch (\Exception $e) { Moto\System\Log::error('Update for blog.category_list presets not saved. Exception:', $e); } } }; $upgradePreset('moto-preset-default'); $upgradePreset('moto-preset-2'); } public static function updateDividerPresetsForDirections() { $moveBorderProperties = function ($newDirection, $input) { $input['border-' . $newDirection . '-color'] = Moto\Util::getValue($input, 'border-top-color', '#111111'); $input['border-' . $newDirection . '-width'] = Moto\Util::getValue($input, 'border-top-width', '1px'); $input['border-' . $newDirection . '-style'] = Moto\Util::getValue($input, 'border-top-style', 'solid'); unset($input['border-top-color'], $input['border-top-width'], $input['border-top-style']); return $input; }; Moto\Database\Models\Preset::query() ->where(['widget_name' => 'divider_horizontal']) ->whereIn('class_name', [ 'moto-preset-default', 'moto-preset-2', 'moto-preset-3', ]) ->get() ->each(function ($preset) use ($moveBorderProperties) { $properties = $preset->properties; $line = Moto\Util::getValue($properties, 'line.desktop.base'); if (!$line) { return; } $properties['line_top'] = [ 'desktop' => [ 'base' => $line, ], ]; $properties['line_left'] = [ 'desktop' => [ 'base' => $moveBorderProperties('left', $line), ], ]; $properties['line_right'] = [ 'desktop' => [ 'base' => $moveBorderProperties('right', $line), ], ]; $properties['line_bottom'] = [ 'desktop' => [ 'base' => $moveBorderProperties('bottom', $line), ], ]; unset($properties['line']); $preset->properties = $properties; try { $preset->save(); } catch (\Exception $e) { Moto\System\Log::error('updateDividerPresetsForDirections: preset ' . $preset->class_name . ' not saved. Exception:', $e); throw $e; } Moto\System\Log::info('updateDividerPresetsForDirections: preset ' . $preset->class_name . ' saved'); }); } public static function updateSliderPresetsForThumbnailPagination() { Moto\Database\Models\Preset::query() ->where(['widget_name' => 'slider']) ->whereIn('class_name', [ 'moto-preset-default', 'moto-preset-2', ]) ->get() ->each(function ($preset) { $properties = $preset->properties; if (!Moto\Util::getValue($properties, 'thumbnail_pagination')) { $properties['thumbnail_pagination'] = [ 'desktop' => [ 'base' => [ 'margin-top' => '0px', ], ], ]; } if (!Moto\Util::getValue($properties, 'thumbnail_pagination_item')) { $properties['thumbnail_pagination_item'] = [ 'desktop' => [ 'base' => [ 'height' => '75px', 'width' => '100px', 'margin-right' => '5px', 'border-style' => 'solid', 'border-left-width' => '1px', 'border-top-width' => '1px', 'border-right-width' => '1px', 'border-bottom-width' => '1px', 'border-radius' => '10px', 'border-color' => '#d3d8db', 'before' => [ 'background-color' => 'rgba(0,0,0,0)', ], ], 'hover' => [ 'border-color' => 'rgba(0,0,0,.15)', 'before' => [ 'background-color' => 'rgba(0,0,0,.15)', ], ], ], ]; } if (!Moto\Util::getValue($properties, 'current_thumbnail_pagination_item')) { $properties['current_thumbnail_pagination_item'] = [ 'desktop' => [ 'base' => [ 'border-color' => '#d3d8db', 'before' => [ 'background-color' => 'rgba(0,0,0,.05)', ], ], 'hover' => [ 'border-color' => 'rgba(0,0,0,.15)', 'before' => [ 'background-color' => 'rgba(0,0,0,.15)', ], ], ], ]; } $preset->properties = $properties; try { $preset->save(); } catch (\Exception $e) { Moto\System\Log::error('createThumbnailPaginationProperties: preset ' . $preset->class_name . ' not saved. Exception:', $e); throw $e; } Moto\System\Log::info('createThumbnailPaginationProperties: preset ' . $preset->class_name . ' saved'); }); } public static function checkAndCreateTablePresets() { static::checkAndCreateWidgetPreset('text.table', 1, '{"table":{"desktop":{"base":{"border-style":"solid","border-left-width":"0px","border-top-width":"1px","border-right-width":"0px","border-bottom-width":"1px","border-radius":"0px","border-color":"#d3d8db"},"hover":[]}},"cell":{"desktop":{"base":{"border-style":"solid","border-left-width":"1px","border-right-width":"1px","border-bottom-width":"0px","border-top-width":"0px","border-radius":"0px","border-color":"#d3d8db"},"hover":[]}},"header_row":{"desktop":{"base":{"background-color":"#55616d"},"hover":[]}},"even_row":{"desktop":{"base":{"background-color":"#f4f5f6"},"hover":{"background-color":"#c0c2c5"}}},"odd_row":{"desktop":{"base":{"background-color":"#ffffff"},"hover":{"background-color":"#c0c2c5"}}},"row":{"desktop":{"base":{"background-color":"#ffffff"},"hover":{"background-color":"#c0c2c5"}}},"header_column":{"desktop":{"base":{"background-color":"#2e3a46"},"hover":[]}}}', '@websiteWidgets/text/templates/table.twig.css'); static::checkAndCreateWidgetPreset('text.table', 2, '{"table":{"desktop":{"base":{"border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","border-color":"#55616d"},"hover":[]}},"cell":{"desktop":{"base":{"border-style":"solid","border-left-width":"1px","border-right-width":"1px","border-bottom-width":"1px","border-top-width":"1px","border-radius":"0px","border-color":"#55616d"},"hover":[]}},"header_row":{"desktop":{"base":{"background-color":"#414d59"},"hover":[]}},"even_row":{"desktop":{"base":{"background-color":"#384450"},"hover":{"background-color":"#818991"}}},"odd_row":{"desktop":{"base":{"background-color":"#2e3a46"},"hover":{"background-color":"#818991"}}},"row":{"desktop":{"base":{"background-color":"#2e3a46"},"hover":{"background-color":"#818991"}}},"header_column":{"desktop":{"base":{"background-color":"#d3d8db"},"hover":[]}}}', '@websiteWidgets/text/templates/table.twig.css'); static::checkAndCreateWidgetPreset('text.table', 3, '{"table":{"desktop":{"base":{"border-style":"solid","border-left-width":"0px","border-top-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-radius":"0px","border-color":"#81868c"},"hover":[]}},"cell":{"desktop":{"base":{"border-style":"solid","border-left-width":"1px","border-right-width":"1px","border-bottom-width":"1px","border-top-width":"1px","border-radius":"0px","border-color":"#81868c"},"hover":[]}},"header_row":{"desktop":{"base":{"background-color":"#55616d"},"hover":[]}},"even_row":{"desktop":{"base":{"background-color":"#bec3c7"},"hover":{"background-color":"#2e3a46"}}},"odd_row":{"desktop":{"base":{"background-color":"#d3d8db"},"hover":{"background-color":"#2e3a46"}}},"row":{"desktop":{"base":{"background-color":"#d3d8db"},"hover":{"background-color":"#2e3a46"}}},"header_column":{"desktop":{"base":{"background-color":"#ffffff"},"hover":[]}}}', '@websiteWidgets/text/templates/table.twig.css'); } public static function updateTo_NEXT_Build() { $params = array(); if (method_exists('Moto\System', 'isDevelopmentStage') && Moto\System::isDevelopmentStage()) { $params['isDebug'] = true; } $params['type'] = 'header'; static::_compressContainers($params); $params['type'] = 'content'; static::_compressContainers($params); $params['type'] = 'footer'; static::_compressContainers($params); return true; } public static function startUpdateProductInformation() { $result = Moto\Authentication\AuthenticationService::getInstance()->syncProductInformation(); if ($result['status']) { Moto\System\Log::info('@UPDATE: Product Information updated'); } else { Moto\System\Log::warning('@UPDATE: Product Information not updated because [ ' . $result['error']['code'] . ' ' . $result['error']['message'] . ' ]'); } } public static function compressContainersStyles() { try { $table = new Moto\Application\Styles\StylesTable(); $table->useResultAsModel(false); $items = $table->select(array( 'type' => 'widget', new Zend\Db\Sql\Predicate\Like('class_name', 'moto-container_%') )); if ($items->count() > 0) { foreach ($items as $item) { $properties = $item->properties; $properties = json_decode($properties, true); $baseStyles = $properties['desktop']['base']; foreach ($baseStyles as $name => $value) { if (empty($value) || $value === 'transparent' || (($value === '0px' || $value === 'none') && preg_match('/^(margin|padding|border)-/', $name))) { unset($baseStyles[$name]); } elseif (($name === 'background-size' && $value === 'auto') || ($name === 'background-position' && $value === 'left top') || ($name === 'background-repeat' && $value === 'no-repeat') ) { unset($baseStyles[$name]); } } if (empty($baseStyles['border-style']) || $baseStyles['border-style'] === 'none') { unset($baseStyles['border-color']); unset($baseStyles['border-left-width'], $baseStyles['border-right-width'], $baseStyles['border-top-width'], $baseStyles['border-bottom-width']); } if (empty($baseStyles['background-image']) || $baseStyles['background-image'] === '') { unset($baseStyles['background-size'], $baseStyles['background-position'], $baseStyles['background-repeat']); } $properties['desktop']['base'] = $baseStyles; $item->properties = json_encode($properties); $table->save($item); } } } catch (\Exception $e) { return false; } return true; } public static function updateTo_150_Build() { Moto\System\Log::info('@UPDATE 150 : Start'); static::updateTo_utf8mb4_Build(); try { Moto\System\Log::info('@UPDATE 150: Check and create content_slider presets'); static::checkAndCreateContentSliderPresets(); } catch (\Exception $e) { throw new \Exception('CANT_UPGRADE'); } if (!Moto\Website\Settings::isExists('seo_robots_txt_settings')) { Moto\System\Log::info('@UPDATE 150: Add website.seo_robots_txt_settings'); Moto\Website\Settings::add('seo_robots_txt_settings', Moto\Website\RobotsTxtService::getSettings(), 'array'); } Moto\Website\Settings::loadData(true); Moto\System\Log::info('@UPDATE 150 : Done'); } public static function updateTo_230_Build() { Moto\System\Log::info('@UPDATE [230] : Start'); $paths = [ '@websiteBackupDir', '@websiteBackupTempDir', ]; foreach ($paths as $path) { $absolutePath = Moto\System::getAbsolutePath($path); if (empty($absolutePath)) { Moto\System\Log::emergency('@UPDATE [backup] : Directory ' . $path . ' is empty, check config'); throw new \Exception('CANT_UPGRADE'); } if (!Moto\Util::createNotWebIndexingDir($absolutePath)) { Moto\System\Log::emergency('@UPDATE [backup] : Cant create directory for "' . $path . '"'); throw new \Exception('CANT_UPGRADE'); } } Moto\System\Log::info('@UPDATE [230] : updateCategoryListPresetsForPostsCounter'); static::updateCategoryListPresetsForPostsCounter(); Moto\System\Log::info('@UPDATE [230] : end updateCategoryListPresetsForPostsCounter'); Moto\System\Log::info('@UPDATE [230] : Done'); } public static function updateTo_240_Build() { Moto\System\Log::info('@UPDATE [240] : Start'); Moto\System\Log::info('@UPDATE add is_favorites for ml folders : Start'); $prefix = static::_getTablePrefix(); $databaseAdapter = static::_getDatabaseAdapter(); try { $sql = "SHOW COLUMNS FROM `{$prefix}media_folders` WHERE `Field` = 'is_favorite'"; $isExists = $databaseAdapter->query($sql)->execute()->current(); if (!$isExists) { Moto\System\Log::info('@UPDATE : Try add "is_favorite" field for "media_folders"'); $sql = "ALTER TABLE `{$prefix}media_folders` ADD `is_favorite` TINYINT UNSIGNED NOT NULL DEFAULT '0' AFTER `parent_id`"; $databaseAdapter->query($sql)->execute(); } } catch (\Exception $e) { Moto\System\Log::critical('@UPDATE : DataBase : ' . $e->getMessage()); throw $e; } Moto\System\Log::info('@UPDATE add is_favorites for ml folders : End'); Moto\System\Log::info('@UPDATE [240] : Done'); } public static function updateTo_250_Build() { Moto\System\Log::info('@UPDATE [250] : Start'); Moto\System\Log::info('@UPDATE [250] : checkAndCreateTagListPresets'); static::checkAndCreateTagListPresets(); Moto\System\Log::info('@UPDATE [250] : end checkAndCreateTagListPresets'); Moto\System\Log::info('@UPDATE [250] : Done'); } public static function updateTo_260_Build() { Moto\System\Log::info('@UPDATE [260] : Start'); Moto\System\Log::info('@UPDATE [260] : updateCategoryListPresetsForPostsCounter'); static::updateCategoryListPresetsForPostsCounter(); Moto\System\Log::info('@UPDATE [260] : end updateCategoryListPresetsForPostsCounter'); Moto\System\Log::info('@UPDATE [260] : Done'); } public static function updateTo_280_Build() { Moto\System\Log::info('@UPDATE [280] : Start'); Moto\System\Log::info('@UPDATE [280] : checkAndCreateTablePresets'); static::checkAndCreateTablePresets(); Moto\System\Log::info('@UPDATE [280] : end checkAndCreateTablePresets'); Moto\System\Log::info('@UPDATE [280] : Done'); } public static function updateTo_290_Build() { Moto\System\Log::info('@UPDATE [290] : Start'); Moto\System\Log::info('@UPDATE [290] : fixTextListStylesPrefix'); static::fixTextListStylesPrefix(); Moto\System\Log::info('@UPDATE [290] : end fixTextListStylesPrefix'); Moto\System\Log::info('@UPDATE [290] : Done'); } public static function updateTo_310_Build() { Moto\System\Log::info('@UPDATE [310] : Start'); Moto\System\Log::info('@UPDATE [310] : updateDividerPresetsForDirections'); static::updateDividerPresetsForDirections(); Moto\System\Log::info('@UPDATE [310] : end updateDividerPresetsForDirections'); Moto\System\Log::info('@UPDATE [310] : Done'); } public static function updateTo_320_Build() { Moto\System\Log::info('@UPDATE [320] : Start'); Moto\System\Log::info('@UPDATE [320] : updateSliderPresetsForThumbnailPagination'); static::updateSliderPresetsForThumbnailPagination(); Moto\System\Log::info('@UPDATE [320] : end updateSliderPresetsForThumbnailPagination'); Moto\System\Log::info('@UPDATE [320] : Done'); } public static function updateTo_330_Build() { Moto\System\Log::info('@UPDATE [330] : Start'); Moto\System\Log::info('@UPDATE [330] : checkAndCreateAudioPlayerPreset'); static::checkAndCreateAudioPlayerPreset(); Moto\System\Log::info('@UPDATE [330] : end checkAndCreateAudioPlayerPreset'); Moto\System\Log::info('@UPDATE [330] : Done'); } public static function updateTo_340_Build() { Moto\System\Log::info('@UPDATE [340] : Start'); Moto\System\Log::info('@UPDATE [340] : checkAndCreateAudioPlayerPreset'); static::checkAndCreateAudioPlayerPreset(); Moto\System\Log::info('@UPDATE [340] : end checkAndCreateAudioPlayerPreset'); try { $prefix = static::_getTablePrefix(); $databaseAdapter = static::_getDatabaseAdapter(); Moto\System\Log::info('@UPDATE : Try add provider field for presets'); $sql = "SHOW COLUMNS FROM `{$prefix}presets` WHERE `Field` = 'provider'"; $isExists = $databaseAdapter->query($sql)->execute()->current(); if (!$isExists) { $sql = "ALTER TABLE `{$prefix}presets` ADD `provider` VARCHAR(12) NOT NULL DEFAULT 'default' AFTER `class_name`"; $databaseAdapter->query($sql)->execute(); } } catch (\Exception $e) { Moto\System\Log::critical('@UPDATE : DataBase : ' . $e->getMessage()); throw $e; } Moto\System\Log::info('@UPDATE [340] : Done'); } public static function updateTo_350_Build() { Moto\System\Log::info('@UPDATE [350] : Start update text styles'); Moto\Website\Theme::importTextStyles(Moto\Website\Settings::get('theme'), 'update'); if ((bool) Moto\Features::isEnabled('theme_customized_lists_styles')) { $options = [ 'properties' => [ 'desktop.base.^ul li&', 'desktop.base.^ol li&', 'tablet.base.^ul li&', 'tablet.base.^ol li&', 'mobile-h.base.^ul li&', 'mobile-h.base.^ol li&', 'mobile-v.base.^ul li&', 'mobile-v.base.^ol li&', ] ]; Moto\Website\Theme::updateTextStylesFromNormal($options); } Moto\System\Log::info('@UPDATE [350] : add hu_HU locale'); $language = Moto\Database\Models\Language::firstOrNew(['locale' => 'hu_HU']); if (!$language->exists) { $language->fill([ 'code' => 'hu', 'locale' => 'hu_HU', 'name' => 'Magyar Nyelv' ]); $language->save(); } Moto\System\Log::info('@UPDATE [350] : end add hu_HU locale'); Moto\System\Log::info('@UPDATE [350] : Done'); } public static function updateTo_380_Build() { Moto\System\Log::info('@UPDATE [380] : Start'); Moto\System\Log::info('@UPDATE [380] : checkAndCreateMotoCallbackPresets'); static::checkAndCreateMotoCallbackPresets(); Moto\System\Log::info('@UPDATE [380] : end checkAndCreateMotoCallbackPresets'); Moto\System\Log::info('@UPDATE [380] : Done'); } public static function updateTo_390_Build() { Moto\System\Log::info('@UPDATE [390] : Start'); Moto\System\Log::info('@UPDATE [390] : Update table `users` for add field preferences if need'); $prefix = static::_getTablePrefix(); $databaseAdapter = static::_getDatabaseAdapter(); try { $sql = "SHOW COLUMNS FROM `{$prefix}users` WHERE `Field` = 'preferences'"; $isExists = $databaseAdapter->query($sql)->execute()->current(); if (!$isExists) { $sql = "ALTER TABLE `{$prefix}users` ADD `preferences` LONGTEXT NULL DEFAULT NULL AFTER `enabled`"; $databaseAdapter->query($sql)->execute(); } } catch (\Exception $e) { Moto\System\Log::critical('@UPDATE : DataBase : ' . $e->getMessage()); throw $e; } try { $users = Moto\Database\Models\User::query()->get(); foreach ($users as $user) { if (empty($user->preferences)) { if (defined('Moto\Database\Models\User::DEFAULT_PREFERENCES_VALUE')) { $user->preferences = Moto\Database\Models\User::DEFAULT_PREFERENCES_VALUE; } else { $user->preferences = json_encode([ 'ui' => [ 'theme' => 'dark' ], ]); } } if (!$user->save()) { Moto\System\Log::critical('@UPDATE : Cant update user preferences for user : #' . $user->id); } } } catch (\Exception $e) { Moto\System\Log::critical('@UPDATE : Cant update user preferences : ' . $e->getMessage()); throw $e; } Moto\System\Log::info('@UPDATE [390] : Done'); } public static function updateTo_410_Build() { Moto\System\Log::info('@UPDATE [410] : Start'); Moto\System\Log::info('@UPDATE [410] : Create cache folders'); Moto\Util::createNotWebIndexingDir('@cacheDir'); Moto\Util::createNotWebIndexingDir('@cacheWebsitePageDir'); Moto\System\Log::info('@UPDATE [410] : Create cache folders'); $migration = new Moto\System\Task\Database\DatabaseMigration(); if ($migration->isNeedMigrate()) { Moto\System\Log::info('@UPDATE [410] : Update database for Task Manager'); $migration->update(); Moto\System\Log::info('@UPDATE [410] : Database updated'); } try { Moto\System\Log::info('@UPDATE [410] : Update chat provider configuration'); $sql = 'UPDATE `' . Moto\Config::get('database.prefix') . 'settings` SET `type` = "array" WHERE `name`="website.integration_live_chat"'; Moto\Config::get('databaseAdapter') ->query($sql) ->execute(); Moto\Website\Settings::loadData(true); } catch (\Exception $e) { Moto\System\Log::error('@UPDATE [410] : Exception : [' . $e->getCode() . '] ' . $e->getMessage()); throw $e; } Moto\System\Log::info('@UPDATE [410] : Done'); } public static function checkAndCreateBlogFiltersPresets() { static::checkAndCreateWidgetPreset('blog.filters', 1, '{"item_height":{"desktop":{"base":{"height":"38px"}}},"label":{"desktop":{"base":{"font-size":"12px","padding-left":"23px","padding-right":"23px","font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400"}}},"icon":{"desktop":{"base":{"font-size":"14px","margin-left":"8px"}}},"selected_indicator":{"desktop":{"base":{"font-size":"12px","font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400","margin-left":"8px","border-radius":"50px","padding-left":"4px","padding-right":"4px","padding-top":"1px","padding-bottom":"1px","border-style":"none","border-left-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-top-width":"0px"}}},"item_border":{"desktop":{"base":{"border-style":"solid","border-left-width":"1px","border-right-width":"1px","border-top-width":"1px","border-bottom-width":"1px","border-radius":"0px"}}},"content":{"desktop":{"base":{"max-height":"150px","padding-top":"0px","padding-right":"5px","padding-left":"5px","padding-bottom":"5px","background-color":"#fafafa"}}},"item_border_closed":{"desktop":{"base":{"border-color":"#d9d9d9"},"hover":{"border-color":""},"active":{"border-color":""}}},"icon_closed":{"desktop":{"base":{"color":"#777777"},"hover":{"color":""},"active":{"color":""}}},"label_closed":{"desktop":{"base":{"background-color":"#fafafa","color":"#777777"},"hover":{"color":"#3d3d3d","background-color":""},"active":{"color":"","background-color":""}}},"selected_indicator_closed":{"desktop":{"base":{"border-color":"#ffffff","background-color":"#919191","color":"#ffffff"}}},"item_border_opened":{"desktop":{"base":{"border-color":"#919191"},"hover":{"border-color":""},"active":{"border-color":""}}},"icon_opened":{"desktop":{"base":{"color":"#777777"},"hover":{"color":""},"active":{"color":""}}},"label_opened":{"desktop":{"base":{"background-color":"#fafafa","color":"#777777"},"hover":{"color":"#3d3d3d","background-color":""},"active":{"color":"","background-color":""}}},"selected_indicator_opened":{"desktop":{"base":{"color":"#ffffff","background-color":"#919191","border-color":"#ffffff"}}},"header_label":{"desktop":{"base":{"font-size":"12px","font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400","color":"#1f1f1f"}}},"header_icon":{"desktop":{"base":{"color":"#1f1f1f","font-size":"14px"}}}}', '@websiteWidgets/content_sections/templates/filters.twig.css'); static::checkAndCreateWidgetPreset('blog.filters', 2, '{"item_height":{"desktop":{"base":{"height":"38px"}}},"label":{"desktop":{"base":{"font-size":"12px","padding-left":"23px","padding-right":"23px","font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400"}}},"icon":{"desktop":{"base":{"font-size":"14px","margin-left":"8px"}}},"selected_indicator":{"desktop":{"base":{"font-size":"12px","font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400","margin-left":"8px","border-radius":"50px","padding-left":"4px","padding-right":"4px","padding-top":"1px","padding-bottom":"1px","border-style":"none","border-left-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-top-width":"0px"}}},"item_border":{"desktop":{"base":{"border-style":"solid","border-left-width":"1px","border-right-width":"1px","border-top-width":"1px","border-bottom-width":"1px","border-radius":"0px"}}},"content":{"desktop":{"base":{"max-height":"150px","padding-top":"0px","padding-right":"5px","padding-left":"5px","padding-bottom":"5px","background-color":"#10151b"}}},"item_border_closed":{"desktop":{"base":{"border-color":"#919191"},"hover":{"border-color":""},"active":{"border-color":"#d9d9d9"}}},"icon_closed":{"desktop":{"base":{"color":"#c2c2c2"},"hover":{"color":""},"active":{"color":""}}},"label_closed":{"desktop":{"base":{"background-color":"#10151b","color":"#c2c2c2"},"hover":{"color":"#ffffff","background-color":""},"active":{"color":"","background-color":""}}},"selected_indicator_closed":{"desktop":{"base":{"border-color":"#3d3d3d","background-color":"#fafafa","color":"#3d3d3d"}}},"item_border_opened":{"desktop":{"base":{"border-color":"#d9d9d9"},"hover":{"border-color":""},"active":{"border-color":""}}},"icon_opened":{"desktop":{"base":{"color":"#c2c2c2"},"hover":{"color":""},"active":{"color":""}}},"label_opened":{"desktop":{"base":{"background-color":"#10151b","color":"#c2c2c2"},"hover":{"color":"#ffffff","background-color":""},"active":{"color":"","background-color":""}}},"selected_indicator_opened":{"desktop":{"base":{"color":"#3d3d3d","background-color":"#fafafa","border-color":"#3d3d3d"}}},"header_label":{"desktop":{"base":{"font-size":"12px","font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400","color":"#c2c2c2"}}},"header_icon":{"desktop":{"base":{"color":"#fafafa","font-size":"14px"}}}}', '@websiteWidgets/content_sections/templates/filters.twig.css'); static::checkAndCreateWidgetPreset('blog.filters', 3, '{"item_height":{"desktop":{"base":{"height":"38px"}}},"label":{"desktop":{"base":{"font-size":"12px","padding-left":"23px","padding-right":"23px","font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400"}}},"icon":{"desktop":{"base":{"font-size":"14px","margin-left":"8px"}}},"selected_indicator":{"desktop":{"base":{"font-size":"12px","font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400","margin-left":"8px","border-radius":"4px","padding-left":"4px","padding-right":"4px","padding-top":"1px","padding-bottom":"1px","border-style":"none","border-left-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-top-width":"0px"}}},"item_border":{"desktop":{"base":{"border-style":"solid","border-left-width":"1px","border-right-width":"1px","border-top-width":"1px","border-bottom-width":"1px","border-radius":"8px"}}},"content":{"desktop":{"base":{"max-height":"150px","padding-top":"0px","padding-right":"5px","padding-left":"5px","padding-bottom":"5px","background-color":"#fafafa"}}},"item_border_closed":{"desktop":{"base":{"border-color":"#d9d9d9"},"hover":{"border-color":""},"active":{"border-color":""}}},"icon_closed":{"desktop":{"base":{"color":"#777777"},"hover":{"color":""},"active":{"color":""}}},"label_closed":{"desktop":{"base":{"background-color":"#fafafa","color":"#777777"},"hover":{"color":"#3d3d3d","background-color":""},"active":{"color":"","background-color":""}}},"selected_indicator_closed":{"desktop":{"base":{"border-color":"#ffffff","background-color":"#919191","color":"#ffffff"}}},"item_border_opened":{"desktop":{"base":{"border-color":"#919191"},"hover":{"border-color":""},"active":{"border-color":""}}},"icon_opened":{"desktop":{"base":{"color":"#777777"},"hover":{"color":""},"active":{"color":""}}},"label_opened":{"desktop":{"base":{"background-color":"#fafafa","color":"#777777"},"hover":{"color":"#3d3d3d","background-color":""},"active":{"color":"","background-color":""}}},"selected_indicator_opened":{"desktop":{"base":{"color":"#ffffff","background-color":"#919191","border-color":"#ffffff"}}},"header_label":{"desktop":{"base":{"font-size":"12px","font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400","color":"#1f1f1f"}}},"header_icon":{"desktop":{"base":{"color":"#1f1f1f","font-size":"14px"}}}}', '@websiteWidgets/content_sections/templates/filters.twig.css'); static::checkAndCreateWidgetPreset('blog.filters', 4, '{"item_height":{"desktop":{"base":{"height":"38px"}}},"label":{"desktop":{"base":{"font-size":"12px","padding-left":"23px","padding-right":"23px","font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400"}}},"icon":{"desktop":{"base":{"font-size":"14px","margin-left":"8px"}}},"selected_indicator":{"desktop":{"base":{"font-size":"12px","font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400","margin-left":"8px","border-radius":"4px","padding-left":"4px","padding-right":"4px","padding-top":"1px","padding-bottom":"1px","border-style":"none","border-left-width":"0px","border-right-width":"0px","border-bottom-width":"0px","border-top-width":"0px"}}},"item_border":{"desktop":{"base":{"border-style":"solid","border-left-width":"1px","border-right-width":"1px","border-top-width":"1px","border-bottom-width":"1px","border-radius":"8px"}}},"content":{"desktop":{"base":{"max-height":"150px","padding-top":"0px","padding-right":"5px","padding-left":"5px","padding-bottom":"5px","background-color":"#10151b"}}},"item_border_closed":{"desktop":{"base":{"border-color":"#919191"},"hover":{"border-color":""},"active":{"border-color":"#d9d9d9"}}},"icon_closed":{"desktop":{"base":{"color":"#c2c2c2"},"hover":{"color":""},"active":{"color":""}}},"label_closed":{"desktop":{"base":{"background-color":"#10151b","color":"#c2c2c2"},"hover":{"color":"#ffffff","background-color":""},"active":{"color":"","background-color":""}}},"selected_indicator_closed":{"desktop":{"base":{"border-color":"#3d3d3d","background-color":"#fafafa","color":"#3d3d3d"}}},"item_border_opened":{"desktop":{"base":{"border-color":"#d9d9d9"},"hover":{"border-color":""},"active":{"border-color":""}}},"icon_opened":{"desktop":{"base":{"color":"#c2c2c2"},"hover":{"color":""},"active":{"color":""}}},"label_opened":{"desktop":{"base":{"background-color":"#10151b","color":"#c2c2c2"},"hover":{"color":"#ffffff","background-color":""},"active":{"color":"","background-color":""}}},"selected_indicator_opened":{"desktop":{"base":{"color":"#3d3d3d","background-color":"#fafafa","border-color":"#3d3d3d"}}},"header_label":{"desktop":{"base":{"font-size":"12px","font-family":"tahoma, arial, helvetica, sans-serif","font-style":"normal","font-weight":"400","color":"#c2c2c2"}}},"header_icon":{"desktop":{"base":{"color":"#fafafa","font-size":"14px"}}}}', '@websiteWidgets/content_sections/templates/filters.twig.css'); } public static function migrateContentSectionSettings($settings) { if (is_object($settings) || is_array($settings)) { $settings = json_encode($settings); } if (is_string($settings)) { $settings = json_decode($settings, true); } if (!is_array($settings)) { return false; } if (!array_key_exists('definitions', $settings)) { $settings['definitions'] = []; } $settings['definitions'] = Moto\Util::arrayMerge([ 'index' => [ 'template' => (empty($settings['page_id']) ? null : (int) $settings['page_id']), ], 'post' => [ 'template' => (empty($settings['post_template_id']) ? null : (int) $settings['post_template_id']), ], ], $settings['definitions']); if (!array_key_exists('taxonomies', $settings)) { $settings['taxonomies'] = Arr::except($settings['definitions'], ['index', 'post']); } $settings['taxonomies'] = Moto\Util::arrayMerge([ 'tag' => [ 'classification' => 'taxonomy', 'name' => 'tag', 'nameInPlural' => 'tags', 'isSystem' => true, 'type' => 'many', 'template' => (empty($settings['tag_template_id']) ? null : (int) $settings['tag_template_id']), 'uri' => 'tag', 'texts' => [ 'name' => 'Tag', 'pluralName' => 'Tags', ], ], 'category' => [ 'classification' => 'taxonomy', 'name' => 'category', 'nameInPlural' => 'categories', 'isSystem' => true, 'type' => 'one', 'template' => (empty($settings['category_template_id']) ? null : (int) $settings['category_template_id']), 'uri' => 'category', 'texts' => [ 'name' => 'Category', 'pluralName' => 'Categories', ], ], ], $settings['taxonomies']); $settings['definitions'] = Arr::only($settings['definitions'], ['index', 'post']); foreach (['page_id', 'post_template_id', 'tag_template_id', 'category_template_id', 'category_template', 'tag_template', 'post_template'] as $property) { unset($settings[$property]); } if (!array_key_exists('__version', $settings)) { $settings['__version'] = 1; } return $settings; } public static function migrateBlogToContentSections() { $build = 'MBlog'; Moto\System\Log::info('@migrateBlogToContentSections : Start'); $options = Moto\Website\Settings::get('content_section_blog'); if (!empty($options)) { Moto\System\Log::info('@migrateBlogToContentSections : Migrate blog settings from : ' . json_encode($options)); $manager = Moto\System::app(Moto\System\ContentSection\ContentSectionManager::class); $provider = $manager->getProvider('blog'); $options = static::migrateContentSectionSettings($options); $provider->setProperties($options); $provider->transformRawProperties(function ($options) { foreach (['page_id', 'post_template_id', 'tag_template_id', 'category_template_id', 'category_template', 'tag_template', 'post_template'] as $property) { unset($options[$property]); } return $options; }); $manager->saveConfiguration(); $sql = 'UPDATE `' . Moto\Config::get('database.prefix') . 'settings` SET `name` = "upgraded-' . $build . '.content_section_blog" WHERE `name`="website.content_section_blog"'; Moto\Config::get('databaseAdapter') ->query($sql) ->execute(); Moto\Website\Settings::loadData(true); } Moto\Website\SitemapService::addContentPreference('blog.taxonomy', [ 'label' => 'MODULE.BLOG.SITEMAP.TAXONOMY_LABEL', 'priority' => '0.5', 'frequency' => null, 'owner' => 'module:blog', ]); Moto\Website\Settings::loadData(true); try { Moto\System\Log::info('@migrateBlogToContentSections : Change presets blogs\'s template path'); Moto\Database\Models\Preset::query() ->where('widget_name', '=', 'blog.category_list') ->where('template', '=', '@websiteWidgets/blog/templates/category_list.twig.css') ->update([ 'template' => '@websiteWidgets/content_sections/templates/taxonomy_list/one.twig.css', ]); Moto\Database\Models\Preset::query() ->where('widget_name', '=', 'blog.post_tags') ->where('template', '=', '@websiteWidgets/blog/templates/post_tags.twig.css') ->update([ 'template' => '@websiteWidgets/content_sections/templates/record_taxonomy/many.twig.css', ]); } catch (\Exception $e) { Moto\System\Log::critical('@migrateBlogToContentSections : DataBaseException : ' . $e->getMessage()); throw $e; } Moto\System\Log::info('@migrateBlogToContentSections : Done'); } public static function updateTo_430_Build($migrateKey = true) { $build = 430; Moto\System\Log::info('@UPDATE [' . $build . '] : Start'); Moto\System\Log::info('@UPDATE [' . $build . '] : migrate blog to content sections'); static::migrateBlogToContentSections($migrateKey); Moto\System\Log::info('@UPDATE [' . $build . '] : checkAndCreateBlogFiltersPresets'); static::checkAndCreateBlogFiltersPresets(); Moto\System\Log::info('@UPDATE [' . $build . '] : end checkAndCreateBlogFiltersPresets'); try { $prefix = static::_getTablePrefix(); $databaseAdapter = static::_getDatabaseAdapter(); Moto\System\Log::info('@UPDATE [' . $build . '] : Try to change field type of `pages`.`type` to VARCHAR(48)'); $databaseAdapter ->query("ALTER TABLE `{$prefix}pages` CHANGE `type` `type` VARCHAR(48) NOT NULL DEFAULT 'page'") ->execute(); Moto\System\Log::info('@UPDATE [' . $build . '] : Try to change field type of `content_taxonomies`.`type` to VARCHAR(48)'); $databaseAdapter ->query("ALTER TABLE `{$prefix}content_taxonomies` CHANGE `type` `type` VARCHAR(48) NOT NULL DEFAULT ''") ->execute(); Moto\System\Log::info('@UPDATE [' . $build . '] : Try to change field type of `menu_items`.`action` to VARCHAR(64)'); $databaseAdapter ->query("ALTER TABLE `{$prefix}menu_items` CHANGE `action` `action` VARCHAR(64) NOT NULL DEFAULT ''") ->execute(); } catch (\Exception $e) { Moto\System\Log::critical('@UPDATE : DataBase : ' . $e->getMessage()); throw $e; } Moto\System\Log::info('@UPDATE [' . $build . '] : Done'); } public static function updateTo_utf8mb4_Build() { Moto\System\Log::info('@UPDATE utf8mb4 : Start'); if (!Moto\Database\Util::isSupportsCharset(Moto\Database\Provider::DEFAULT_CHARSET)) { throw new \Exception('CHARSET_NOT_SUPPORTS'); } $db = Moto\Database\Provider::getDatabaseCapsule(); $prefix = Moto\Database\Provider::getTablePrefix(); $connection = $db->getConnection(); Moto\System\Log::info('@UPDATE utf8mb4 : Upgrade tables index'); if (Moto\Database\Util::tableHasIndex('content_blocks', 'name')) { $connection->statement('ALTER TABLE `' . $prefix . 'content_blocks` DROP INDEX `name`;'); $connection->statement('ALTER TABLE `' . $prefix . 'content_blocks` ADD UNIQUE `name__type` (`name` (191),`type`);'); } if (Moto\Database\Util::tableHasIndex('menus', 'name')) { $connection->statement('ALTER TABLE `' . $prefix . 'menus` DROP INDEX `name`;'); $connection->statement('ALTER TABLE `' . $prefix . 'menus` ADD UNIQUE `name` (`name` (191));'); } if (Moto\Database\Util::tableHasIndex('pages', 'url')) { $connection->statement('ALTER TABLE `' . $prefix . 'pages` DROP INDEX `url`;'); $connection->statement('ALTER TABLE `' . $prefix . 'pages` ADD UNIQUE `url__parent` (`url` (191), `parent_id`);'); } if (Moto\Database\Util::tableHasIndex('styles', 'name')) { $connection->statement('ALTER TABLE `' . $prefix . 'styles` DROP INDEX `name`;'); $connection->statement('ALTER TABLE `' . $prefix . 'styles` ADD UNIQUE `name__type` (`name` (191),`type`);'); } if (Moto\Database\Util::tableHasIndex('styles', 'class_name')) { $connection->statement('ALTER TABLE `' . $prefix . 'styles` DROP INDEX `class_name`;'); $connection->statement('ALTER TABLE `' . $prefix . 'styles` ADD UNIQUE `class_name` (`class_name` (191));'); } if (Moto\Database\Util::tableHasIndex('presets', 'name')) { $connection->statement('ALTER TABLE `' . $prefix . 'presets` DROP INDEX `name`;'); $connection->statement('ALTER TABLE `' . $prefix . 'presets` ADD UNIQUE `name__widget_name` (`name` (191),`widget_name`);'); } if (Moto\Database\Util::tableHasIndex('presets', 'class_name')) { $connection->statement('ALTER TABLE `' . $prefix . 'presets` DROP INDEX `class_name`;'); $connection->statement('ALTER TABLE `' . $prefix . 'presets` ADD UNIQUE `class_name__widget_name` (`class_name` (191),`widget_name`);'); } Moto\System\Log::info('@UPDATE Database : setup default CHARACTER "utf8mb4"'); if (static::upgradeDatabaseTableCharsetToDefault()) { Moto\System\Log::info('@UPDATE Database : All tables converted'); } else { Moto\System\Log::critical('@UPDATE Database : Converting failed'); throw new \Exception('CANT_UPGRADE'); } Moto\System\Log::info('@UPDATE utf8mb4 : End'); return true; } public static function fixTextListStylePrefix($item) { if (!is_object($item)) { return false; } if (!property_exists($item, 'properties')) { return false; } $properties = $item->properties; $propertiesAsString = is_string($properties); if (!$propertiesAsString) { $properties = json_encode($properties); } if ((strpos($properties, '^.moto-widget-text ul li&') === false) && (strpos($properties, '^.moto-widget-text ol li&') === false)) { return false; } $searchStrings = ['^.moto-widget-text ul li&', '^.moto-widget-text ol li&']; $replaceStrings = ['^ul li&', '^ol li&']; $properties = str_replace($searchStrings, $replaceStrings, $properties); if ($propertiesAsString) { $item->properties = $properties; } else { $item->properties = json_decode($properties, is_array($item->properties)); } return true; } public static function fixTextListStylesPrefix() { $table = new Moto\Application\Styles\StylesTable(); $table->useResultAsModel(false); $items = $table->select(array( 'type' => 'text', )); if ($items->count() < 1) { return; } foreach ($items as $item) { Moto\System\Log::info('fixTextListStylesPrefix [checking]: ' . $item->name); if (static::fixTextListStylePrefix($item)) { Moto\System\Log::info('fixTextListStylesPrefix [fixing]: ' . $item->name); $table->save($item); Moto\System\Log::info('fixTextListStylesPrefix [fixed]: ' . $item->name); } } } public static function upgradeDatabaseTableCollate() { $tables = [ 'content_blocks', 'fonts', 'languages', 'media_folders', 'media_items', 'menus', 'menu_items', 'pages', 'pages_treepath', 'roles', 'settings', 'styles', 'users', 'presets', ]; $prefix = static::_getTablePrefix(); $databaseAdapter = static::_getDatabaseAdapter(); Moto\System\Log::info('@UPDATE Database : setup default CHARACTER "utf8" and COLLATE "utf8_unicode_ci"'); foreach ($tables as $tableName) { try { $isTableNeedUpdate = true; $sql = 'SHOW FULL COLUMNS FROM `' . $prefix . $tableName . '`;'; $records = $databaseAdapter->query($sql)->execute(); foreach ($records as $record) { $collation = strtolower(trim($record['Collation'])); if ($collation === '') { continue; } if ($collation !== 'utf8_general_ci') { $isTableNeedUpdate = false; break; } } if (!$isTableNeedUpdate) { Moto\System\Log::debug('@UPDATE Database : Table "' . $tableName . '" already updated'); continue; } $sql = 'ALTER TABLE `' . $prefix . $tableName . '` CONVERT TO CHARACTER SET utf8 COLLATE utf8_unicode_ci;'; $databaseAdapter->query($sql)->execute(); } catch (\Exception $e) { Moto\System\Log::critical('@UPDATE Database : Error : ' . $e->getMessage()); throw $e; } } } public static function upgradeDatabaseTableCharsetToDefault($logging = false) { $tables = [ 'content_blocks', 'content_taxonomies', 'content_taxonomy_relations', 'fonts', 'languages', 'media_folders', 'media_items', 'menus', 'menu_items', 'pages', 'pages_treepath', 'roles', 'settings', 'styles', 'users', 'presets', ]; foreach ($tables as $tableName) { try { $tableTimestamp = microtime(1); if (!Moto\Database\Util::convertTableCharsetToDefault($tableName)) { return false; } if ($logging) { Moto\System\Log::debug('@UPDATE Database : Table "' . $tableName . '" converted after time ' . (microtime(1) - $tableTimestamp)); } } catch (\Exception $e) { if ($logging) { Moto\System\Log::critical('@UPDATE Database : Error : ' . $e->getMessage()); } throw $e; } } return true; } } 