<?php

if (!defined ('MOTOSTORE_ROOT_DIR'))
{
    define ('MOTOSTORE_ROOT_DIR', realpath (__DIR__));
}

if (!class_exists(Moto\System\AutoloadManager::class)) {
    require_once MOTOSTORE_ROOT_DIR . '/vendor/autoload.php';
}

class StorePluginConnector extends Moto\System\PluginConnector
{
    CONST PLUGIN_NAME = 'moto-store-plugin';
    protected $_languages = array('en_US', 'ru_RU', 'de_DE');

    protected $_backupProvider = [
        'class' => Moto\System\Plugins\BaseBackupProvider::class,
        'parameters' => [
            'attributes'=> [
                'tables' => [
                    'store_brand',
                    'store_category',
                    'store_category_brand_relation',
                    'store_category_locale',
                    'store_category_property_relation',
                    'store_category_relation',
                    'store_country',
                    'store_currency',
                    'store_customer',
                    'store_discount',
                    'store_mail_template',
                    'store_option',
                    'store_order',
                    'store_order_comment',
                    'store_order_product',
                    'store_order_transaction',
                    'store_product',
                    'store_product_custom_option',
                    'store_product_locale',
                    'store_product_media',
                    'store_product_option',
                    'store_product_option_value',
                    'store_product_property',
                    'store_product_property_relation',
                    'store_product_property_value',
                    'store_product_related',
                    'store_product_tier_price',
                    'store_product_variant',
                    'store_product_variant_option',
                    'store_state',
                    'store_tax_class',
                    'store_tax_rate',
                    'store_tax_region',
                    'store_tax_zone',
                ],
            ],
        ],
    ];

    public function compatibleApiVersions()
    {
        return [1];
    }

    public function hasVendors()
    {
        return true;
    }

    public function bootstrap()
    {
        if (Moto\System::isInstallEngine()) {
            return;
        }

        if (!defined ('MOTOSTORE_ROOT_DIR'))
        {
            define ('MOTOSTORE_ROOT_DIR', realpath (__DIR__));
        }

        if (!defined ('MOTOSTORE_FOLDER_NAME'))
        {
            define ('MOTOSTORE_FOLDER_NAME', basename(__DIR__));
        }


        if (!defined ('MOTOSTORE_EXTENTIONS_DIR')) {
            define('MOTOSTORE_EXTENTIONS_DIR', realpath(__DIR__) . '/extensions/');

        }

        Moto\Hook::on('MOTOSTORE_HOOK_PLUGINS_CAN_INIT',function(){

            $serviceManager =  MotoStore\Content\Content\DI\SMStatic::getInstance();
            $extensionsService = new MotoStore\Settings\Service\ExtensionsServiceClass($serviceManager);
            $activeExtensions = $extensionsService->getActivePlugins();
            if (is_array($activeExtensions)){
                foreach ($activeExtensions as $extension){
                    include_once MOTOSTORE_EXTENTIONS_DIR . $extension .'/init.php';
                }
            }
        });

        if (defined('Moto\Hook::HOME_PAGE_SERVICE_BOOTSTRAPPED')) {
            Moto\Hook::on(Moto\Hook::HOME_PAGE_SERVICE_BOOTSTRAPPED, function ($event, $service) {
                /**
                 * @var Moto\Website\HomePageService $service
                 */
                if ($service){
                    $service->addProvider('store', [
                        'label' => 'STORE.TITLE',
                        'class' => MotoStore\Content\Application\StoreApplication::class,
                    ]);
                }

            });
        }

        MotoStore\Platform\Application::run(require MOTOSTORE_ROOT_DIR . '/src/config/store.global.php');

        Moto\Hook::trigger('MOTOSTORE_HOOK_PLUGINS_CAN_INIT');

        $this->_connectWidgets();
        $this->_otherHooks();
        $this->_connectAssets();


    }

    protected function _connectWidgets()
    {

        Moto\Hook::on ('application.plugins', function ($event, $value) {
            $value[] = 'store';
            $value[] = 'application.widget.store.widget';
            $value[] = 'application.widget.store.cart_and_profile';
            $value[] = 'application.widget.store.category_name';
            $value[] = 'application.widget.store.category_image';
            $value[] = 'application.widget.store.category_tree';
            $value[] = 'application.widget.store.filters';
            $value[] = 'application.widget.store.category_description';
            $value[] = 'application.widget.store.category_short_description';
            $value[] = 'application.widget.store.product_grid';
            $value[] = 'application.widget.store.product_grid_custom';
            $value[] = 'application.widget.store.product_options';
            $value[] = 'application.widget.store.product_custom_options';
            $value[] = 'application.widget.store.breadcrumbs';
            $value[] = 'application.widget.store.product_name';
            $value[] = 'application.widget.store.product_price';
            $value[] = 'application.widget.store.product_tax';
            $value[] = 'application.widget.store.product_quantity';
            $value[] = 'application.widget.store.product_add_to_cart';
            $value[] = 'application.widget.store.product_add_to_compare';
            $value[] = 'application.widget.store.product_add_to_wishlist';
            $value[] = 'application.widget.store.product_short_description';
            $value[] = 'application.widget.store.product_description';
            $value[] = 'application.widget.store.product_embed';
            $value[] = 'application.widget.store.product_media_gallery';
            $value[] = 'application.widget.store.product_rating';
            $value[] = 'application.widget.store.product_reviews';
            $value[] = 'application.widget.store.product_properties';
            $value[] = 'application.widget.store.product_related_products';
            $value[] = 'application.widget.store.product_video';
            $value[] = 'application.widget.store.store_search';
            $value[] = 'application.widget.store.store_account';
            $value[] = 'application.widget.store.store_cart';
            $value[] = 'application.widget.store.store_compare';
            $value[] = 'application.widget.store.store_wishlist';
            $value[] = 'application.widget.store.working_hours';
            $value[] = 'application.widget.store.store_checkout';
            $value[] = 'application.widget.store.store_authorization';
            $value[] = 'application.widget.store.store_registration';
            $value[] = 'application.widget.store.store_forgot';

            return $value;
        });
    }

    protected function _otherHooks()
    {

        Moto\Hook::on ('website.plugins', function ($event, $value) {
            $value[] = 'StoreWebsite';

            return $value;
        });


        if(defined('Moto\Hook::SITEMAP_EXTERNAL_SITEMAPS_LIST')){
            Moto\Hook::on(Moto\Hook::SITEMAP_EXTERNAL_SITEMAPS_LIST, function($event, $value){
                return MotoStore\Content\Helper\Sitemap::generateSitemaps();
            });
        };

        if(defined('Moto\Hook::MEDIA_LIBRARY_ITEM_DELETING')){
            Moto\Hook::on(Moto\Hook::MEDIA_LIBRARY_ITEM_DELETING, function($event, $item){
                return MotoStore\Content\Helper\MediaHelper::isMediaItemInUse($item);

            });
        };

    }

    protected function _connectAssets()
    {

        Moto\Hook::on ('render.admin.head.top', function ($event, $value) {
            $value .= '<link href="' . Moto\System::getRelativeUrl ('@plugins/moto-store-plugin/app/dist/compiled-store.min.css?v='.MotoStore\Platform\Application::CURRENT_BUILD)  . '" rel="stylesheet" type="text/css">';
            $value .= '<script src="' . Moto\System::getRelativeUrl ('@plugins/moto-store-plugin/app/vendor/highchart/highcharts.js') . '" type="text/javascript"></script>';


            if (version_compare (Moto\System\Settings::get('version'), '3.0.19') == -1)
            {
                $mainScript = '@plugins/moto-store-plugin/src/public/assets/js/source-store.min-3.0.18.js';
            }
            else
            {
                $mainScript = '@plugins/moto-store-plugin/app/dist/source-store.min.js?v='.  MotoStore\Platform\Application::CURRENT_BUILD;
            }

            $value .= '<script src="' . Moto\System::getRelativeUrl ($mainScript) . '" type="text/javascript" data-cfasync="false"></script>';


            return $value;
        });

        Moto\Hook::on ('website_head_bottom', function ($event, $value) {
            $value .= '<link href="'. Moto\System::getRelativeUrl ('@plugins/moto-store-plugin/src/public/assets/css/main.css?v='.MotoStore\Platform\Application::CURRENT_BUILD) . '" rel="stylesheet" type="text/css" />';

            return $value;
        });

        Moto\Hook::on ('website_body_bottom', function ($event, $value) {
            if(Moto\System\Request::getQuery('mode') == 'preview'){
                $value .= '<link href="'. Moto\System::getRelativeUrl ('@plugins/moto-store-plugin/app/widgets/store_cart_and_profile/css/helpers.css') . '" rel="stylesheet" type="text/css" />';
                $value .= '<link href="'. Moto\System::getRelativeUrl ('@plugins/moto-store-plugin/app/widgets/store_product/css/helpers.css') . '" rel="stylesheet" type="text/css" />';
                $value .= '<link href="'. Moto\System::getRelativeUrl ('@plugins/moto-store-plugin/app/widgets/store_breadcrumbs/css/helpers.css') . '" rel="stylesheet" type="text/css" />';
                $value .= '<link href="'. Moto\System::getRelativeUrl ('@plugins/moto-store-plugin/app/widgets/store_category_tree/css/helpers.css') . '" rel="stylesheet" type="text/css" />';
                $value .= '<link href="'. Moto\System::getRelativeUrl ('@plugins/moto-store-plugin/app/widgets/store_category/css/helpers.css') . '" rel="stylesheet" type="text/css" />';
                $value .= '<link href="'. Moto\System::getRelativeUrl ('@plugins/moto-store-plugin/app/widgets/store_product_grid/css/helpers.css') . '" rel="stylesheet" type="text/css" />';
                $value .= '<link href="'. Moto\System::getRelativeUrl ('@plugins/moto-store-plugin/app/widgets/store_product_grid_custom/css/helpers.css') . '" rel="stylesheet" type="text/css" />';
                $value .= '<link href="'. Moto\System::getRelativeUrl ('@plugins/moto-store-plugin/app/widgets/store_search/css/helpers.css') . '" rel="stylesheet" type="text/css" />';
                $value .= '<link href="'. Moto\System::getRelativeUrl ('@plugins/moto-store-plugin/app/widgets/store_account/css/helpers.css') . '" rel="stylesheet" type="text/css" />';
                $value .= '<link href="'. Moto\System::getRelativeUrl ('@plugins/moto-store-plugin/app/widgets/store_cart/css/helpers.css') . '" rel="stylesheet" type="text/css" />';
                $value .= '<link href="'. Moto\System::getRelativeUrl ('@plugins/moto-store-plugin/app/widgets/store_compare/css/helpers.css') . '" rel="stylesheet" type="text/css" />';
                $value .= '<link href="'. Moto\System::getRelativeUrl ('@plugins/moto-store-plugin/app/widgets/store_checkout/css/helpers.css') . '" rel="stylesheet" type="text/css" />';
                $value .= '<link href="'. Moto\System::getRelativeUrl ('@plugins/moto-store-plugin/app/widgets/store_authorization/css/helpers.css') . '" rel="stylesheet" type="text/css" />';
                $value .= '<link href="'. Moto\System::getRelativeUrl ('@plugins/moto-store-plugin/app/widgets/store_registration/css/helpers.css') . '" rel="stylesheet" type="text/css" />';
                $value .= '<link href="'. Moto\System::getRelativeUrl ('@plugins/moto-store-plugin/app/widgets/store_forgot/css/helpers.css') . '" rel="stylesheet" type="text/css" />';
            }

            $value .= '<script src="' . Moto\System::getRelativeUrl ('@plugins/moto-store-plugin/src/public/assets/js/moto.store.site.min.js') . '" type="text/javascript"  data-cfasync="false"></script>';

            return $value;
        });

    }
    public function onUpdateFinished (){
        return true;
    }
}
