/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

'use strict';

angular.module('application.widget.store.store_account', ['application.core'])
    .run(['coreLibraryWidget', 'core.library.editor.WidgetsService',
        function (WidgetFactory, WidgetsService) {
            var AbstractWidgetClass = WidgetFactory.get('AbstractWidgetClass');

            function classWidget() {
                this.properties = {
                    spacing: {
                        top: 'auto',
                        right: 'auto',
                        bottom: 'auto',
                        left: 'auto'
                    },
                    heading_text : 'Account',
                    item_name_text:'Item',
                    item_price_text:'Price',
                    item_quantity_text:'Quantity',
                    item_total_text:'Total',
                    email_placeholder: 'E-mail',
                    password_placeholder: 'Password',
                    new_password_placeholder: 'New Password',
                    confirm_new_password_placeholder: 'Confirm New Password',
                    billing_details: 'Billing Details',
                    shipping_details: 'Shipping Details',
                    first_name_placeholder: 'First Name',
                    last_name_placeholder: 'Last Name',
                    address1_placeholder: 'Adress 1',
                    address2_placeholder: 'Adress 2',
                    city_placeholder: 'City',
                    country_placeholder: 'Country',
                    state_placeholder: 'State',
                    phone_placeholder: 'Phone',
                    company_placeholder: 'Company Name',
                    zip_placeholder: 'Post Code',
                    subtotal_text:'Subtotal',
                    total_text:'Total',
                    shipping_price_text:'Shipping Price',
                    discount_text:'Discount',
                    shipping_discount_text:'Shipping Discount',
                    tax_text : 'Tax',
                    my_orders_btn : 'My Orders',
                    back_to_shop_btn : 'Back To Shop',
                    edit_btn : 'Edit details',
                    orders_per_page : 'Orders Per Page',
                    order : 'Order',
                    no_orders_text : 'There are no orders in your account',
                    personal_details : 'Personal details',
                    address_details : 'Address details',
                    save_btn : 'Save',
                };
                AbstractWidgetClass.apply(this, arguments);
            }

            classWidget.prototype = Object.create(AbstractWidgetClass.prototype);
            classWidget.prototype.constructor = classWidget;
            classWidget.prototype.name = 'store_account';
            classWidget.prototype.label = 'EDITOR.WIDGETS.STORE_ACCOUNT.NAME';
            classWidget.prototype.template_view_url = '@plugins/moto-store-plugin/app/widgets/store_account/views/properties.tpl.html';
            classWidget.prototype._apiVersion = 2;
            classWidget.prototype._transformToMacros = true;
            classWidget.prototype._template = {
                engine: 'nunjucks',
                path: '@plugins/moto-store-plugin/app/widgets/store_account/presets/default/template.front.twig'
            };

            classWidget.prototype.isCopyable = function() {
                return false;
            };

            classWidget.prototype.shouldUpdateContentView = function() {
                return true;
            };

            classWidget.prototype.isRemovable = function() {
                return false;
            };

            WidgetFactory.set('store_account', classWidget);

            WidgetsService.addWidget({
                name: 'store_account',
                label: 'EDITOR.WIDGETS.STORE_ACCOUNT.NAME',
                category: 'store',
                order: 10,
                enabled: false,
                allowed: function(page, sectionName) {
                    return (page.type == "template.store.product" && sectionName == "content");
                },
                icons: {
                    small: 'icon icon-blog-post_content',
                    medium: '',
                    large: 'icon icon-blog-post_content'
                }
            });
        }
    ]);
