<?php
namespace Website\Widgets\StoreAuthorization;

use Moto;
use MotoStore\Content\Controller\AuthController;

class Widget extends Moto\System\Widgets\AbstractWidget
{
    /**
     * @var string
     */
    protected $_name = 'store_authorization';
    protected $_widgetId = true;
    protected $_defaultOptions = array(
        'spacing' => array(
            'top' => 'auto',
            'left' => 'auto',
            'right' => 'auto',
            'bottom' => 'auto'
        )
    );
    public function getRenderVariables()
    {
        $controller = new AuthController ();

        return array (
            'currentWidget' => $this,
            'authorizationPageContent' => $controller->renderAuthForm($this)
        );

    }


    /**
     * @param string $preset
     * @return string
     */
    public function getTemplatePath ($preset = 'default')
    {
        $template = '@plugins/moto-store-plugin/app/widgets/' . $this->_name . '/presets/' . $preset . '/template.html.twig';
        return $template;
    }
}