/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

'use strict';


angular.module('application.widget.store.store_authorization', ['application.core'])
    .run(['coreLibraryWidget', 'core.library.editor.WidgetsService','$translate',
        function (WidgetFactory, WidgetsService, $translate) {
            var AbstractWidgetClass = WidgetFactory.get('AbstractWidgetClass');
            function Controller($scope, $translate)
            {

                var widget = $scope.currentWidget;


            }
            Controller.$inject = ['$scope', '$translate'];

            function classWidget() {
                this.properties = {
                    spacing: {
                        top: 'auto',
                        right: 'auto',
                        bottom: 'auto',
                        left: 'auto'
                    }
                };
                AbstractWidgetClass.apply(this, arguments);
            }

            classWidget.prototype = Object.create(AbstractWidgetClass.prototype);
            classWidget.prototype.constructor = classWidget;
            classWidget.prototype.name = 'store_authorization';
            classWidget.prototype.label = 'EDITOR.WIDGETS.STORE_AUTHORIZATION.NAME';
            classWidget.prototype.template_view_url = '@plugins/moto-store-plugin/app/widgets/store_authorization/views/properties.tpl.html';
            classWidget.prototype._apiVersion = 2;
            classWidget.prototype._transformToMacros = true;
            classWidget.prototype.controller = Controller;
            classWidget.prototype._template = {
                engine: 'nunjucks',
                path: '@plugins/moto-store-plugin/app/widgets/store_authorization/presets/default/template.front.twig'
            };

            classWidget.prototype.isCopyable = function() {
                return false;
            };

            classWidget.prototype.shouldUpdateContentView = function() {
                return true;
            };

            classWidget.prototype.isRemovable = function() {
                return false;
            };

            WidgetFactory.set('store_authorization', classWidget);

            WidgetsService.addWidget({
                name: 'store_authorization',
                label: 'EDITOR.WIDGETS.STORE_AUTHORIZATION.NAME',
                category: 'store',
                order: 10,
                enabled: false,
                allowed: function(page, sectionName) {
                    return (page.type == "template.store.login" && sectionName == "content");
                },
                icons: {
                    small: 'icon icon-blog-post_content',
                    medium: '',
                    large: 'icon icon-blog-post_content'
                }
            });
        }
    ]);
