<?php
namespace Website\Widgets\StoreCart;

use Moto;
use MotoStore\Content\Content\DI\SMStatic;
use MotoStore\Content\Controller\AccountController;
use MotoStore\Content\Controller\CartController;

class Widget extends Moto\System\Widgets\AbstractWidget
{
    /**
     * @var string
     */
    protected $_name = 'store_cart';
    protected $_widgetId = true;
    protected $_defaultOptions = array(
        'spacing' => array(
            'top' => 'auto',
            'left' => 'auto',
            'right' => 'auto',
            'bottom' => 'auto'
        )
    );

    public function getRenderVariables()
    {
        $controller = new CartController ();

        return array (
            'currentWidget' => $this,
            'cartPageContent' => $controller->cart ($this)
        );

    }


    /**
     * @param string $preset
     * @return string
     */
    public function getTemplatePath ($preset = 'default')
    {
        $template = '@plugins/moto-store-plugin/app/widgets/' . $this->_name . '/presets/' . $preset . '/template.html.twig';
        return $template;
    }
}