/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

'use strict';

angular.module('application.widget.store.store_cart', ['application.core'])
    .run(['coreLibraryWidget', 'core.library.editor.WidgetsService', 'store.settings.services.SettingsService',
        function (WidgetFactory, WidgetsService,SettingsService) {
            var AbstractWidgetClass = WidgetFactory.get('AbstractWidgetClass');



            function classWidget() {

                var self = this;
                this.properties = {
                    spacing: {
                        top: 'auto',
                        right: 'auto',
                        bottom: 'auto',
                        left: 'auto'
                    },
                    heading_text: 'Shopping Cart',
                    empty_text: 'Cart is empty',
                    continue_text:'Continue shopping',
                    store_is_closed_text:'Store is closed',
                    item_name_text:'Item',
                    item_price_text:'Price',
                    item_quantity_text:'Quantity',
                    item_total_text:'Total',
                    item_remove_text:'Remove',
                    shipping_method_text:'Shipping Method',
                    comment_text:'Comment',
                    discount_code:'Discount Code',
                    button_back:'Back To Shop',
                    button_checkout:'Checkout',
                    subtotal_text:'Subtotal',
                    total_text:'Total',
                    shipping_price_text:'Shipping Price',
                    discount_text:'Discount',
                    shipping_discount_text:'Shipping Discount',
                    tax_text:'Tax',
                    discount_apply:'APPLY',
                };
                AbstractWidgetClass.apply(this, arguments);

            }

            classWidget.prototype = Object.create(AbstractWidgetClass.prototype);
            classWidget.prototype.constructor = classWidget;
            classWidget.prototype.name = 'store_cart';
            classWidget.prototype.label = 'EDITOR.WIDGETS.STORE_CART.NAME';
            classWidget.prototype._apiVersion = 2;
            classWidget.prototype.template_view_url = '@plugins/moto-store-plugin/app/widgets/store_cart/views/properties.tpl.html';
            classWidget.prototype._transformToMacros = true;

            classWidget.prototype._template = {
                engine: 'nunjucks',
                path: '@plugins/moto-store-plugin/app/widgets/store_cart/presets/default/template.front.twig'
            };

            classWidget.prototype.isCopyable = function() {
                return false;
            };

            classWidget.prototype.shouldUpdateContentView = function() {
                return true;
            };

            classWidget.prototype.isRemovable = function() {
                return false;
            };

            WidgetFactory.set(classWidget.prototype.name, classWidget);

            WidgetsService.addWidget({
                name: 'store_cart',
                label: 'EDITOR.WIDGETS.STORE_CART.NAME',
                category: 'store',
                order: 10,
                enabled: false,
                allowed: function(page, sectionName) {
                    return (page.type == "template.store.product" && sectionName == "content");
                },
                icons: {
                    small: 'icon icon-blog-post_content',
                    medium: '',
                    large: 'icon icon-blog-post_content'
                }
            });
        }
]);
