<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace Website\Widgets\StoreCategoryName;

use Moto;
use MotoStore\Content\Helper\Link;
use MotoStore\Product\Entity\Product;
use Website\Widgets\StoreCategory\CategoryWidgetAbstract;

class Widget extends CategoryWidgetAbstract
{
    /**
     * @var string
     */
    protected $_name = 'store_category_name';
    protected $_widgetId = true;
    protected $_defaultOptions = array(
        'preset' => 'default',
        'align' =>  array(
            "desktop"=> 'left',
            "tablet"=> '',
            "mobile-h"=> '',
            "mobile-v"=> ''
        ),
        'spacing' => array(
            'top' => 'auto',
            'left' => 'auto',
            'right' => 'auto',
            'bottom' => 'auto'
        ),
        'placeholder' => 'Category Title',
        'style' => 'moto-text_system_7',
        'tag' => 'h2'
    );
    public function getRenderVariables()
    {
        $variables = parent::getRenderVariables ();

        $variables ['keyword'] = Moto\System\Request::getQuery ('keyword', '');
        $variables ['isSearch'] = Link::getEntityUri (Link::URI_SECTION_CATEGORY) == Link::URI_SECTION_SEARCH;

        return $variables;
    }



}