/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

'use strict';

angular.module('application.widget.store.store_checkout', ['application.core'])
    .run(['coreLibraryWidget', 'core.library.editor.WidgetsService',
        function (WidgetFactory, WidgetsService) {
            var AbstractWidgetClass = WidgetFactory.get('AbstractWidgetClass');

            function classWidget() {
                this.properties = {
                    spacing: {
                        top: 'auto',
                        right: 'auto',
                        bottom: 'auto',
                        left: 'auto'
                    },
                    heading_text : 'Checkout',
                    new_customer_title : 'New Customer',
                    exists_customer_title : 'Existing Customer',
                    step_1_text : 'STEP 1: Account Details',
                    step_2_text : 'STEP 2: Billing/Shipping Details',
                    step_3_text : 'STEP 3: Order Confirmation',
                    item_name_text:'Item',
                    item_price_text:'Price',
                    item_quantity_text:'Quantity',
                    item_total_text:'Total',
                    continue_button_text:'Continue',
                    guest_option_text: 'Checkout as guest',
                    account_option_text: 'Register an account',
                    new_customer_text: 'Register with us for a faster checkout, to track the status of your order and more. You can also checkout as a guest.',
                    exists_customer_text: 'To continue, please enter your email address and password for your account.',
                    forgot_password_text: 'Forgot password',
                    email_placeholder: 'E-mail',
                    password_placeholder: 'Password',
                    billing_details: 'Billing Details',
                    shipping_details: 'Shipping Details',
                    first_name_placeholder: 'First Name',
                    last_name_placeholder: 'Last Name',
                    address1_placeholder: 'Adress 1',
                    address2_placeholder: 'Adress 2',
                    city_placeholder: 'City',
                    country_placeholder: 'Country',
                    state_placeholder: 'State',
                    phone_placeholder: 'Phone',
                    company_placeholder: 'Company Name',
                    zip_placeholder: 'Post Code',
                    ship_to_different_address: 'Ship to different address',
                    terms_checkbox_text: 'I agree with terms and conditions',
                    payment_label: 'Please, choose payment method',
                    subtotal_text:'Subtotal',
                    total_text:'Total',
                    shipping_price_text:'Shipping Price',
                    discount_text:'Discount',
                    shipping_discount_text:'Shipping Discount',
                    tax_text : 'Tax',
                    proceed_text : 'Proceed',
                    success_title : 'Your Order has been received!',
                    success_subtitle_1 : 'Thank you for your purchase! Your order ID is:',
                    success_subtitle_2 : 'You`ll receive an email confirmation to:',
                    my_orders_btn : 'My Orders',
                    back_to_shop_btn : 'Back To Shop',
                    try_again_btn : 'Try Again',
                    error_title : 'Your order could not be processed. Please try again.',
                    error_subtitle : 'Your order ID is:',
                };
                AbstractWidgetClass.apply(this, arguments);
            }


            classWidget.prototype = Object.create(AbstractWidgetClass.prototype);
            classWidget.prototype.constructor = classWidget;
            classWidget.prototype._apiVersion = 2;
            classWidget.prototype.name = 'store_checkout';
            classWidget.prototype.label = 'EDITOR.WIDGETS.CHECKOUT.NAME';
            classWidget.prototype.template_view_url = '@plugins/moto-store-plugin/app/widgets/store_checkout/views/properties.tpl.html';
            classWidget.prototype._transformToMacros = true;
            classWidget.prototype._template = {
                engine: 'nunjucks',
                path: '@plugins/moto-store-plugin/app/widgets/store_checkout/presets/default/template.front.twig'
            };

            classWidget.prototype.isRemovable = function() {
                return false;
            };

            classWidget.prototype.isCopyable = function() {
                return false;
            };

            classWidget.prototype.shouldUpdateContentView = function() {
                return true;
            };

            WidgetFactory.set(classWidget.prototype.name, classWidget);
            WidgetsService.addWidget({
                name: 'store_checkout',
                label: 'EDITOR.WIDGETS.CHECKOUT.NAME',
                category: 'store',
                order: 10,
                enabled: false,
                allowed: function(page, sectionName) {
                    return (page.type == "template.store.product" && sectionName == "content");
                },
                icons: {
                    small: 'icon icon-blog-post_content',
                    medium: '',
                    large: 'icon icon-blog-post_content'
                }
            });
        }
]);
