'use strict';

angular.module('application.widget.store.store_compare', ['application.core'])
    .run(['coreLibraryWidget', 'core.library.editor.WidgetsService',
        function (WidgetFactory, WidgetsService) {
            var AbstractWidgetClass = WidgetFactory.get('AbstractWidgetClass');
            function Controller($scope, ProductService, DesignColorizerModel)
            {

                var widget = $scope.currentWidget,
                    f = {
                        count: 3,
                        page: 1,
                        order: [{
                            order: 'created_date',
                            direction: 'desc'
                        }]
                    };


                function getColorByName (name)
                {
                    if (name && $scope.systemColors) {
                        if (name.indexOf('@baseColor') >= 0) {
                            var keys = name.replace('@baseColor', '').split('_');
                            return $scope.systemColors.base[keys[0]][parseInt(keys[1])];
                        } else if (name.indexOf('@customColor') >= 0) {
                            return $scope.systemColors.custom[name.replace('@customColor', '')];
                        } else {
                            return name;
                        }
                    } else {
                        return '';
                    }
                }
                function getCollection (f)
                {
                    ProductService.getCollection (f)
                        .success(function (data) {
                            var items = [];
                            angular.forEach(data.collection, function(item) {
                                items.push({product: item});
                            });
                            widget.items = items;
                            $scope.currentWidget.__getInternalInstance().items = items;
                            widget.renderPreview();
                        });
                }
                getCollection (f);
                DesignColorizerModel
                    .success(function() {
                        var item;
                        if (item = DesignColorizerModel.objects().first()) {
                            $scope.systemColors = item;
                        }
                    })
                    .error(function() {
                        $scope.systemMessenger.error('COMMON.ERROR.UNABLE_TO_GET_DATA');
                    })
                    .load();

                $scope.$on('widgetPropertiesChanged', function (e, newValue, oldValue) {
                    if ($scope.currentWidget && $scope.currentWidget.name == 'store_compare') {
                        $scope.currentWidget.__getInternalInstance().properties.labelHexColor = getColorByName(newValue.labelColor.background);
                        //getCollection(f);
                        widget.renderPreview();
                    }
                });
            }

            Controller.$inject = ['$scope', 'store.product.services.ProductService', 'application.design.colorizer.DesignColorizerModel',];

            function classWidget() {
                this.properties = {
                    preset :'default',
                    thumbnail : {
                        hide : false,
                        preset:'moto-preset-4'
                    },
                    product_title_style: 'moto-text_normal',
                    product_price_style: 'moto-text_system_7',
                    properties_values_style: 'moto-text_system_11',
                    properties_names_style: 'moto-text_system_11',
                    page_heading: 'moto-text_system_6',
                    properties_heading_style: 'moto-text_normal',
                    tip_style: 'moto-text_system_10',
                    properties_text: 'Properties',
                    backtoshop_text: 'Back To Shop',
                    subheading_caption: 'You can add up to 3 products to compare',
                    heading_caption: 'Comparison Page',
                    wrapWord: true,
                    button: {
                        active : true,
                        size : 'medium',
                        preset: 'moto-preset-2',
                        text: 'Add to cart'
                    },
                    button_back:{
                        size: 'medium',
                        preset: 'moto-preset-4'
                    },
                    auto_redirect: true
                };

                AbstractWidgetClass.apply(this, arguments);
            }

            classWidget.prototype = Object.create(AbstractWidgetClass.prototype);
            classWidget.prototype.constructor = classWidget;
            classWidget.prototype.name = 'store_compare';
            classWidget.prototype.label = 'EDITOR.WIDGETS.STORE_COMPARE.NAME';
            classWidget.prototype._apiVersion = 2;
            classWidget.prototype.template_view_url = '@plugins/moto-store-plugin/app/widgets/store_compare/views/properties.tpl.html';
            classWidget.prototype._transformToMacros = true;
            classWidget.prototype.controller = Controller;
            classWidget.prototype.templateUrl = function (){
                return '@plugins/moto-store-plugin/app/widgets/' + this.name + '/presets/' + this.properties.preset + '/template.front.twig';
            };

            classWidget.prototype.isCopyable = function() {
                return false;
            };

            classWidget.prototype.shouldUpdateContentView = function() {
                return true;
            };

            classWidget.prototype.isRemovable = function() {
                return false;
            };
            classWidget.prototype.getRenderVariables = function () {
                var self = this;
                return {
                    currentWidget: self,
                    items: self.items,
                };
            };

            WidgetFactory.set(classWidget.prototype.name, classWidget);

            WidgetsService.addWidget({
                name: 'store_compare',
                label: 'EDITOR.WIDGETS.STORE_COMPARE.NAME',
                category: 'store',
                order: 10,
                enabled: false,
                allowed: function(page, sectionName) {
                    return (page.type == "template.store.product" && sectionName == "content");
                },
                icons: {
                    small: 'icon icon-blog-post_content',
                    medium: '',
                    large: 'icon icon-blog-post_content'
                }
            });
        }
]);
