'use strict';

angular.module('application.widget.store.filters', ['application.core'])
    .run(['coreLibraryWidget', 'core.library.editor.WidgetsService',
        function (WidgetFactory, WidgetsService) {
            var AbstractWidgetClass = WidgetFactory.get('AbstractWidgetClass');

            function Controller($scope, DesignColorizerModel)
            {
                var widget = $scope.currentWidget;

                function getColorByName (name)
                {
                    if (name && $scope.systemColors) {
                        if (name.indexOf('@baseColor') >= 0) {
                            var keys = name.replace('@baseColor', '').split('_');
                            return $scope.systemColors.base[keys[0]][parseInt(keys[1])];
                        } else if (name.indexOf('@customColor') >= 0) {
                            return $scope.systemColors.custom[name.replace('@customColor', '')];
                        } else {
                            return name;
                        }
                    } else {
                        return '';
                    }
                }

                DesignColorizerModel
                    .success(function() {
                        var item;
                        if (item = DesignColorizerModel.objects().first()) {
                            $scope.systemColors = item;
                        }
                    })
                    .error(function() {
                        $scope.systemMessenger.error('COMMON.ERROR.UNABLE_TO_GET_DATA');
                    })
                    .load();
                $scope.$on('widgetPropertiesChanged', function (e, newValue, oldValue) {
                    if ($scope.currentWidget && $scope.currentWidget.name == 'store_filters') {

                        $scope.currentWidget.__getInternalInstance().properties.custom_checkbox_color_Hex = getColorByName(newValue.custom_checkbox_color.background);
                        widget.renderPreview();
                    }
                });
            }


            Controller.$inject = ['$scope', 'application.design.colorizer.DesignColorizerModel'];

            function classWidget() {
                this.properties = {
                    preset: 'default',
                    align: {
                        "desktop": 'left',
                        "tablet": '',
                        "mobile-h": '',
                        "mobile-v": ''
                    },
                    spacing: {
                        "top": 'auto',
                        "right": 'auto',
                        "bottom": 'auto',
                        "left": 'auto'
                    },
                    button_apply: {
                        preset: '2',
                        size: 'medium'
                    },
                    button_clear: {
                        preset: '4',
                        size: 'medium'
                    },
                    filter_headers_style: 'moto-text_normal',
                    filter_items_style: 'moto-text_system_10',
                    button_apply_size: 'medium',
                    button_cancel_size: 'medium',
                    custom_checkbox_color: {
                        background: null
                    },
                    custom_checkbox_color_Hex: null,
                    use_custom_checkboxes: false,
                    price_title_text: "Price",
                    brands_title_text: "Brands",
                    btn_apply_text: "Apply",
                    btn_clear_text: "CLEAR"
                };
                AbstractWidgetClass.apply(this, arguments);
            }

            classWidget.prototype = Object.create(AbstractWidgetClass.prototype);
            classWidget.prototype.constructor = classWidget;
            classWidget.prototype.controller = Controller;
            classWidget.prototype._apiVersion = 2;
            classWidget.prototype.name = 'store_filters';
            classWidget.prototype.label = 'EDITOR.WIDGETS.FILTERS.LABEL';
            classWidget.prototype.categories = [];
            classWidget.prototype.template_view_url = '@plugins/moto-store-plugin/app/widgets/store_filters/views/properties.tpl.html';
            classWidget.prototype._dragImagePath = '@plugins/moto-store-plugin/app/images/svg/app/widgets/store_filters/icons/drag-store-filters.png';
            classWidget.prototype._template = {
                engine: 'nunjucks',
                path: '@plugins/moto-store-plugin/app/widgets/store_filters/presets/default/template.html.twig'
            };
            classWidget.prototype._transformToMacros = true;
            classWidget.prototype.deleteAllAlignClasses= function(){
                var self = this,
                    alignments = ['left', 'center', 'right'];

                for(var device in self.properties.align){
                    alignments.forEach(function(align){
                        if(device == 'desktop'){
                            self.$(self._dom).removeClass('moto-align-' + align );
                        }else{
                            self.$(self._dom).removeClass('moto-align-' + align + '_' + device);
                        }
                    });
                }
            };


            classWidget.prototype.setAlignObject = function(){
                var self = this;

                if (self.properties && self.properties.align && (typeof self.properties.align == 'object')) {
                    self.deleteAllAlignClasses();

                    self.$(self._dom).addClass('moto-align-' + (self.properties.align['desktop']));
                    if (self.properties.align['tablet']) self.$(self._dom).addClass('moto-align-' + (self.properties.align['tablet']) + '_tablet');
                    if (self.properties.align['mobile-h']) self.$(self._dom).addClass('moto-align-' + (self.properties.align['mobile-h']) + '_mobile-h');
                    if (self.properties.align['mobile-v']) self.$(self._dom).addClass('moto-align-' + (self.properties.align['mobile-v']) + '_mobile-v');
                }
            };

            classWidget.prototype.getRenderVariables = function () {
                var self = this;

                return {
                    currentWidget: self
                };
            };


            classWidget.prototype.update = function () {

                var self = this;

                if (self.properties.align) {
                    self.$(self._dom).removeClass('moto-align-left');
                    self.$(self._dom).removeClass('moto-align-right');
                    self.$(self._dom).removeClass('moto-align-center');

                    self.$(self._dom).attr('data-align', JSON.stringify(self.properties.align));
                }


                self.setAlignObject();
                AbstractWidgetClass.prototype.update.call(this);
            };

            classWidget.prototype.initialize = function () {
                var self = this;



                if(typeof self.properties.align == 'string') {
                    self.properties.align = {
                        "desktop": self.properties.align,
                        "tablet": '',
                        "mobile-h": '',
                        "mobile-v": ''
                    };
                }

                try{
                    self.properties.align = JSON.parse(self.$(self._dom).data('align'));
                }catch (ev){
                    self.properties.align = self.$(self._dom).data('align') || self.properties.align;
                }


                self.setAlignObject();

                AbstractWidgetClass.prototype.initialize.call(this);
            };

            classWidget.prototype.isCopyable = function() {
                return true;
            };

            classWidget.prototype.shouldUpdateContentView = function() {
                return true;
            };
            classWidget.prototype.$onInit = function () {
                var self = this;
            };

            WidgetFactory.set(classWidget.prototype.name, classWidget);
            WidgetsService.addWidget({
                name: 'store_filters',
                label: 'EDITOR.WIDGETS.FILTERS.LABEL',
                category: "store",
                order: 22,
                enabled: true,
                allowed: function (page, sectionName) {
                    return [
                            "template.store.category"
                        ].indexOf(page.type) !== -1 &&  sectionName == "content";

                },
                icons: {
                    small: 'icon icon-store-filters',
                    medium: '',
                    large: 'icon icon-store-filters'
                }
            });
        }
]);
