<?php
namespace Website\Widgets\StoreForgot;

use Moto;
use MotoStore\Content\Controller\AuthController;

class Widget extends Moto\System\Widgets\AbstractWidget
{
    /**
     * @var string
     */
    protected $_name = 'store_forgot';
    protected $_widgetId = true;
    protected $_defaultOptions = array(
        'spacing'=> array(
            'top'=> 'auto',
            'right' => 'auto',
            'bottom' => 'auto',
            'left' => 'auto'
        )
    );

    public function getRenderVariables()
    {
        $controller = new AuthController ();

        return array (
            'widget' => $this,
            'currentWidget' => $this,
            'forgotPageContent' => $controller->renderForgotForm ($this)
        );

    }


    /**
     * @param string $preset
     * @return string
     */
    public function getTemplatePath ($preset = 'default')
    {
        $template = '@plugins/moto-store-plugin/app/widgets/' . $this->_name . '/presets/' . $preset . '/template.html.twig';
        return $template;
    }
}