<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace Website\Widgets\StoreProductPrice;

use Moto;
use MotoStore\Content\Content\DI\SMStatic;
use MotoStore\Product\Entity\Product;
use MotoStore\Settings\Entity\Currency;
use Website\Widgets\StoreProduct\ProductWidgetAbstract;
use MotoStore\Settings\Entity\Option;

class Widget extends ProductWidgetAbstract
{
    /**
     * @var string
     */
    protected $_name = 'store_product_price';

    protected $_defaultOptions = array(
        'preset' => 'default',
        'spacing' => array(
            'top' => 'auto',
            'left' => 'auto',
            'right' => 'auto',
            'bottom' => 'auto'
        ),
        'show_prices' => true,
        'align' => array(
            "desktop" => 'left',
            "tablet" => '',
            "mobile-h" => '',
            "mobile-v" => ''
        ),
        'placeholder' => array(
                        'price' => '110',
                        'special_price' => '99.99',
        ),
        'price_style' => 'moto-text_system_7',
        'old_price_style' => 'moto-text_system_7',
        'tag' => 'h4'
    );
    public function getRenderVariables()
    {
        if($this->isCatalogModeEnabled()){
            $this->properties['show_prices'] = false;
        }
        return array_merge(array ('currency' => $this->getDisplayCurrency ()), parent::getRenderVariables());
    }


    public function isCatalogModeEnabled(){
        $optRepository = clone SMStatic::getInstance()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        $catalog_mode = $optRepository ->getOption(Option::OPTION_STORE_SETTINGS_PRODUCT, 'catalog_mode');
        return !!$catalog_mode;
    }

    /**
     * @return Currency
     */
    protected function getDisplayCurrency ()
    {
        return SMStatic::getInstance ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Currency')
            ->getDisplayCurrency ();
    }
}