<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace Website\Widgets\StoreProductRating;

use Moto;
use MotoStore\Product\Entity\Product;
use MotoStore\Settings\Entity\Option;
use Website\Widgets\StoreProduct\ProductWidgetAbstract;

class Widget extends ProductWidgetAbstract
{
    /**
     * @var string
     */
    protected $_name = 'store_product_rating';
    protected $_defaultOptions = array(
        'preset' => 'default',
        'spacing' => array(
            'top' => 'auto',
            'left' => 'auto',
            'right' => 'auto',
            'bottom' => 'auto'
        ),
        'align' => array(
            "desktop" => 'left',
            "tablet" => '',
            "mobile-h" => '',
            "mobile-v" => ''
        ),
        'placeholder' => 'Product Title'
    );

    public function getRenderVariables()
    {
        return array_merge(array ('reviews' => $this->presentReviews ()), parent::getRenderVariables());
    }

    /**
     * Reviews
     * @return array
     */
    protected function presentReviews ()
    {
        return array (
            'isActive'  => $this->getOptionsRepository ()->getOption (Option::OPTION_STORE_SETTINGS_PRODUCT, 'enabled_reviews'),
            'token'     => $this->getOptionsRepository ()->getOption (Option::OPTION_STORE_SETTINGS_PRODUCT, 'yotpo_token'),
        );
    }
}