'use strict';

angular.module('application.widget.store.product_add_to_wishlist', ['application.core'])
    .run(['coreLibraryWidget', 'core.library.editor.WidgetsService','application.design.colorizer.DesignColorizerModel',
        function (WidgetFactory, WidgetsService, DesignColorizerModel) {
            var AbstractWidgetClass = WidgetFactory.get('AbstractWidgetClass');
            var systemColors = {};
            function getColorByName (name)
            {
                if (name && systemColors) {
                    if (name.indexOf('@baseColor') >= 0) {
                        var keys = name.replace('@baseColor', '').split('_');
                        return systemColors.base[keys[0]][parseInt(keys[1])];
                    } else if (name.indexOf('@customColor') >= 0) {
                        return systemColors.custom[name.replace('@customColor', '')];
                    } else {
                        return name;
                    }
                } else {
                    return '';
                }
            }

            DesignColorizerModel
                .success(function() {
                    var item;
                    if (item = DesignColorizerModel.objects().first()) {
                        systemColors = item;
                    }
                }).load();


            function AddToWishList() {
                this.properties = {
                    preset: 'default',
                    align: {
                        "desktop": 'left',
                        "tablet": '',
                        "mobile-h": '',
                        "mobile-v": ''
                    },
                    spacing: {
                        top: 'auto',
                        right: 'auto',
                        bottom: 'auto',
                        left: 'auto'
                    },
                    display_type: 'default',
                    button: {
                        preset: 'default',
                        text: 'Add To Wish List',
                        size: 'large'
                    },
                    auto_redirect: false,
                    icon_color: {
                        background: null
                    },
                    icon_color_hex: null,
                };

                AbstractWidgetClass.apply(this, arguments);
            }

            AddToWishList.prototype = Object.create(AbstractWidgetClass.prototype);
            AddToWishList.prototype.constructor = AddToWishList;
            AddToWishList.prototype._apiVersion = 2;
            AddToWishList.prototype.name = 'store_product_add_to_wishlist';
            AddToWishList.prototype.label = 'EDITOR.WIDGETS.PRODUCT_ADD_TO_WISHLIST.LABEL';
            AddToWishList.prototype.template_view_url = '@plugins/moto-store-plugin/app/widgets/store_product/views/' + AddToWishList.prototype.name + '/properties.tpl.html';
            AddToWishList.prototype.templateUrl = function (){
                return '@plugins/moto-store-plugin/app/widgets/store_product/presets/store_product_add_to_wishlist/default/template.html.twig';
            };
            AddToWishList.prototype._transformToMacros = true;
            AddToWishList.prototype._dragImagePath = '@plugins/moto-store-plugin/app/images/svg/app/widgets/store_product/icons/drag-store-product-add-to-wishlist.png';
            AddToWishList.prototype.product = null;
            AddToWishList.prototype.allow = ['section', 'container'];
            AddToWishList.prototype.deleteAllAlignClasses= function(){
                var self = this,
                    alignments = ['left', 'center', 'right'];

                for(var device in self.properties.align){
                    alignments.forEach(function(align){
                        if(device == 'desktop'){
                            self.$(self._dom).removeClass('moto-align-' + align );
                        }else{
                            self.$(self._dom).removeClass('moto-align-' + align + '_' + device);
                        }
                    });
                }
            };

            AddToWishList.prototype.setAlignObject = function(){
                var self = this;

                if (self.properties && self.properties.align && (typeof self.properties.align == 'object')) {
                    self.deleteAllAlignClasses();

                    self.$(self._dom).addClass('moto-align-' + (self.properties.align['desktop']));
                    if (self.properties.align['tablet']) self.$(self._dom).addClass('moto-align-' + (self.properties.align['tablet']) + '_tablet');
                    if (self.properties.align['mobile-h']) self.$(self._dom).addClass('moto-align-' + (self.properties.align['mobile-h']) + '_mobile-h');
                    if (self.properties.align['mobile-v']) self.$(self._dom).addClass('moto-align-' + (self.properties.align['mobile-v']) + '_mobile-v');
                }
            };

            AddToWishList.prototype.getRenderVariables = function () {
               this.properties.icon_color_hex = getColorByName(this.properties.icon_color.background);
               this.show_added_state = false;
                var self = this;
                return {
                    currentWidget: self
                };
            };

            AddToWishList.prototype.update = function () {

                var self = this;

                if (self.properties.align) {
                    self.$(self._dom).removeClass('moto-align-left');
                    self.$(self._dom).removeClass('moto-align-right');
                    self.$(self._dom).removeClass('moto-align-center');

                    self.$(self._dom).attr('data-align', JSON.stringify(self.properties.align));
                }

                self.setAlignObject();
                AbstractWidgetClass.prototype.update.call(this);
            };

            AddToWishList.prototype.initialize = function () {
                var self = this;



                if(typeof self.properties.align == 'string') {
                    self.properties.align = {
                        "desktop": self.properties.align,
                        "tablet": '',
                        "mobile-h": '',
                        "mobile-v": ''
                    };
                }

                try{
                    self.properties.align = JSON.parse(self.$(self._dom).data('align'));
                }catch (ev){
                    self.properties.align = self.$(self._dom).data('align') || self.properties.align;
                }


                self.setAlignObject();

                AbstractWidgetClass.prototype.initialize.call(this);
            };


            AddToWishList.prototype.isCopyable = function() {
                return true;
            };

            AddToWishList.prototype.shouldUpdateContentView = function() {
                return true;
            };

            AddToWishList.prototype.$onInit = function () {
                var self = this;
            };


            WidgetFactory.set(AddToWishList.prototype.name, AddToWishList);
            
            WidgetsService.addWidget({
                name: 'store_product_add_to_wishlist',
                label: 'EDITOR.WIDGETS.PRODUCT_ADD_TO_WISHLIST.LABEL',
                category: "store",
                order: 22,
                enabled: true,
                allowed: function (page, sectionName) {
                    return "template.store.product" == page.type &&  sectionName == "content";
                },
                icons: {
                    small: 'icon icon-store-product-add-to-wishlist',
                    medium: '',
                    large: 'icon icon-store-product-add-to-wishlist'
                }
            });
        }
]);
