'use strict';

angular.module('application.widget.store.product_grid_custom', ['application.core','core.library.config'])
    .run(['coreLibraryWidget', 'core.library.editor.WidgetsService', 'coreLibraryConfig','$translate', 'coreLibraryModal',
        function (WidgetFactory, WidgetsService, coreLibraryConfig, $translate, coreLibraryModal) {
            var AbstractWidgetClass = WidgetFactory.get('AbstractWidgetClass');

            /**
             * @param $scope
             * @param ProductService
             * @constructor
             */
            function Controller($scope, ProductService, DesignColorizerModel)
            {
               
                var widget = $scope.currentWidget,
                    f = {
                        count: widget.properties.per_page,
                        page: 1,
                        order: [{
                            order: 'created_date',
                            direction: 'desc'
                        }]
                    };

                function getColorByName (name)
                {
                    if (name && $scope.systemColors) {
                        if (name.indexOf('@baseColor') >= 0) {
                            var keys = name.replace('@baseColor', '').split('_');
                            return $scope.systemColors.base[keys[0]][parseInt(keys[1])];
                        } else if (name.indexOf('@customColor') >= 0) {
                            return $scope.systemColors.custom[name.replace('@customColor', '')];
                        } else {
                            return name;
                        }
                    } else {
                        return '';
                    }
                }

                DesignColorizerModel
                    .success(function() {
                        var item;
                        if (item = DesignColorizerModel.objects().first()) {
                            $scope.systemColors = item;
                        }
                    })
                    .error(function() {
                        $scope.systemMessenger.error('COMMON.ERROR.UNABLE_TO_GET_DATA');
                    })
                    .load();

                $scope.currentWidget.__getInternalInstance().pagination = widget.createPaginationArray (widget.properties.per_page);
                $scope.currentWidget.__getInternalInstance().currencies = [{'id':1,'code':'USD'},{'id':2,'code':'EUR'}];
                /**
                 *
                 */
                $scope.$on('widgetPropertiesChanged', function (e, newValue, oldValue) {
                    if ($scope.currentWidget && $scope.currentWidget.name == 'store_product_grid_custom') {

                        $scope.currentWidget.__getInternalInstance().pagination = widget.createPaginationArray (widget.properties.per_page);
                        $scope.currentWidget.__getInternalInstance().properties.labelHexColor = getColorByName(newValue.labelColor.background);
                        if (newValue.per_page != oldValue.per_page)
                        {
                            f.count = newValue.per_page;
                            return;
                        }

                        $scope.updateProductList();
                        applyThumbnails();
                        widget.renderPreview();
                    }
                });


                $scope.updateProductList = function(){
                    $scope.currentWidget.products =  $scope.currentWidget.properties.selected_products;

                };

                $scope.deleteItem = function (index) {
                    $scope.currentWidget.properties.selected_products.splice(index, 1);
                };

                $scope.openItemPopup = function(childrenWidget) {
                    coreLibraryModal(
                        '@plugins/moto-store-plugin/app/widgets/store_product_grid_custom/views/item.tpl.html',
                        function($modalScope, $modalInstance) {

                          $modalScope.selected_product_id = 0;
                            $modalScope.select = function(id) {
                                $modalScope.selected_product_id = id;
                            };
                            $modalScope.ok = function() {
                                ProductService.getItem({id: $modalScope.selected_product_id }).success(
                                    function (data) {
                                        if (data.locales.en.description){
                                            data.locales.en.description = '';
                                        }
                                        if (data.locales.en.short_description){
                                            data.locales.en.short_description = '';
                                        }
                                        $scope.currentWidget.properties.selected_products.push(data);
                                    }
                                );
                                $modalInstance.close($modalScope);
                            };
                            $modalScope.cancel = function() {
                                $modalInstance.close($modalScope);
                            };
                        }
                    );
                };

                function applyThumbnails(){

                    if($scope.currentWidget.__getInternalInstance().properties.use_thumbnails && $scope.currentWidget.__getInternalInstance().properties.tumbnail_size){
                       for (var i=0; i < widget.products.length; i++) {
                           if ($scope.currentWidget.__getInternalInstance().products[i].image){
                               $scope.currentWidget.__getInternalInstance().products[i].image.thump_path = getThumbnailPath($scope.currentWidget.products[i].image, $scope.currentWidget.__getInternalInstance().properties.tumbnail_size);
                           }
                       }
                    }
                }

                function getThumbnailPath(image,size) {
                        var lastSlashPosition;
                        var lastDotPosition;
                        var thumbnailFileName;
                        if (!image.thumbnails){
                            return image.path;
                        }
                        var thumbnails = JSON.parse(image.thumbnails);
                        if (!size) {
                            return image.path;
                        }

                        if (thumbnails[size]) {
                            lastSlashPosition = image.path.lastIndexOf('/');
                            lastDotPosition = image.path.lastIndexOf('.');
                            thumbnailFileName = image.path.substring(lastSlashPosition + 1, lastDotPosition) + '_' + size + '_'
                                + thumbnails[size].width + 'x' + thumbnails[size].height
                                + image.path.substring(lastDotPosition, image.path.length);
                            return image.path.substring(0, lastSlashPosition) + '/thumbnails/' + thumbnailFileName;
                        } else {
                            return image.path;
                        }
                }

            }

            Controller.$inject = ['$scope', 'store.product.services.ProductService', 'application.design.colorizer.DesignColorizerModel',];

            function classWidget() {
                this.properties = {
                    preset: 'default',
                    align: {
                        "desktop": 'left',
                        "tablet": '',
                        "mobile-h": '',
                        "mobile-v": ''
                    },
                    spacing: {
                        "top": 'auto',
                        "right": 'auto',
                        "bottom": 'auto',
                        "left": 'auto'
                    },
                    row_size: '3',
                    thumbnail: {
                        hide: false,
                        zoom: false,
                        preset: 'default'
                    },
                    hide_prices: false,
                    per_page_label: 'Items per page:',
                    product_title_style: '',
                    product_price_style: '',
                    product_pagination_style: '',
                    products_not_found_style: 'moto-text_system_9',
                    products_not_found_text: 'Sorry, no products found',
                    products_not_found_text_default: 'Sorry, no products found',
                    labelColor: {
                        background: null
                    },
                    labelHexColor: null,
                    wrapWord: true,
                    button: {
                        active: false,
                        size: 'medium',
                        preset: 'default',
                        text: 'Add to cart'
                    },
                    tumbnails:[],
                    selected_products:[],
                };
                var thumbnails = coreLibraryConfig.get('settings.website.thumbnails');
                var self = this;
                if (thumbnails) {
                    thumbnails.forEach(function(thumbnail) {
                        self.properties.tumbnails.push({
                            label: $translate.instant(thumbnail.label)
                                + ' (' + thumbnail.height + 'x' + thumbnail.width + ')',
                            name: thumbnail.name
                        });
                    });
                }

                AbstractWidgetClass.apply(this, arguments);
            }
    
            classWidget.prototype = Object.create(AbstractWidgetClass.prototype);
            classWidget.prototype.constructor = classWidget;
            classWidget.prototype._apiVersion = 2;
            classWidget.prototype.name = 'store_product_grid_custom';
            classWidget.prototype.label = 'EDITOR.WIDGETS.STORE_PRODUCT_GRID_CUSTOM.LABEL';
            classWidget.prototype.products = [];
            classWidget.prototype.template_view_url = '@plugins/moto-store-plugin/app/widgets/store_product_grid_custom/views/properties.tpl.html';
            classWidget.prototype._dragImagePath = '@plugins/moto-store-plugin/app/images/svg/app/widgets/store_product_grid_custom/icons/drag-store-product-grid-custom.png';
            classWidget.prototype.templateUrl = function (){
                return '@plugins/moto-store-plugin/app/widgets/' + this.name + '/presets/' + this.properties.preset + '/template.html.twig';
            };

            classWidget.prototype._transformToMacros = true;
            classWidget.prototype.controller = Controller;
            classWidget.prototype.allow = ['section', 'container'];

            classWidget.prototype.deleteAllAlignClasses= function(){
                var self = this,
                    alignments = ['left', 'center', 'right'];

                for(var device in self.properties.align){
                    alignments.forEach(function(align){
                        if(device == 'desktop'){
                            self.$(self._dom).find('.moto-widget-store-main_item').removeClass('moto-align-' + align );
                        }else{
                            self.$(self._dom).find('.moto-widget-store-main_item').removeClass('moto-align-' + align + '_' + device);
                        }
                    });
                }
            };

            /**
             * Create product pages list
             *
             * @param perPage
             * @param total
             * @returns {Array}
             */
            classWidget.prototype.createPagesArray = function (perPage, total)
            {
                var i,
                    pages = [],
                    count = Math.ceil(total/perPage);

                for (i=1; i <= 5; i++)
                {
                    pages.push(i);
                }

                return pages;
            };


            /**
             * Create pagination elements
             * @param perPage
             * @returns {Array}
             */
            classWidget.prototype.createPaginationArray = function (perPage)
            {
                var pagination = [],
                    i;
                for (i = 1; i <= 4; ++i)
                {
                    pagination.push (i * perPage)
                }

                return pagination;
            };

            classWidget.prototype.setAlignObject = function(){
                var self = this;

                if (self.properties && self.properties.align && (typeof self.properties.align == 'object')) {
                    self.deleteAllAlignClasses();
                    var $alignElement = self.$(self._dom).find('.moto-widget-store-main_item')

                    $alignElement.addClass('moto-align-' + (self.properties.align['desktop']));
                    if (self.properties.align['tablet']) $alignElement.addClass('moto-align-' + (self.properties.align['tablet']) + '_tablet');
                    if (self.properties.align['mobile-h']) $alignElement.addClass('moto-align-' + (self.properties.align['mobile-h']) + '_mobile-h');
                    if (self.properties.align['mobile-v']) $alignElement.addClass('moto-align-' + (self.properties.align['mobile-v']) + '_mobile-v');
                }
            };

            classWidget.prototype.getRenderVariables = function () {
                var self = this;
                return {
                    currentWidget: self,
                    products: self.products,
                    currencies: self.currencies,
                };
            };

            classWidget.prototype.update = function () {

                var self = this;

                (new MotoStoreSelectBox(self.$(self._dom).find ('.moto-widget-store-select_box select'))).render();

                if (self.properties.align) {
                    self.$(self._dom).removeClass('moto-align-left');
                    self.$(self._dom).removeClass('moto-align-right');
                    self.$(self._dom).removeClass('moto-align-center');

                    self.$(self._dom).attr('data-align', JSON.stringify(self.properties.align));
                }

                self.setAlignObject();
                AbstractWidgetClass.prototype.update.call(this);
            };

            classWidget.prototype.initialize = function () {
                var self = this;

                var propertiesNode = self.$('script[type="text/widget-properties"]', self._dom);

                if (propertiesNode.length) {
                    var properties;

                    try {
                        properties = angular.fromJson(propertiesNode.text().trim());
                    } catch (ignored) {
                    }

                    if (angular.isObject(properties)) {
                        jQuery.extend(true, self.properties, properties);
                    }

                }

                if(typeof self.properties.align == 'string') {
                    self.properties.align = {
                        "desktop": self.properties.align,
                        "tablet": '',
                        "mobile-h": '',
                        "mobile-v": ''
                    };
                }

                try{
                    self.properties.align = JSON.parse(self.$(self._dom).data('align'));
                }catch (ev){
                    self.properties.align = self.$(self._dom).data('align') || self.properties.align;
                }


                self.setAlignObject();

                AbstractWidgetClass.prototype.initialize.call(this);
            };

            /** @inheritdoc */
            classWidget.prototype.isCopyable = function() {
                return true;
            };

            /**
             * Return is needed update widget's view
             *
             * @returns {boolean}
             */
            classWidget.prototype.shouldUpdateContentView = function() {
                return true;
            };
            


            WidgetFactory.set(classWidget.prototype.name, classWidget);
            WidgetsService.addWidget({
                name: 'store_product_grid_custom',
                label: 'EDITOR.WIDGETS.STORE_PRODUCT_GRID_CUSTOM.LABEL',
                category: "store",
                order: 22,
                enabled: true,
                allowed: function (page, sectionName) {
                    return sectionName == "content";
                },
                icons: {
                    small: 'icon icon-store-product-grid-custom',
                    medium: '',
                    large: 'icon icon-store-product-grid-custom'
                }
            });
        }
]);
angular.module('application.widget.store.product_grid_custom').controller ('store.widgets.store_product_grid_custom.addProductItemController', [
    '$scope',
    'store.product.services.ProductService',

    function ($scope, ProductService) {

        $scope.product_list = [];

        ProductService.getProductsList ()
            .success(
                function (data) {
                    $scope.product_list = data;
                }
            );
    }
]);