/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

'use strict';

angular.module('application.widget.store.store_registration', ['application.core'])
    .run(['coreLibraryWidget', 'core.library.editor.WidgetsService',
        function (WidgetFactory, WidgetsService) {
            var AbstractWidgetClass = WidgetFactory.get('AbstractWidgetClass');

            function classWidget() {
                this.properties = {
                    spacing: {
                        top: 'auto',
                        right: 'auto',
                        bottom: 'auto',
                        left: 'auto'
                    }
                };
                AbstractWidgetClass.apply(this, arguments);
            }

            classWidget.prototype = Object.create(AbstractWidgetClass.prototype);
            classWidget.prototype.constructor = classWidget;
            classWidget.prototype.name = 'store_registration';
            classWidget.prototype.label = 'EDITOR.WIDGETS.STORE_REGISTRATION.NAME';
            classWidget.prototype.template_view_url = '@plugins/moto-store-plugin/app/widgets/store_registration/views/properties.tpl.html';
            classWidget.prototype._apiVersion = 2;
            classWidget.prototype._transformToMacros = true;
            classWidget.prototype._template = {
                engine: 'nunjucks',
                path: '@plugins/moto-store-plugin/app/widgets/store_registration/presets/default/template.front.twig'
            };

            classWidget.prototype.isCopyable = function() {
                return false;
            };

            classWidget.prototype.shouldUpdateContentView = function() {
                return true;
            };

            classWidget.prototype.isRemovable = function() {
                return false;
            };

            WidgetFactory.set('store_registration', classWidget);

            WidgetsService.addWidget({
                name: 'store_registration',
                label: 'EDITOR.WIDGETS.STORE_REGISTRATION.NAME',
                category: 'store',
                order: 10,
                enabled: false,
                allowed: function(page, sectionName) {
                    return (page.type == "template.store.register" && sectionName == "content");
                },
                icons: {
                    small: 'icon icon-blog-post_content',
                    medium: '',
                    large: 'icon icon-blog-post_content'
                }
            });
        }
    ]);
