'use strict';

angular.module('application.widget.store.working_hours', ['application.widget.abstract'])
    .run(['coreLibraryWidget', 'core.library.editor.WidgetsService',
        function (WidgetFactory, WidgetsService) {
            var AbstractWidgetClass = WidgetFactory.get('AbstractWidgetClass');

     

            function classWidget () {
                this.properties = {
                    preset: 'default',
                    align: {
                        "desktop": 'left',
                        "tablet": '',
                        "mobile-h": '',
                        "mobile-v": ''
                    },
                    spacing: {
                        top: 'auto',
                        right: 'auto',
                        bottom: 'auto',
                        left: 'auto'
                    },
                    heading_style: 'moto-text_normal',
                    row_style: 'moto-text_normal',
                    show_week_day: true,
                    days_title: 'Days',
                    closed_caption: 'closed',
                    hours_title: 'Opened Hours',
                    monday: 'Monday',
                    tuesday: 'Tuesday',
                    wednesday: 'Wednesday',
                    thursday: 'Thursday',
                    friday: 'Friday',
                    saturday: 'Saturday',
                    sunday: 'Sunday',
                };
                AbstractWidgetClass.apply(this, arguments);
            }

            classWidget.prototype = Object.create(AbstractWidgetClass.prototype);
            classWidget.prototype.constructor = classWidget;
            classWidget.prototype.name = 'store_working_hours';
            classWidget.prototype.label = 'EDITOR.WIDGETS.WORKING_HOURS.LABEL';
            classWidget.prototype.template_view_url = '@plugins/moto-store-plugin/app/widgets/store_working_hours/views/properties.tpl.html';
            classWidget.prototype._transformToMacros = true;
            classWidget.prototype._apiVersion = 2;
            classWidget.prototype._dragImagePath =  '@plugins/moto-store-plugin/app/widgets/store_working_hours/icons/drag-store-working-hours.png';
            classWidget.prototype._template = {
                engine: 'nunjucks',
                path: '@plugins/moto-store-plugin/app/widgets/store_working_hours/presets/default/template.html.twig'
            };

            classWidget.prototype.getRenderVariables = function() {
                var shedule = [];
                var days = ['Monday','Tuesday','Wednesday','Thursday','Friday','Saturday','Sunday'];
                var days_localization = [this.properties.monday,this.properties.tuesday,this.properties.wednesday,this.properties.thursday,this.properties.friday,this.properties.saturday,this.properties.sunday];
                var timefrom = '08:00';
                var timeto = '18:00';
               for (var i=0; i < 7; i++){
                    var $obj = [];
                    $obj['from'] = timefrom;
                    $obj['to'] = timeto;
                    $obj ['dayname'] = days[i]+' ';
                    $obj ['localized_dayname'] = days_localization[i];
                    $obj['day'] = '0'+(i*1+1)+'-01-1970';
                   shedule.push($obj);
               }
               return {
                   currentWidget: this,
                   tmp_shedule: shedule
               };
            };
            classWidget.prototype.isCopyable = function() {
                return true;
            };

            classWidget.prototype.shouldUpdateContentView = function() {
                return true;
            };
            WidgetFactory.set(classWidget.prototype.name, classWidget);
            WidgetsService.addWidget({
                name: classWidget.prototype.name,
                label: classWidget.prototype.label,
                category: "store",
                order: 5,
                enabled: true,
                icons: {
                    small: 'icon icon-store-working-hours',
                    medium: '',
                    large: 'icon icon-store-working-hours'
                }
            });
        }
    ]);
