<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

use Zend\ServiceManager\ServiceLocatorInterface;

$storeConfig =  array (

    'store.modules' => array (
        new \MotoStore\Update\Module (),
        new \MotoStore\Collection\Module (),
        new \MotoStore\Service\Module (),
        new \MotoStore\Localization\Module (),
        new \MotoStore\Product\Module (),
        new \MotoStore\Customer\Module (),
        new \MotoStore\Order\Module (),
        new \MotoStore\Settings\Module (),
        new \MotoStore\Payment\Module (),
        new \MotoStore\Dashboard\Module (),
        new \MotoStore\Content\Module (),
        new \MotoStore\Mailer\Module (),
    ),
    'store.up.config'=> array (
        'host'          => 'http://motostore.motocms.com/api',
        'temp'          => MOTOSTORE_ROOT_DIR . '/data/temp',
        'cache'         => MOTOSTORE_ROOT_DIR . '/data/cache',
        'log'           => MOTOSTORE_ROOT_DIR . '/data/system/update.log',
        'timeOut'       => 300
    ),

    /**
     * Example cache config
     * Supported adapters:
     *  - apc
     *  - dba
     *  - filesystem
     *  - memcached
     *  - redis
     *  - memory
     *  - mongodb
     *  - wincache
     *  - xcache
     */
    'cache' => array(
        'adapter' => array(
            'name' => 'filesystem',
            'options' => array(
                'ttl'       => 9000,
                'cache_dir' => MOTOSTORE_ROOT_DIR . '/data/cache'
            ),
        ),
        'plugins' => array (
            'exception_handler' => array(
                'throw_exceptions' => false
            ),
        ),
    ),


    'Doctrine' => array (
        'driver'            => 'pdo_mysql',
        'proxyDirectory'    => MOTOSTORE_ROOT_DIR . '/data/proxy',
        'annotationDirectory'    => '@plugins/' . MOTOSTORE_FOLDER_NAME . '/data/cache/annotation/',
        'proxyNamespace'    => 'MotoStore\Entity\Proxy',
        'proxyAutoGenerate' => true,
    ),

    'service_manager' => array (
        'abstract_factories'    => array (
            'Zend\Cache\Service\StorageCacheAbstractServiceFactory',
        ),
        'factories' => array (

            // MotoCMS Shared Config
            'store.motocms.config' => function (ServiceLocatorInterface $sm) {

                return \Moto\Config::toArray ();
            },

            'store.motocms.rpc' => function (ServiceLocatorInterface $sm) {
                return \Moto\Json\Server::getInstance ();
            },

            'store.twig' => function (ServiceLocatorInterface $serviceLocator) {
                \Moto\Features::init();
                /** @var Twig_Environment $twig */
                $twig = \Moto\Render::getInstance ();
                /**
                 * @todo move to service
                 */
                $twig
                    ->getLoader ()
                    ->addPath (MOTOSTORE_ROOT_DIR . '/src/public/template');

                return $twig;
            },

            'store.module.manager'  => 'MotoStore\Platform\Module\Service\Manager',
            'MotoStore\EntityManager' => 'MotoStore\Platform\Doctrine\Service\EntityManagerFactory',
        ),
    ),

    'Entities' => array(
        __DIR__ . '/../modules/Platform/src/Platform/Entity',
    ),

    'settings' => array(
        'trialmode' => false,
        'exportPath' => '@plugins/' . MOTOSTORE_FOLDER_NAME . '/data/export/',
        'invoicePath' => '@plugins/' . MOTOSTORE_FOLDER_NAME . '/data/export/',
        'updates' => true,
        'sitemap'=> array(
            'path' =>'@plugins/' . MOTOSTORE_FOLDER_NAME . '/data/sitemap/',
            'productsPriority' => '0.5',
            'categoriesPriority' => '0.6',
            'mainpagePriority' => '0.8'
        )
    ),

    'lockFiles' => array(
               'install' => '@plugins/' . MOTOSTORE_FOLDER_NAME . '/data/system/install.lock',
               'update' => '@plugins/' . MOTOSTORE_FOLDER_NAME . '/data/system/auto-update.lock',
    ),


);
if ($storeConfig['settings']['trialmode'] == true) {
    $storeConfig['settings']['exportPath'] = '@pluginsStorageDir/moto-store-plugin/';
    $storeConfig['settings']['sitemap']['path'] = '@pluginsStorageDir/moto-store-plugin/';
    $storeConfig['settings']['invoicePath'] = '@pluginsStorageDir/moto-store-plugin/';
    $storeConfig['Doctrine']['annotationDirectory'] = '@pluginsStorageDir/moto-store-plugin/annotation/';
    $storeConfig['settings']['updates'] = false;
    $storeConfig['lockFiles'] = array(
        'install' => '@pluginsStorageDir/moto-store-plugin/lock-files/install.lock',
        'update' => '@pluginsStorageDir/moto-store-plugin/lock-files/update.lock',
    );
}


return $storeConfig;