<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Collection;


class CollectionHelper
{
    const PARAM_COUNT   = 'count';

    const PARAM_PAGE    = 'page';

    const PARAM_ORDER   = 'order';

    const PARAM_FILTERS = 'filters';

    const PARAM_COUNT_DEF  = null;

    const PARAM_OFFSET_DEF   = null;

    /**
     * @var \ArrayObject
     */
    protected $params;

    /**
     * @param $params
     */
    public function __construct ($params)
    {
        $this->params = new \ArrayObject (is_array ($params) ? $params : array ());
    }

    /**
     * Return valid offset
     *
     * @return int|string
     */
    public function getOffset ()
    {

        if ($this->params->offsetExists (self::PARAM_PAGE))
        {
            $page = $this->params->offsetGet (self::PARAM_PAGE);

            if (is_numeric ($page) && $page > 0)
            {
                if (!is_null ($this->getLimit ()))
                {
                    return ($page - 1) * $this->getLimit ();
                }
            }
        }
        return self::PARAM_OFFSET_DEF;
    }

    /**
     * Return valid limit
     *
     * @return int|mixed
     */
    public function getLimit ()
    {
        if ($this->params->offsetExists (self::PARAM_COUNT))
        {
            $count = $this->params->offsetGet (self::PARAM_COUNT);

            if (is_numeric ($count) && $count > 0)
            {
                return $count;
            }
        }
        return self::PARAM_COUNT_DEF;
    }

    /**
     * Return Valid Filters
     *
     * @return array
     */
    public function getFilters ()
    {
        if ($this->params->offsetExists (self::PARAM_FILTERS))
        {
            return $this->params->offsetGet (self::PARAM_FILTERS);
        }

        return array ();
    }


    /**
     * Return order params
     * @return array
     */
    public function getOrder ()
    {
        if ($this->params->offsetExists (self::PARAM_ORDER))
        {
            $order = $this->params->offsetGet (self::PARAM_ORDER);
            if (is_array ($order))
            {
                return array_map (function ($order) {

                    if (!empty ($order ['order']) && !empty ($order ['direction']) && in_array (strtolower ($order ['direction']), array ('asc', 'desc')))
                    {
                        return array (
                            'order'     => $order ['order'],
                            'direction' => $order ['direction'],
                        );
                    }
                   return array ();
                }, $order);
            }
        }

        return array ();
    }

    /**
     * @param null $key
     * @param null $default
     * @return \ArrayObject|mixed|null
     */
    public function get ($key = null, $default=null)
    {
        if ($key)
        {
            if ($this->params->offsetExists ($key))
            {
                return $this->params->offsetGet ($key);
            }
            return $default;
        }
        return $this->params;
    }
}