<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Collection;


interface CollectionInterface
{
    /**
     * @param QueryBuilder
     */
    public function setQuery ($query);

    /**
     * Set hydration mode
     *
     * @param $mode
     * @return mixed
     */
    public function setHydrationMode ($mode);

    /**
     * @param $map
     */
    public function setPropertiesMap ($map);

    /**
     * @param callable $callback
     * @return array
     */
    public function getCollection ($callback = null);

    /**
     * @param $id
     * @param callable $callback
     * @return object
     */
    public function getOne ($id, $callback = null);

    /**
     * @param callable $callback
     * @return array
     */
    public function getCollectionWithMetaData ($callback = null);

    /**
     * @return string
     */
    public function getCollectionCount ();
}