<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Collection\Query;


class Param
{
    const OPERATOR_EQ       = 'eq';

    const OPERATOR_NOT_EQ   = 'ne';

    const OPERATOR_START    = 'sw';

    const OPERATOR_CONTAINS = 'ct';

    const OPERATOR_FINISH   = 'fw';

    const OPERATOR_IN       = 'in';
    
    const OPERATOR_IS      = 'is';

    const OPERATOR_NULL     = 'null';

    const OPERATOR_GREATER  = 'gt';

    const OPERATOR_LESS     = 'lt';

    const OPERATOR_BETWEEN  = 'bw';
    /**
     * @var string
     */
    protected $field;

    /**
     * @var string
     */
    protected $operator;

    /**
     * @var mixed
     */
    protected $value;

    /**
     * @param $field
     * @param $operator
     * @param $value
     */
    function __construct ($field, $operator, $value)
    {
        $this->field    = $field;
        $this->operator = $operator;
        $this->value    = $value;
    }


    /**
     * @return string
     */
    public function getField()
    {
        return $this->field;
    }

    /**
     * @param string $field
     */
    public function setField($field)
    {
        $this->field = $field;
    }

    /**
     * @return string
     */
    public function getOperator()
    {
        return $this->operator;
    }

    /**
     * @param string $operator
     */
    public function setOperator($operator)
    {
        $this->operator = $operator;
    }

    /**
     * @return mixed
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * @param mixed $value
     */
    public function setValue($value)
    {
        $this->value = $value;
    }

}