<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

return array (
    'service_manager' => array (
        'factories' => array (
            'MotoStore\Content\PageRepository' => 'MotoStore\Content\Repository\PageRepositoryFactory',
            'MotoStore\Cache' => 'MotoStore\Content\Cache\CacheService',
            'MotoStore\Plugin\Metatag' => 'MotoStore\Content\Plugin\MetatagFactory',

            'MotoStore\Content\Application' => 'MotoStore\Content\Application\StoreApplicationFactory',
        ),
    ),

    'routes' => array (

        'store-home' => array (
            'pattern' => '/store/*',
            'controller' => 'MotoStore\Content\Controller\HomeController',
            'section'   => 'home',
        ),

        'store-category' => array (
            'pattern' => '/store/category/(.+)',
            'controller' => 'MotoStore\Content\Controller\CategoryController',
            'section'   => 'category',
        ),

        'store-product' => array (
            'pattern' => '/store/product/(.+)',
            'controller' => 'MotoStore\Content\Controller\ProductController',
            'section'   => 'product',
        ),

        'store-login' => array (
            'pattern' => '/store/login/*',
            'controller' => 'MotoStore\Content\Controller\AuthController',
            'section'   => 'login',
        ),

        'store-registration' => array (
            'pattern' => '/store/registration/*',
            'controller' => 'MotoStore\Content\Controller\AuthController',
            'section'   => 'register',
        ),

        'store-forgot' => array (
            'pattern' => '/store/forgot/*',
            'controller' => 'MotoStore\Content\Controller\AuthController',
            'section'   => 'forgot',
        ),

        'store-account' => array (
            'pattern' => '/store/account/(.+)',
            'controller' => 'MotoStore\Content\Controller\AccountController',
            'section'   => 'account',
        ),

        'store-cart' => array (
            'pattern' => '/store/cart/*',
            'controller' => 'MotoStore\Content\Controller\CartController',
            'section'   => 'cart',
        ),

        'store-checkout' => array (
            'pattern' => '/store/checkout/(.+)',
            'controller' => 'MotoStore\Content\Controller\CheckoutController',
            'section'   => 'checkout',
        ),
        
        'store-oauth-quickbooks' => array (
            'pattern' => '/store/oauth/quickbooks/*',
            'controller' => 'MotoStore\Content\Controller\OauthQuickBooksController',
            'section'   => 'oauth',
        ),

        'store-compare' => array (
            'pattern' => '/store/compare/*',
            'controller' => 'MotoStore\Content\Controller\CompareController',
            'section'   => 'compare',
        ),

        'store-wishlist' => array (
            'pattern' => '/store/wishlist/*',
            'controller' => 'MotoStore\Content\Controller\WishlistController',
            'section'   => 'wishlist',
        ),

    )
);