<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Content\Controller;

use MotoStore\Content\Helper\Translator;
use MotoStore\Content\Plugin\Metatag;
use MotoStore\Content\Presenter\CheckoutPresenter;
use MotoStore\Platform\Controller\AbstractController;

class CheckoutController extends AbstractController
{
    /**
     * Login Page Content
     * @return mixed
     */
    public function checkout ($uri, $currentWidget = null)
    {
        if ($this->page)
        {
            $this->page
                ->properties
                ->meta
                ->set ('robots', 'noindex, nofollow');
        }

        $template = 'store/checkout.twig';

        if ($uri == CheckoutPresenter::STEP_ACCOUNT_DETAILS
            && $this->getServiceLocator ()->get ('store.authentication.service')->getIdentity ())
        {
            $uri = CheckoutPresenter::STEP_ADDRESS;
        }

        $presenter = new CheckoutPresenter ($uri);
        $presenter
            ->setRequest ($this->getRequest ());

        if ($this->getRequest()->isPost ())
        {
            $presenter->handle ();
        }

        if ($uri == CheckoutPresenter::STEP_SUCCESS)
        {
            $presenter->success ();

            $template = 'store/checkout/success.twig';
        }

        /** @var Metatag $metatag */
        $metatag = $this->getServiceLocator ()->get ('MotoStore\Plugin\Metatag');

        if (isset($this->page) && isset($this->page->title) && $this->page->title !== '')
        {
            $metatag->setTitle ($this->page->title);
        }
        elseif (isset($this->page) && isset($this->page->name) && $this->page->name !== '')
        {
            $metatag->setTitle ($this->page->name);
        }



        return $this->getServiceLocator ()
            ->get ('store.twig')
            ->render ($template, array_merge(array('currentWidget' => $currentWidget),$presenter->present ()));
    }
}