<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Content\Controller;


use MotoStore\Content\Helper\Link;
use MotoStore\Content\Plugin\Metatag;
use MotoStore\Platform\Controller\AbstractController;
use MotoStore\Product\Entity\Product;
use MotoStore\Settings\Entity\Currency;

class ProductController extends AbstractController
{
    public function product ($uri)
    {
        /** @var Product $product */
        $product = $this->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Product\Entity\Product')
            ->getProduct ($uri);

        if ($product)
        {
            /** @var Metatag $metatag */
            $metatag = $this->getServiceLocator ()->get ('MotoStore\Plugin\Metatag');

            $metatag
                ->setTitle ($product->getLocaleByLanguageCode ('en')->getName ())
                ->setKeywords ($product->getLocaleByLanguageCode ('en')->getKeywords ())
                ->setDescription ($product->getLocaleByLanguageCode ('en')->getMetaDescription ())
                ->setCanonicalUrl( $product->getLocaleByLanguageCode ('en')->getCanonicalUrl ())
                ->setHideCanonical( $product->getLocaleByLanguageCode ('en')->getHideCanonical ())
                ->setMetaTitle( $product->getLocaleByLanguageCode ('en')->getMetaTitle ())
                ->setNoindex( $product->getLocaleByLanguageCode ('en')->getNoindex ())
                ->setNofollow( $product->getLocaleByLanguageCode ('en')->getNofollow ())
                ->setOgDescription(strip_tags($product->getLocaleByLanguageCode ('en')->getOgDescription()))
                ->setOgTitle(strip_tags($product->getLocaleByLanguageCode ('en')->getOgTitle()))
                ->setOgImage($product->getLocaleByLanguageCode ('en')->getOgImage() ? Link::imageLink ($product->getLocaleByLanguageCode ('en')->getOgImage(), false): '')
                ->setOgUrl ($product->getLocaleByLanguageCode ('en')->getOgUrl())
                ->setJsonld($this->generateJsonld($product));

            $this->bindUrl ($product, Link::URI_SECTION_PRODUCT);
        }
    }
    /** @var Product $product */
    public function generateJsonld( $product){
        $image = $product->getImage()? Link::imageLink($product->getImage()->getPath(), false) : '';
        $highprice =  $product->getPrice();
        $lowprice =  $product->getHasSpecialPrice()? $product->getSpecialPrice() :  $product->getPrice();
        $sku = $product->getSku();
        $mpn = $product->getUpc()?$product->getUpc():$product->getSku();
        /** @var Currency $currency */
        $currency = $this->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Currency')
            ->getDisplayCurrency ();

        $jsonld = '<script type="application/ld+json">
            {
		  "@context": "http://schema.org/",
		  "@type": "Product",
		  "name": "' . $product->getLocaleByLanguageCode ('en')->getName () . '",
		  "image": "' . $image . '",
		  "url": "' . $product->getUri() . '",
		  "description": "' . $product->getLocaleByLanguageCode ('en')->getMetaDescription () . '",
		  "brand": "'.$product->getBrand()->getName().'",
		   "offers": {
                        "@type": "AggregateOffer",
                        "lowPrice": "'. $lowprice.'",
                        "highPrice": "'. $highprice.'",
                        "priceCurrency": "'.$currency->getCode().'",
                        "offerCount": "'.$product->getQuantity().'"
                      },
		  "sku": "'.$sku.'",
		  "mpn": "'.$mpn.'"
		}
			</script>';

        return $jsonld;
    }
}