<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Content\Form;


use MotoStore\Platform\Form\FormTypeAbstract;
use Zend\Validator\NotEmpty;
use MotoStore\Content\Helper\Translator;

class AuthenticationType extends FormTypeAbstract
{
    /**
     * Return hydration strategies
     *
     * @return array
     */
    protected function getStrategies ()
    {
        return array (
        );
    }

    /**
     * Build Form
     */
    public function init ()
    {

        $this
            ->add (array (
                'name'      => 'password',
                'required'  => false,
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array( 'name' => 'NotEmpty',
                        'options' => array(
                            'max' => 255,
                            'messages'=> array (
                                NotEmpty::IS_EMPTY => Translator::translate ('FORM_ERROR_REQUIRED', 'Value is required and can\'t be empty'),
                            )
                        )

                    ),
                ),
            ))
            ->add (array (
                'name'      => 'email',
                'required'  => false,
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array( 'name' => 'NotEmpty',
                        'options' => array(
                            'max' => 255,
                            'messages'=> array (
                                NotEmpty::IS_EMPTY => Translator::translate ('FORM_ERROR_REQUIRED', 'Value is required and can\'t be empty'),
                            )
                        )

                    ),
                    array(
                        'name' => 'MotoStore\Platform\From\Validator\Email',
                        'options' => array (
                            'domain' => false
                        )
                    ),
                ),
            ));
    }
}