<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Content\Form;

use MotoStore\Customer\Entity\Customer;

class EditAccountType extends AddressType
{
    public function init()
    {
        parent::init();

        $this->remove ('email');
    }

    protected function onPresetData(&$data, $entity)
    {
        $this->applyCountry ($data, $entity);
        $this->applyState ($data, $entity);
    }


    /**
     * @param $data
     * @param Customer $entity
     */
    public function applyCountry ($data, Customer $entity)
    {
        $country = null;

        if (!empty ($data ['country']))
        {
            $country = $this
                ->getEntityManager ()
                ->getRepository ('MotoStore\Localization\Entity\Country')
                ->find ($data ['country']);
        }
        $entity->attachCountry ($country);
    }

    /**
     * @param $data
     * @param Customer $entity
     */
    public function applyState ($data, Customer $entity)
    {
        $state = null;

        if (!empty ($data ['state']))
        {
            $state = $this
                ->getEntityManager ()
                ->getRepository ('MotoStore\Localization\Entity\State')
                ->find ($data ['state']);
        }
        $entity->attachState ($state);
    }
}