<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Content\Form;

use MotoStore\Customer\Entity\Customer;
use MotoStore\Platform\Auth\DoctrineAdapter;
use Zend\Validator\Callback;

class EditPersonalType extends AddressType
{

    /**
     * @var Customer
     */
    protected static $entity;

    public function init()
    {
        $this
            ->add (array (
                'name'      => 'email',
                'required'  => true,
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array (
                        'name' => 'MotoStore\Platform\From\Validator\Email',
                        'options' => array (
                            'domain' => false
                        )
                    ),
                    array(
                        'name' => 'Callback',
                        'options' => array (
                            'callback' => array ($this, 'validateEmail'),
                            'messages' => array (
                                Callback::INVALID_VALUE  => 'This email already in use',
                            )
                        )
                    ),
                ),
            ))
            ->add (array (
                'name'      => 'password',
                'required'  => true,
                'filters'=> array (
                ),
                'validators'=> array (
                    array(
                        'name' => 'Callback',
                        'options' => array (
                            'callback' => array ($this, 'validatePassword'),
                            'messages' => array (
                                Callback::INVALID_VALUE  => 'Incorrect password',
                            )
                        )
                    ),
                ),
            ))
            ->add (array (
                'name'      => 'new_password',
                'required'  => false,
                'filters'=> array (
                ),
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array (
                            'min' => 6,
                            'max' => 255,
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'confirm_new_password',
                'required'  => false,
                'filters'=> array (
                ),
                'validators'=> array (
                    array(
                        'name' => 'Identical',
                        'options' => array (
                            'token' => 'new_password',
                        ),
                    ),
                ),
            ));
    }

    /**
     * @param $data
     * @param $entity
     */
    protected function onPresetData(&$data, $entity)
    {
        self::$entity = $entity;
    }


    public function validatePassword ($password)
    {
        if (DoctrineAdapter::createPasswordHash (EditPersonalType::$entity->getEmail (), $password) !== EditPersonalType::$entity->getPassword ())
        {
            return false;
        }
        return true;
    }


    /**
     * @param $data
     * @param Customer $entity
     */
    protected function onDataValid(&$data, Customer $entity)
    {
        $password = DoctrineAdapter::createPasswordHash ($this->getValue ('email'), $this->getValue ('password'));

        $entity->setPassword ($password);

        if (!empty ($data ['new_password']) && !empty ($data ['confirm_new_password']))
        {
            $entity
                ->setPassword (DoctrineAdapter::createPasswordHash ($this->getValue ('email'), $data ['new_password']));
        }
    }


    /**
     * @return bool
     */
    public function validateEmail ()
    {
        $data = $this->data;

        $q = $this
            ->getEntityManager ()
            ->createQueryBuilder ();
        $result = $q
            ->select (array ('c'))
            ->from ('MotoStore\Customer\Entity\Customer', 'c')
            ->where ($q->expr ()->eq ('c.email', $q->expr ()->literal ($data ['email'])))
            ->andWhere ($q->expr ()->neq ('c.id', EditPersonalType::$entity->getId ()))
            ->getQuery()
            ->getArrayResult ();

        if ($result)
        {
            return false;
        }
        return true;
    }
}