<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Content\Form;


use MotoStore\Content\Content\DI\SMStatic;
use MotoStore\Customer\Entity\Customer;
use MotoStore\Platform\Auth\DoctrineAdapter;
use MotoStore\Platform\Form\Filter\DefaultValue;
use MotoStore\Platform\Form\FormTypeAbstract;
use MotoStore\Platform\From\Validator\Unique;

class RegisterType extends FormTypeAbstract
{
    /**
     * Return hydration strategies
     *
     * @return array
     */
    protected function getStrategies ()
    {
        return array (
        );
    }

    /**
     * Build Form
     */
    public function init ()
    {
        $default = new DefaultValue (1);


        $this
            ->add (array (
                'name'      => 'active',
                'required'  => true,
                'filters'=> array (
                    $default
                ),
            ))
            ->add (array (
                'name'      => 'newsletter',
                'required'  => true,
                'filters'=> array (
                    $default
                ),
            ))
            ->add (array (
                'name'      => 'password',
                'required'  => true,
                'filters'=> array (
                ),
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array (
                            'min' => 6,
                            'max' => 255,
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'confirm_password',
                'required'  => true,
                'filters'=> array (
                ),
                'validators'=> array (
                    array(
                        'name' => 'Identical',
                        'options' => array (
                            'token' => 'password',
                        ),
                    ),
                ),
            ))
            ->add (array (
                'name'      => 'email',
                'required'  => true,
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array (
                        'name' => 'MotoStore\Platform\From\Validator\Email',
                        'options' => array (
                            'domain' => false
                        )
                    ),
                    array (
                        'name' => 'MotoStore\Platform\From\Validator\Unique',
                        'options' => array (
                            'entityManager' => SMStatic::getInstance ()->get ('MotoStore\EntityManager'),
                            'entity'        => 'MotoStore\Customer\Entity\Customer',
                            'uniqueField'   => 'email',
                            'messages' => array (
                                Unique::NOT_UNIQUE   => 'This email already in use',
                            )
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'first_name',
                'required'  => true,
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array ('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'min' => 2,
                            'max' => 255,
                        )
                    )
                ),
            ))
            ->add (array (
                'name'      => 'last_name',
                'required'  => true,
                'filters'=> array (
                    array ('name' => 'StringTrim'),
                    array ('name' => 'StripTags'),
                ),
                'validators'=> array (
                    array(
                        'name' => 'StringLength',
                        'options' => array(
                            'min' => 2,
                            'max' => 255,
                        )
                    )
                ),
            ));
    }

    /**
     * @param $data
     * @param Customer $entity
     */
    protected function onDataValid (&$data, $entity)
    {
        $entity
            ->setPassword (DoctrineAdapter::createPasswordHash ($entity->getEmail (), $entity->getPassword ()));
    }


}