<?php
/***********************************************************************************************************************
 * @author: <for.samohin@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Content\Helper;

use Moto;
use MotoStore\Content\Content\DI\SMStatic;
use MotoStore\Content\Helper\Link;
use MotoStore\Product\Entity\Category;
use MotoStore\Product\Entity\Product;
use MotoStore\Product\Repository\CategoryRepository;


class BreadcrumbsFormer
{

    /**
     * Create breadcrumbs by section
     */
    public static function buildBreadcrumbs ()
    {
        $uri = Link::getEntityUri (Link::URI_SECTION_PRODUCT);

        $breadcrumbs = array();

        if ($uri)
        {
            $breadcrumbs =  self::getProductBreadcrumbs ($uri);
        }

        if ($uri = Link::getEntityUri (Link::URI_SECTION_CATEGORY))
        {
            $breadcrumbs = self::getCategoryBreadcrumbs (self::getCategory ($uri));
        }
        return $breadcrumbs;
    }

    /**
     * @param $uri
     * @return array
     */
    public static function getProductBreadcrumbs ($uri)
    {

        $breadcrumbs = array ();

        /** @var Product $product */
        $product = SMStatic::getInstance ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Product\Entity\Product')
            ->getProduct ($uri);

        if ($product)
        {
            /** @var Category $category */
            if ($product->getPrimaryCategoryId()){
                $category = SMStatic::getInstance ()
                    ->get ('MotoStore\EntityManager')
                    ->getRepository ('MotoStore\Product\Entity\Category')
                    ->getCategoryById ($product->getPrimaryCategoryId());
            } else {
                $category       =  $product->getCategories ()->first ();
            }

            $breadcrumbs   =  array_merge($breadcrumbs, self::getCategoryBreadcrumbs ($category));

            $breadcrumbs [] = array (
                'title' => $product->getLocaleByLanguageCode ('en')->getName (),
                'link'  => Link::storeLink (Link::URI_SECTION_PRODUCT, $product->getUri ()),
            );
        }
        return $breadcrumbs;
    }

    /**
     * @param $category
     * @return array
     */
    public static function getCategoryBreadcrumbs ($category)
    {
        $breadcrumbs = array ();

        if (Moto\Util::getValue(Moto\Website\Settings::get('home_page_provider'), 'name') == 'store'){} else {

            $pageRepository = SMStatic::getInstance ()
                ->get ('MotoStore\Content\PageRepository');
            $homepage = $pageRepository->findBySection('home');
            $breadcrumbs [] = array (
                'title' => $homepage->title,
                'link'  => Link::storeLink (),
            );

        }

        if ($category)
        {

            /** @var CategoryRepository $repository */
            $repository = SMStatic::getInstance ()
                ->get ('MotoStore\EntityManager')
                ->getRepository ('MotoStore\Product\Entity\Category');

            $breadcrumbs   =  array_merge($breadcrumbs, $repository->getBreadcrumbs ($category));
        }
        return $breadcrumbs;
    }

    /**
     * @param $uri
     * @return Category|null|object
     */
    public static function getCategory ($uri)
    {
        /** @var CategoryRepository $repository */
        $repository = SMStatic::getInstance ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Product\Entity\Category');

        /** @var Category $category */
        return $repository->getCategory ($uri);
    }
}