<?php


namespace MotoStore\Content\Helper;

use Moto;
use Doctrine\ORM\EntityManager;
use MotoStore\Content\Helper\PDFGenerator;
use Doctrine\DBAL\LockMode;
use Doctrine\ORM\EntityNotFoundException;
use Doctrine\ORM\EntityRepository;
use MotoStore\Content\Content\DI\SMStatic;
use MotoStore\Order\Entity\Order;
use MotoStore\Product\Entity\Category\Relation;
use MotoStore\Product\Entity\Product;
use MotoStore\Product\Entity\Variant;
use MotoStore\Product\Entity\Category;
use MotoStore\Settings\Repository\OptionRepository;
use MotoStore\Settings\Entity\Option;
use MotoStore\Collection\Query\Param;
use MotoStore\Mailer\Agent;
use MotoStore\Mailer\Entity\Template;
use MotoStore\Content\Helper\BreadcrumbsFormer;

class HookListener
{

    public static function attachHookListeners ()
    {
        Moto\Hook::on('MOTOSTORE_HOOK_ORDER_PAID',function($event, $order_id){return self::sendOrderPaid($event, $order_id);});
        Moto\Hook::on('MOTOSTORE_HOOK_ORDER_STATUS_UPDATED',function($event, $data){return self::processOrderStatusChange($event, $data);});
        if(defined('Moto\Hook::WIDGET_BREADCRUMBS__FULL_PAGE_COLLECTION_FILLED')){
            Moto\Hook::on(Moto\Hook::WIDGET_BREADCRUMBS__FULL_PAGE_COLLECTION_FILLED, function($event, $collection){
                return self::createBreadcrumbs($event, $collection);

            });
        };
    }
    public static function processOrderStatusChange($event, $data){
        $order_id = $data['order_id'];
        $status = $data['status'];
        $status_template_arrange = array(
             Order::ORDER_STATUS_PENDING => Template::TEMPLATE_TARGET_ORDER_STATUS_PENDING,
             Order::ORDER_WAITING_PAYMENT => Template::TEMPLATE_TARGET_ORDER_WAITING_PAYMENT,
             Order::ORDER_STATUS_PROCESSING => Template::TEMPLATE_TARGET_ORDER_STATUS_PROCESSING,
             Order::ORDER_STATUS_SHIPPED => Template::TEMPLATE_TARGET_ORDER_SHIPPED,
             Order::ORDER_STATUS_ON_HOLD => Template::TEMPLATE_TARGET_ORDER_ON_HOLD,
             Order::ORDER_STATUS_CANCELED => Template::TEMPLATE_TARGET_ORDER_CANCELED,
             Order::ORDER_STATUS_COMPLETE => Template::TEMPLATE_TARGET_ORDER_COMPLETE,
             Order::ORDER_STATUS_AWAITING_FULFILLMENT => Template::TEMPLATE_TARGET_ORDER_AWAITING_FULFILLMENT,
        );
        $em = SMStatic::getInstance ()
            ->get ('MotoStore\EntityManager');

        $order = $em->getRepository ('MotoStore\Order\Entity\Order')->findOneBy(array(
                'order_id' => $order_id)
        );
        $mailer = SMStatic::getInstance ()
            ->get ('store.mailer');
        $mailer
            ->sendTemplate (
                array (
                    $order->getEmail() => $order->getFullName ()
                ),
                $status_template_arrange[$status],
                array (
                    'order' => $order,
                    'invoice_link'=>  PDFGenerator::generateInvoice($order->getId()),
                    'currency' => $order->getCurrency()
                )
            );
        return true;
    }

    public static function createBreadcrumbs($event, Moto\System\PriorityCollection $collection)
    {

        $breadcrumbs = BreadcrumbsFormer::buildBreadcrumbs();
            if ($breadcrumbs){
                $tmp_collection = $collection;
                foreach ($tmp_collection as $item){
                    if ( $item->url === 'moto-template-store-product' || $item->url === 'moto-template-store-category' ){
                        $collection->remove($item);
                    }
                }
                foreach ($breadcrumbs as $k=>$item){
                  $page = new Moto\Application\Pages\PageModel();
                  $page->setName($item['title']);
                  $page->relative_url = $item['link'];
                  $collection->insert($page,$collection->getPriorityFor('CURRENT_PAGE') + $k );
                }

              return $collection;
            }
        return $collection;
    }



    public static function sendOrderPaid($event,$order_id){

        $em = SMStatic::getInstance ()
            ->get ('MotoStore\EntityManager');

        $order = $em->getRepository ('MotoStore\Order\Entity\Order')->findOneBy(array(
                'order_id' => $order_id)
        );
        /** @var Agent $mailer */
        $mailer = SMStatic::getInstance ()
            ->get ('store.mailer');
        $mailer
            ->sendTemplate (
                array (
                    $order->getEmail() => $order->getFullName ()
                ),
                Template::TEMPLATE_TARGET_ORDER_PAID,
                array (
                    'order' => $order,
                    'invoice_link'=>  PDFGenerator::generateInvoice($order->getId()),
                    'currency' => $order->getCurrency()
                )
            );

        $recipient =   SMStatic::getInstance ()
                ->get ('MotoStore\EntityManager')
                ->getRepository ('MotoStore\Settings\Entity\Option')
                ->getOption (
                    Option::OPTION_STORE_SETTINGS_MAIL,
                    'recipient_' . Template::TEMPLATE_TARGET_ORDER_PAID
                );


        if (!empty ($recipient))
        {

            $mailer
                ->sendTemplate (
                    array (
                        $recipient => null,
                    ),
                    Template::TEMPLATE_TARGET_ORDER_PAID,
                    array (
                        'order' => $order,
                        'invoice_link'=>  PDFGenerator::generateInvoice($order->getId()),
                        'currency' => $order->getCurrency()
                    )
                );
        }
        return true;
    }



}