<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Content\Helper;


use Moto\System;
use MotoStore\Collection\Collection;
use MotoStore\Content\Content\DI\SMStatic;

class Link
{
    const STORE_URL_PREFIX      = 'store';
    const URI_SECTION_PRODUCT   = 'product';
    const URI_SECTION_CHECKOUT  = 'checkout';
    const URI_SECTION_CATEGORY  = 'category';
    const URI_SECTION_SEARCH    = 'search';
    const URI_SECTION_ACCOUNT   = 'account';


    /** @var  string */
    private static $requestUrl;

    /**
     * Build Image Public Link
     *
     * @param $link
     * @return string
     */
    public static function imageLink ($link, $relative = true)
    {
        return $relative
            ? \Moto\System::getRelativeUrl ('@userUploads/' . $link)
            : \Moto\System::getAbsoluteUrl ('@userUploads/' . $link);
    }



    /**
     * Create Store Link
     *
     * @param $section
     * @param $uri
     * @param array $params
     * @param bool $relative
     * @return string
     */
    public static function storeLink ($section = null, $uri = null, $params = array (), $relative = true)
    {

        $id = 0;
        if (is_numeric($uri)){
            $id = intval($uri);
        }
        $repositories = array(
            'category' => 'MotoStore\Product\Entity\Category',
            'product' => 'MotoStore\Product\Entity\Product'
        );

        if ($id > 0 && $repositories[$section])
        {
            $item = SMStatic::getInstance ()
                ->get ('MotoStore\EntityManager')
                ->getRepository ($repositories[$section])
                ->find ($id);
           if($item && $item->getUri ()){
               $uri = $item->getUri ();
           }
        }

        $p = \Moto\Website\Settings::get('permalinks');

        $uri_base_path  = $relative
            ? System::getRelativeUrl ()
            : System::getAbsoluteUrl ();
        $uri_query = null;
        if ($params)
        {
            $uri_query = ($p ? '?' : '&') . http_build_query ($params);
        }
        $compiled =  join ('/', array_filter (array (
                self::STORE_URL_PREFIX,
                $section,
                $uri
            )));
        $compiled = $uri_base_path
            . ($p ? '' : '?url=')
            . ltrim($compiled)
            . (\Moto\Website\Settings::get('suffix') ? '.html' : '/')
            . $uri_query;

        return $compiled;
    }

    /**
     * Delete latter
     * @param null $url
     * @param array $params
     * @return string
     */
    public static function query ($url = null, $params = array ())
    {
        $p = \Moto\Website\Settings::get('permalinks');

        $uri_base_path  =  $url ? System::getRelativeUrl ($url) : self::getRequestUrl();

        $uri_query = null;

        if ($params)
        {
            $uri_query = ($p ? '?' : '&') . http_build_query ($params);
        }

        $compiled = System::getRelativeUrl ();

        if ($p)
        {
            $compiled .= ltrim($uri_base_path, '/');

            if ($uri_base_path)
            {

                if (\Moto\Website\Settings::get('suffix'))
                {
                    if ($uri_base_path != '/')
                    {
                        $compiled = \Moto\Website\Settings::get('suffix')
                            ? rtrim ($compiled, '/') . '.html'
                            : $compiled;
                    }
                }
            }

            if ($params)
            {
                $compiled .= $uri_query;
            }
        }
        else
        {
            if ($uri_base_path != '/')
            {
                $compiled .= '?url=';
                $compiled .= ltrim($uri_base_path, '/');
                $compiled .= $uri_query;

            }
            else
            {
                if ($params)
                {
                    $compiled .= '?';
                    $compiled .= http_build_query ($params);
                }
            }
        }

        return $compiled;
    }


    /**
     * Get Request Url
     * @return null|string
     */
    public static function getRequestUrl ()
    {
        if (!self::$requestUrl)
        {
            self::$requestUrl = \Moto\System\Request::getRequestUrl ();

            if (substr (self::$requestUrl, 0, 1) != '/')
            {
                self::$requestUrl = '/' . self::$requestUrl;
            }
        }

        return self::$requestUrl;
    }

    /**
     * Return Store Entity Unique URI Key
     *
     * @param $section
     * @return string
     */
    public static function getEntityUri ($section)
    {
        $pattern = str_replace (
            array ('|', '^', '$'),
            array ('\|', '\^', '\$'),
            '/store/' . $section . '/(.+)'
        );
        preg_match ('|^' . $pattern . '$|', trim (self::getRequestUrl ($section)), $m);

        return isset ($m[1]) ? rtrim ($m[1], '/') : '';
    }

    /**
     * @param null $section
     * @param null $uri
     * @param array $params
     */
    public static function redirect ($section = null, $uri = null, $params = array ())
    {
        $link = self::storeLink ($section, $uri, $params);

        header ("Location: {$link}");
        die ();
    }

    /**
     * Get store plugin web path
     * @return null|string
     */
    public static function getStoreWebPath ()
    {
        return \Moto\System::getRelativeUrl ('@plugins/moto-store-plugin' );
    }

    /**
     * Get store plugin web path
     * @return null|string
     */
    public static function getExtensionsWebPath ()
    {
        return self::getStoreWebPath () . '';
    }
}