<?php
/***********************************************************************************************************************
 * @author: <for.samohin@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Content\Helper;


use Zend\Http\PhpEnvironment\Request;
use MotoStore\Order\Cart\Storage;

class Pagination
{
    /**
     * Product Pages Count
     * @var int
     */
    private $pagesCount = 0;

    /**
     * Current Page
     * @var int
     */
    private $currentPage = 1;

    /**
     * Show product per page
     * @var int
     */
    private $limit = 24;

    /** @var int Size of Result */
    private $resultCount = 0;

    /**
     * @var Request
     */
    protected $request;


    /**
     * @param Request $request
     */
    function __construct (Request $request)
    {
        $this->request = $request;
    }

    /**
     * @return Request
     */
    public function getRequest()
    {
        return $this->request;
    }



    /**
     * @param int $limit
     * @return $this
     */
    public function setLimit($limit)
    {
        $this->limit = $limit;

        return $this;
    }

    /**
     * @return int
     */
    public function getFirstResult ()
    {
        return ($this->getPage () - 1) * $this->getLimit ();
    }

    /**
     * Pages count with limit
     * @return float
     */
    public function getPagesCount ()
    {
        if (!$this->pagesCount)
        {
            $this->pagesCount = ceil($this->getResultCount ()/ $this->getLimit ());
        }

        return $this->pagesCount;
    }


    /**
     * Get page to show
     * @return int
     */
    public function getPage ()
    {
        $page = $this->request->getQuery ('page', 1);

        if (is_numeric ($page) && $page > 0)
        {
            $this->currentPage = $page;
        }
        return $this->currentPage;
    }


    /**
     * Get page limit
     * @return int
     */
    public function getLimit ()
    {
        $storage = new Storage ();
        if ($storage->getLimit()){
            $this->limit = $storage->getLimit() ;
        }
        return $this->limit;

    }


    /**
     * @return int
     */
    public function getResultCount ()
    {
        return $this->resultCount;
    }

    /**
     * @param int $resultCount
     */
    public function setResultCount ($resultCount)
    {
        $this->resultCount = $resultCount;
    }
}