<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com> 
 **********************************************************************************************************************/

namespace MotoStore\Content\Helper\Twig;


use MotoStore\Content\Content\DI\SMStatic;
use MotoStore\Settings\Entity\Option;

class StoreTwigExtension extends \Twig_Extension
{
    /**
     * @var array
     */
    protected $presets = array ();
    
    protected $styles = array ();

    /**
     * Returns the name of the extension.
     *
     * @return string The extension name
     */
    public function getName()
    {
        return 'store_extension';
    }

    /**
     * @return array
     */
    public function getFunctions ()
    {
        return array (
            new \Twig_SimpleFunction ('storeLink', array ($this, 'storeLink')),
            new \Twig_SimpleFunction ('urlQuery', array ('MotoStore\Content\Helper\Link', 'query')),
            new \Twig_SimpleFunction ('imageLink', array ($this, 'imageLink')),
            new \Twig_SimpleFunction ('absoluteLink', array ($this, 'absoluteLink')),
            new \Twig_SimpleFunction ('assets', array ($this, 'assets')),
            new \Twig_SimpleFunction ('status', array ($this, 'status')),
            new \Twig_SimpleFunction ('store_preset', array ($this, 'store_preset')),
            new \Twig_SimpleFunction ('store_text_style', array ($this, 'store_text_style')),
        );
    }

    /**
     * @return array
     */
    public function getFilters()
    {
        return array (
            new \Twig_SimpleFilter ('price', array ('MotoStore\Content\Helper\Price', 'decorate')),
            new \Twig_SimpleFilter ('translate', array ('MotoStore\Content\Helper\Translator', 'translate')),
        );

    }

    /**
     * @param null $section
     * @param null $uri
     * @param array $params
     * @return string
     */
    public function storeLink ($section = null, $uri = null, $params = array ())
    {
        return \MotoStore\Content\Helper\Link::storeLink ($section, $uri, $params);
    }

    /**
     * @param $link
     * @return string
     */
    public function imageLink ($link)
    {
        if ($link)
        {
            return \MotoStore\Content\Helper\Link::imageLink ($link);
        }

        return null;
    }

    /**
     * @param $link
     * @return string
     */
    public function absoluteLink ($link)
    {
        if ($link)
        {
            return \MotoStore\Content\Helper\Link::imageLink ($link, false);
        }

        return null;
    }

    /**
     * @param $link
     * @return string
     */
    public function assets ($link)
    {
        return \Moto\System::getAbsoluteUrl ('@plugins') . '/moto-store-plugin/src/public/assets/' . $link;
    }


    /**
     * Order Status Render
     *
     * @param $status
     * @return string
     */
    public function status ($status)
    {
        switch ($status)
        {
            case 'STORE.ORDER.ORDER_STATUS_PENDING':
                return 'Pending';
                break;
            case 'STORE.ORDER.ORDER_WAITING_PAYMENT':
                return 'Awaiting Payment';
                break;
            case 'STORE.ORDER.ORDER_STATUS_PROCESSING':
                return 'Processing';
                break;
            case 'STORE.ORDER.ORDER_STATUS_SHIPPED':
                return 'Shipped';
                break;
            case 'STORE.ORDER.ORDER_PAYMENT_ACCEPTED':
                return 'Approved';
                break;
            case 'STORE.ORDER.ORDER_STATUS_ON_HOLD':
                return 'On Hold';
                break;
            case 'STORE.ORDER.ORDER_STATUS_CANCELED':
                return 'Canceled';
                break;
            case 'STORE.ORDER.ORDER_STATUS_COMPLETE':
                return 'Completed';
                break;
            case 'STORE.ORDER.ORDER_STATUS_AWAITING_FULFILLMENT':
                return 'Awaiting Fulfilment';
                break;
        }
    }

    /**
     * @param null $type
     * @param string $default
     * @return string
     */
    public function store_preset ($type = null, $default = 'default')
    {
        $preset_id = $default;
        $presets = $this->getPresetsConfig ();

        if (is_array ($presets))
        {
            if (array_key_exists ($type, $presets))
            {
                $preset_id = $presets [$type];
            }
        }
        return  $preset_id;
    }

    /**
     * @param $style_name
     * @param string $default
     * @return mixed|string
     * @internal param $style_preset
     */
    public function store_text_style ($style_name, $default = '')
    {
        $style_id = $default;
        $styles = $this->getStyleConfig ();

        if (is_array ($styles))
        {
            if (array_key_exists ($style_name, $styles))
            {
                $style_id = $styles [$style_name];
            }
        }
        return  $style_id;
        
    }

    /**
     * @return array|mixed
     */
    protected function getPresetsConfig ()
    {
        if (!$this->presets)
        {
            $this->presets = $this->configure ('presets');
        }

        return $this->presets;
    }

    /**
     * @return array|mixed
     */
    protected function getStyleConfig ()
    {
        if (!$this->styles)
        {
            $presets = $this->configure ('presets');

            if (!empty ($presets ['sts']))
            {
                $this->styles = $presets ['sts'];
            }
        }
        return $this->styles;
    }

    /**
     * @param $key
     * @return mixed
     */
    private function configure ($key)
    {
        $em = SMStatic::getInstance ()->get ('MotoStore\EntityManager');

        $string = $em
            ->getRepository('MotoStore\Settings\Entity\Option')
            ->getOption(Option::OPTION_STORE_SETTINGS_DESIGN, $key);

        if ($string)
        {
            $pr = json_decode ($string, true);

            if (is_array ($pr))
            {
                return $pr;
            }
        }
        return array ();
    }
}