<?php

namespace MotoStore\Content\Presenter;


use MotoStore\Content\Helper\Link;
use MotoStore\Content\Helper\Translator;
use MotoStore\Order\Cart\Storage;
use MotoStore\Product\Entity\Product;
use MotoStore\Product\Entity\TierPrice;
use MotoStore\Product\Entity\Variant;
use MotoStore\Settings\Entity\Discount;
use MotoStore\Settings\Entity\Option;
use MotoStore\Content\Content\DI\SMStatic;

class CartPresenter extends AbstractPresenter
{
    /**
     * @var Storage
     */
    protected $cart;

    protected $subtotal = 0;

    protected $discount = 0;

    protected $discount_shipping = 0;

    protected $shipping_enabled = 0;

    protected $expedite_shipping_enabled = 0;

    protected $expedite_shipping_enabled_2 = 0;

    protected $shipping_price = 0;

    protected $shipping_method = 0;

    protected $shipping_name = 0;

    protected $total = 0;

    protected $tax= 0;

    protected $weight = 0;

    protected $width = 0;

    protected $length = 0;

    protected $depth = 0;

    protected $items = array();

    public function __construct ()
    {
        $this->cart = new Storage ();
    }

    /**
     * @return array
     */
    public function getItems()
    {
        if (empty ($this->items))
        {
            $this->refreshItemsWIthCart ();
        }
        return $this->items;
    }

    /**
     * Present Page Data
     *
     * @return array
     */
    public function present ()
    {
        return array (
            'items'     => $this->getItems (),
            'subtotal'  => $this->subtotal,
            'discount'  => $this->discount,
            'discount_shipping'  => $this->discount_shipping,
            'discountInfo'  => $this->cart->getDiscount (),
            'total'     => $this->total,
            'tax'     => $this->tax,
            'is_price_include_tax'     => $this->isPriceIncludeTax(),
            'currency'  => $this->presentCurrency (),
            'comment'   => $this->cart->getComment (),
            'shipping_enabled' => $this->isShippingEnabled(),
            'expedite_shipping_enabled' => $this->isExpediteShippingEnabled(),
            'expedite_shipping_enabled_2' => $this->isExpediteShippingEnabled2(),
            'expedite_shipping_name' => $this->getExpediteShippingName(),
            'standart_shipping_name' => $this->getStandartShippingName(),
            'expedite_shipping_name_2' => $this->getExpediteShippingName2(),
            'shipping_price'  => $this->shipping_price,
            'shipping_method'  => $this->cart->getShippingMethod(),
            'min_order_amount_enabled' => $this->isMinOrderAmountEnabled(),
            'min_order_amount' => $this->getMinOrderAmount(),
            'min_order_amount_alert' => $this->getMinOrderAmountAlert(),
            'disable_prices_on_cart_and_checkout' => $this->isPricesEnabled(),
            'show_terms_checkbox' => $this->ifShowTermsCheckbox(),
            'terms_checkbox_position' => $this->getTermsCheckboxPosition(),
            'terms_checkbox_text' => $this->getTermsCheckboxText(),
            'use_custom_checkboxes' => $this->getUseCustomCheckbox(),
            'checkbox_hex_color' => $this->getCheckboxColor(),
            'store_is_opened' => $this->isStoreOpened(),
        );
    }

    public function handle ()
    {
        $this->cart
            ->setComment ($this->getRequest ()->getPost ('comment', ''));

        Link::redirect ('checkout', CheckoutPresenter::STEP_ACCOUNT_DETAILS);

    }

    /**
     * Present cart items
     *
     * @return array
     */
    protected function refreshItemsWIthCart ()
    {
        $discount = $this->cart->getDiscount ();
        $this->tax = 0;

        $this->refresh ();

        foreach ($this->cart->getItems () as $item)
        {
            $variant_id             = $item ['variant_id'];
            $id                     = $item ['product_id'];
            $qty                    = $item ['quantity'];
            $custom_options         = $item ['custom_options'];
            /**
             * @var Product $product
             */
            $product = $this->getServiceLocator()
                ->get ('MotoStore\EntityManager')
                ->getRepository ('MotoStore\Product\Entity\Product')
                ->find ($id);

            if (!$product){
                continue;
            }
            /** @var Variant $variant */

            $variant = $product->getVariants ()->filter(function (Variant $v) use ($variant_id) {
                return $v->getId () == $variant_id;
            })->first ();

            if (!empty($custom_options)){
                $priceup = 0;
                foreach ($custom_options as $option){
                    if ($option['value'] != ''){
                        $priceup += $option['price'];
                    }
                }

                if($variant &&  $variant->getPrice()){
                    $unit_price = $variant->getPrice() + $priceup;
                } else {
                    $unit_price = $product->getFinalPrice () + $priceup;
                }

            } else {
                $unit_price = $variant &&  $variant->getPrice()
                    ? $variant->getPrice()
                    : $product->getFinalPrice ();
            }

            $customerDiscount = $this->getCustomerDiscount();
            if($customerDiscount){
                $unit_price  = ($unit_price - $unit_price*$customerDiscount/100);
            }




            $tierMatched = array();

            /** @var TierPrice $tp */
            foreach ($product->getTierPrices()->toArray () as $tp)
            {
                if ($tp->getQuantity () <= $qty)
                {
                    $tierMatched [$tp->getQuantity ()] = $tp->getPrice ();
                }
            }

            if ($tierMatched)
            {
                krsort ($tierMatched, SORT_NUMERIC);
                $unit_price = current ($tierMatched);
            }

            //  Dimensions
            {
                $this->weight   += $product->getWeight ();
                $this->width    += $product->getWidth();
                $this->length   += $product->getLength();
                $this->depth    += $product->getDepth();
            }

            $item ['unit_price']    = $unit_price;
            $item ['subtotal']      = $unit_price * $qty;
            $item ['product']       = $product;
            $item ['variant']       = $variant;
            if ($this->isShippingEnabled()){
                $item ['shipping_price'] = $this->getShippingPrice($product);
                 $this->shipping_price += $item ['shipping_price'] * $qty;
            }
            $this->subtotal += $item ['subtotal'];
            $this->items [] = $item;





        }



        $this->shipping_name = 0;
        if ($this->isShippingEnabled()){
            $this->shipping_name = $this->getStandartShippingName();
            if ($this->cart->getShippingMethod() == 1){
                $this->shipping_name =  $this->getExpediteShippingName();
            } else if ($this->cart->getShippingMethod() == 2){
                $this->shipping_name =  $this->getExpediteShippingName2();
            }
        }


        $this->total = $this->subtotal;

        if ($discount && !$discount ['apply_to_shipping']) {
            if ($discount ['type'] == Discount::DISCOUNT_TYPE_AMOUNT) {
                $this->discount = $discount ['value'];
            }

            if ($discount ['type'] == Discount::DISCOUNT_TYPE_PERCENT) {
                $this->discount = $this->subtotal / 100 * $discount ['value'];
            }
        }

        $price_discount = 0;
        if ($this->enabledPriceDiscount() && $this->getPriceDiscount()){
            $price_discount = $this->calculatePriceDiscount($this->getPriceDiscount(), $this->subtotal);
        }
        if (($discount && !$discount ['apply_to_shipping']) || ($this->enabledPriceDiscount() && $price_discount >0) ){

            if ($price_discount > $this->discount){
                $this->discount = $price_discount;
            }

            $discounted = $this->total - $this->discount;

            if ($discounted > 0)
            {
                $this->total = $discounted;
            }
            else
            {
                $this->total = 0;
            }
        }




        if($this->isPerOrderShipping()){
            $this->shipping_price =  $this->getPerOrderShippingAmount();
        }
        if ($this->cart->getShippingMethod() == 1){
            $this->shipping_price = $this->shipping_price *$this->getExpediteShippingRate();
        }else if ($this->cart->getShippingMethod() == 2){
            $this->shipping_price = $this->shipping_price *$this->getExpediteShippingRate2();
        }
        if($this->isFreeShippingEnabled() && $this->total > $this->getFreeShippingAmount()){
            $this->shipping_price = 0;
        }
        if($this->isMaxShippingPriceEnabled() && $this->shipping_price > $this->getMaxShippingPrice()){
            $this->shipping_price = $this->getMaxShippingPrice();

        }
        $shipping_discount = $this->shipping_price - $this->getShippingPriceDiscounted($this->shipping_price );

        if($shipping_discount > 0 ){
            $this->discount_shipping = $shipping_discount;
        }

        if ($this->isShippingEnabled()){
            $this->total +=  ($this->shipping_price - $this->discount_shipping);
        }

        if ($this->isUseSimplifiedTax()) {
            if ($this->isPriceIncludeTax()) {
                $this->tax = $this->subtotal / (1 + $this->getSimplifiedTaxRate () / 100) * ($this->getSimplifiedTaxRate () / 100);
            } else {
                $this->tax = $this->subtotal * ($this->getSimplifiedTaxRate () / 100);
            }
            if ($this->isUseShippingTax()) {
                if ($this->isPriceIncludeTax()) {
                    $this->tax += ($this->shipping_price - $this->discount_shipping) / (1 + $this->getSimplifiedTaxRate () / 100) * ($this->getSimplifiedTaxRate () / 100);
                } else {
                    $this->tax += ($this->shipping_price - $this->discount_shipping) * ($this->getSimplifiedTaxRate () / 100);
                }
            }
        }




    }
    protected function isPriceIncludeTax ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_PRODUCT, 'display_price_inc_tax');
    }

    protected function isUseSimplifiedTax ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_PRODUCT, 'use_simplified_taxes');
    }

    protected function isUseShippingTax ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_PRODUCT, 'use_shipping_taxes');
    }


    protected function getSimplifiedTaxRate ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_PRODUCT, 'simplified_tax_rate');
    }
    private function enabledPriceDiscount(){
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');
        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_DISCOUNTS, 'price_discounts_enabled');
    }

    private function getPriceDiscount(){
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');
        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_DISCOUNTS, 'price_discounts');
    }

    private function calculatePriceDiscount($discount_ranges, $subtotal){
        $ranges = json_decode($discount_ranges,true);
        $result_discount = 0;
        foreach ($ranges as $range){
            if($range['price_from'] <= $subtotal){
                if ($range['discount'] >  $result_discount){
                    $result_discount = $range['discount'];
                }
            }
        }
        return ($subtotal / 100 * $result_discount);
    }

    /**
     * Clear Summary Values
     */
    private function refresh ()
    {
        $this->subtotal = 0;
        $this->total    = 0;
        $this->discount = 0;
        $this->weight = 0;
        $this->width = 0;
        $this->length = 0;
        $this->depth = 0;
        $this->shipping_price = 0;
        $this->shipping_name = 0;
    }

    public function getShippingPrice ($item)
    {
        $price = 0;
        if ($item->getShippingType() == 1) {
            return (float)$item->getShippingFixedPrice();
        } else {
            $weight   = $item->getWeight ();
            $width    = $item->getWidth ();
            $length   = $item->getLength ();
            $height   = $item->getHeight ();
            $optRepository = $this
                ->getServiceLocator ()
                ->get ('MotoStore\EntityManager')
                ->getRepository ('MotoStore\Settings\Entity\Option');

            $measurement =  $optRepository->getOption (Option::OPTION_STORE_SETTINGS_SHIPPING, 'shippping_measurement');
            $chargable_rate =  $optRepository->getOption (Option::OPTION_STORE_SETTINGS_SHIPPING, 'shipping_chargable_rate');
            $volumetric_rate =  $optRepository->getOption (Option::OPTION_STORE_SETTINGS_SHIPPING, 'shipping_volumetric_rate');
            $volumetric_weight = ($measurement == 0) ? (($width*$length*$height)/5000) : (($width*$length*$height)/166);

            if (($width*$length*$height)!== 0 && $weight/($width*$length*$height) < 200){
                $price = $volumetric_weight * $volumetric_rate;
            }
            else {
                $price = $weight * $chargable_rate;
            }

        }

        return (float) $price;
    }

    function  getShippingPriceDiscounted($price){
        $discount = $this->cart->getDiscount ();

        if ($discount && $discount ['apply_to_shipping'] )
        {
            if ($discount ['type'] == Discount::DISCOUNT_TYPE_AMOUNT)
            {
                $shipping_discount = $discount ['value'];
            }

            if ($discount ['type'] == Discount::DISCOUNT_TYPE_PERCENT)
            {
                $shipping_discount = $price/100 *  $discount ['value'];
            }

            $discounted = $price - $shipping_discount;


            if ($discounted > 0)
            {
                $price = $discounted;
            }
            else
            {
                $price = 0;
            }
        }
        return (float) $price;
    }
    protected function isStoreOpened ()
    {
        if(!$this->getIsEnabledWorkingHours()){
            return true;
        }
        if($this->getIsEnabledWorkingHoursOnlyForDelivery() == '1'){
            return true;
        }
        if($this->getIsStoreClosedNow() == '1'){
            return false;
        }
        $day_week_array = array('sunday','monday','tuesday','wednesday','thursday','friday','saturday');
        $opened = false;
        $need_check_custom_open = false;
        $closed_now = false;
        $opened_custom = false;
        $now_date = date('Y-m-d');
        $now_weekday = date('w');
        $now_hour = date('H');
        $now_minute = date('i');
        $custom_open = json_decode($this->getCustomOpen(),true);
        $closed = json_decode($this->getClosedTimes(),true);

        foreach ($custom_open as $custom_open_date){
            if (
                isset($custom_open_date['date'])
                && isset($custom_open_date['from'])
                && isset($custom_open_date['to'])
                && ( $now_date == date('Y-m-d', strtotime($custom_open_date['date'])))
                )
            {

                $need_check_custom_open = true;
                $open_from_hour = date('H', strtotime($custom_open_date['from']));
                $open_from_minute = date('i', strtotime($custom_open_date['from']));
                $open_to_hour = date('H', strtotime($custom_open_date['to']));
                $open_to_minute = date('i', strtotime($custom_open_date['to']));
                if($now_hour >= $open_from_hour && $now_hour <= $open_to_hour){
                    if($now_hour > $open_from_hour && $now_hour < $open_to_hour)
                    {
                        $opened_custom = true;
                    }
                    else if ($now_hour == $open_from_hour && $now_hour < $open_to_hour){
                        if($now_minute >= $open_from_minute)
                        {
                            $opened_custom = true;
                        }
                    }
                    else if ($now_hour == $open_to_hour && $now_hour > $open_from_hour){
                        if($now_minute <= $open_to_minute)
                        {
                            $opened_custom = true;
                        }
                    }
                    else if($now_hour == $open_to_hour && $now_hour == $open_from_hour && $now_minute >= $open_from_minute && $now_minute <= $open_to_minute)
                    {
                        $opened_custom = true;
                    }
                }
            }
        }

        if(!$need_check_custom_open) {
            $standart_open = json_decode($this->getStandartOpen(), true);
            $curent_standart_item = $standart_open[$day_week_array[$now_weekday]];
            if ( isset($curent_standart_item['from']) && isset($curent_standart_item['to']) && isset($curent_standart_item['to'])&& ($curent_standart_item['enabled'] == 'true'))
            {
                $open_from_hour = date('H', strtotime($curent_standart_item['from']));
                $open_from_minute = date('i', strtotime($curent_standart_item['from']));
                $open_to_hour = date('H', strtotime($curent_standart_item['to']));
                $open_to_minute = date('i', strtotime($curent_standart_item['to']));
                if($now_hour >= $open_from_hour && $now_hour <= $open_to_hour)
                {
                    if($now_hour > $open_from_hour && $now_hour < $open_to_hour)
                    {
                        $opened = true;
                    }
                    else if ($now_hour == $open_from_hour && $now_hour < $open_to_hour){
                        if($now_minute >= $open_from_minute)
                        {
                            $opened = true;
                        }
                    }
                    else if ($now_hour == $open_to_hour && $now_hour > $open_from_hour){
                        if($now_minute <= $open_to_minute)
                        {
                            $opened = true;
                        }
                    }
                    else if($now_hour == $open_to_hour && $now_hour == $open_from_hour && $now_minute >= $open_from_minute && $now_minute <= $open_to_minute)
                    {
                        $opened = true;
                    }
                }
            }
        }

        foreach ($closed as $closed_item){
           if (
                isset($closed_item['day'])
                && isset($closed_item['from'])
                && isset($closed_item['to'])
           )
           {
               if  ( $need_check_custom_open && ('custom_date' == $closed_item['day']))
                {
                    $open_from_hour = date('H', strtotime($closed_item['from']));
                    $open_from_minute = date('i', strtotime($closed_item['from']));
                    $open_to_hour = date('H', strtotime($closed_item['to']));
                    $open_to_minute = date('i', strtotime($closed_item['to']));
                    if($now_hour >= $open_from_hour && $now_hour <= $open_to_hour){
                        if($now_hour > $open_from_hour && $now_hour < $open_to_hour)
                        {
                            $closed_now = true;
                        }
                        else
                        if ($now_hour == $open_from_hour && $now_hour < $open_to_hour){
                            if($now_minute >= $open_from_minute)
                            {
                                $closed_now = true;
                            }
                        }
                        else
                        if ($now_hour == $open_to_hour && $now_hour > $open_from_hour){
                            if($now_minute <= $open_from_minute)
                            {
                                $closed_now = true;
                            }
                        }
                        else if($now_hour == $open_to_hour && $now_hour == $open_from_hour && $now_minute >= $open_from_minute && $now_minute <= $open_to_minute)
                        {
                            $closed_now = true;
                        }
                    }
               }
               else if( $closed_item['day'] == $day_week_array[$now_weekday])
               {
                   $open_from_hour = date('H', strtotime($closed_item['from']));
                   $open_from_minute = date('i', strtotime($closed_item['from']));
                   $open_to_hour = date('H', strtotime($closed_item['to']));
                   $open_to_minute = date('i', strtotime($closed_item['to']));
                   if($now_hour >= $open_from_hour && $now_hour <= $open_to_hour)
                   {
                       if($now_hour > $open_from_hour && $now_hour < $open_to_hour)
                       {
                           $closed_now = true;
                       }
                       else if($now_minute >= $open_from_minute && $now_minute <= $open_to_minute)
                       {
                           $closed_now = true;
                       }
                   }
               }
           }
        }
        return (($opened || $opened_custom) && !$closed_now) ;
    }

    protected function getIsStoreClosedNow ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_WORKING_HOURS, 'close_shop_now');
    }

    protected function getIsEnabledWorkingHours ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_WORKING_HOURS, 'enable_workinghours');
    }
    protected function getIsEnabledWorkingHoursOnlyForDelivery ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_WORKING_HOURS, 'enable_only_for_delivery');
    }

    protected function getIsEnablsssssdWorkingHours ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_WORKING_HOURS, 'close_shop_now');
    }

    protected function getStandartOpen ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_WORKING_HOURS, 'standart_open');
    }

    protected function getCustomOpen ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_WORKING_HOURS, 'custom_open');
    }
    protected function getClosedTimes ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_WORKING_HOURS, 'close');
    }

    protected function isShippingEnabled ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_SHIPPING, 'shipping_enabled');
    }

    protected function isFreeShippingEnabled ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_SHIPPING, 'free_shipping_enabled');
    }

    protected function getFreeShippingAmount ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_SHIPPING, 'free_shipping_amount');
    }

    protected function isPerOrderShipping ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_SHIPPING, 'calculate_per_order');
    }

    protected function getPerOrderShippingAmount ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_SHIPPING, 'per_order_shipping_amount');
    }

    protected function getMaxShippingPrice ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_SHIPPING, 'shipping_maxprice');
    }

    protected function isExpediteShippingEnabled ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_SHIPPING, 'expedite_shipping_enabled');
    }

    protected function isMaxShippingPriceEnabled ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_SHIPPING, 'shipping_maxprice_enabled');
    }
    protected function isPricesEnabled ()
    {
        $optRepository = clone SMStatic::getInstance()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        $catalog_mode = $optRepository ->getOption(Option::OPTION_STORE_SETTINGS_PRODUCT, 'catalog_mode');
        return !!$catalog_mode;
    }

    protected function ifShowTermsCheckbox ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_terms_checkbox');
    }
    protected function getTermsCheckboxPosition ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_CHECKOUT, 'terms_checkbox_position');
    }
    protected function getTermsCheckboxText ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_CHECKOUT, 'terms_checkbox_text');
    }
    protected function getUseCustomCheckbox ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_CHECKOUT, 'use_custom_checkboxes');
    }
    protected function getCheckboxColor ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_CHECKOUT, 'checkbox_hex_color');
    }
    protected function isExpediteShippingEnabled2 ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_SHIPPING, 'expedite_shipping_enabled_2');
    }
    protected function getExpediteShippingName ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_SHIPPING, 'expedite_rate_1_label');
    }
    protected function getStandartShippingName ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_SHIPPING, 'standart_shipping_label');
    }
    protected function getExpediteShippingRate ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_SHIPPING, 'expedite_rate_1_value');
    }
    protected function getExpediteShippingRate2 ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_SHIPPING, 'expedite_rate_2_value');
    }
    protected function getExpediteShippingName2 ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_SHIPPING, 'expedite_rate_2_label');
    }
    protected function isMinOrderAmountEnabled ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_PRODUCT, 'min_order_amount_enabled');
    }
    protected function getMinOrderAmount ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_PRODUCT, 'min_order_amount');
    }
    protected function getMinOrderAmountAlert ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_PRODUCT, 'min_order_amount_alert');
    }
    protected  function getCustomerDiscount()
    {
        $identity  = SMStatic::getInstance ()
            ->get ('store.authentication.service')
            ->getIdentity ();

        if($identity)
        {
            $customer = SMStatic::getInstance ()
                ->get ('MotoStore\EntityManager')
                ->getRepository ('MotoStore\Customer\Entity\Customer')
                ->find ($identity->getId ());
            if ($customer){
                $discount = $customer->getLoyaltyDiscount();
                if($discount && $discount > 0 && $discount < 100){
                    return $discount;
                } else {
                    return false;
                }
            }
        }
        return false;

    }
}