<?php
/***********************************************************************************************************************
 * @author: <for.samohin.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Content\Presenter;


use Doctrine\ORM\EntityManager;
use Moto\Website\Settings;
use MotoStore\Collection\Collection;
use MotoStore\Content\Content\DI\SMStatic;
use MotoStore\Content\Form\AddressType;
use MotoStore\Content\Form\AuthenticationType;
use MotoStore\Content\Helper\Link;
use MotoStore\Content\Helper\Translator;
use MotoStore\Customer\Entity\Customer;
use MotoStore\Mailer\Agent;
use MotoStore\Mailer\Entity\Template;
use MotoStore\Order\Cart\Storage;
use MotoStore\Order\Entity\Order;
use MotoStore\Payment\Gateway\PaymentModule;
use MotoStore\Payment\Gateway\Provider;
use MotoStore\Platform\Auth\DoctrineAdapter;
use MotoStore\Product\Entity\Product;
use MotoStore\Product\Entity\Variant;
use MotoStore\Settings\Entity\Discount;
use MotoStore\Settings\Entity\Option;
use MotoStore\Settings\Entity\Tax\Rate;
use MotoStore\Settings\Repository\OptionRepository;
use MotoStore\Settings\Repository\TaxRateRepository;
use MotoStore\Settings\Service\PaymentServiceClass;
use MotoStore\Platform\Integrations\QuickBooks\QuickBooks;
use OAuth2\Exception;
use MotoStore\Content\Helper\PDFGenerator;
use Moto;

class CheckoutPresenter extends CartPresenter
{
    const STEP_ACCOUNT_DETAILS = 'account-details';

    const STEP_ADDRESS = 'address';

    const STEP_SHIPPING = 'shipping';

    const STEP_CONFIRMATION = 'confirmation';

    const STEP_SUCCESS = 'success';

    /**
     * current
     * @var mixed
     */
    protected $step;
    protected $errors = array ();

    protected $tax = 0;
    protected $tax_percents = 0;


    /**
     * Allowed steps
     *
     * @var array
     */
    protected $steps = array (
        self::STEP_ACCOUNT_DETAILS,
        self::STEP_ADDRESS,
//        self::STEP_SHIPPING,
        self::STEP_CONFIRMATION,
        self::STEP_SUCCESS,
    );

    /**
     * @param $step
     */
    public function __construct ($step = '')
    {
        if (in_array ($step, $this->steps))
        {
            $this->step = $step;
        }
        else
        {
            $this->step = current ($this->steps);
        }

        parent::__construct ();
    }

    /**
     * Present Page Data
     *
     * @return array
     */
    public function present()
    {
        $cart = parent::present ();
        return array_merge ($cart, array (
                'currentStep'   => $this->step,
                'validSteps'    => $this->cart->getValidSteps (),
                'countries'     => $this->presentCountries (),
                'states'        => $this->presentStates (),
                'payments'      => $this->presentPayments (),
                'address'       => $this->presentShippingAddress (),
                'errors'        => $this->errors,
                'tax'           => $this->presentTax (),
                'is_price_include_tax' => $this->isPriceIncludeTax (),
                'order_id'      => $this->cart->getLastOrderId (),
                'email'         => $this->cart->getConfirmationEmail (),
                'create_account' => $this->cart->getCreateNewAccount (),
                'is_success'    => $this->cart->isSuccess (),
                'checkout_options' => $this->getFieldOptions(),
                'datetimepicker_stylesheet' => $this->getDatetimepickerStylesheet(),
                'datetimepicker_options' => $this->getDatetimepickerOptions(),
                'disable_guest_checkout' => $this->getIsDisabledGuestCheckout(),
            )
        );
    }

    protected function isPriceIncludeTax ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_PRODUCT, 'display_price_inc_tax');
    }

    protected function isUseSimplifiedTax ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_PRODUCT, 'use_simplified_taxes');
    }


    protected function isUseShippingTax ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_PRODUCT, 'use_shipping_taxes');
    }


    protected function getSimplifiedTaxRate ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_PRODUCT, 'simplified_tax_rate');
    }


    protected function getIsDisabledGuestCheckout ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_CHECKOUT, 'disable_guest_checkout');
    }

    protected function  getFieldOptions(){

        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return array(
                'show_zip' => $optRepository->getOption(Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_zip'),
                'show_city' => $optRepository->getOption (Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_city'),
                'show_state' => $optRepository->getOption (Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_state'),
                'show_country' => $optRepository->getOption (Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_country'),
                'show_company' => $optRepository->getOption (Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_company'),
                'show_address2' => $optRepository->getOption (Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_address2'),
                'show_address' => $optRepository->getOption (Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_address'),
                'show_lastname' => $optRepository->getOption (Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_lastname'),
                'show_shipping_form' => $optRepository->getOption (Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_shipping_form'),
                'show_paymentgateway_name' => $optRepository->getOption (Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_paymentgateway_name'),
                'show_phone' => $optRepository->getOption (Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_phone'),
                'disable_prices_on_cart_and_checkout' => $optRepository->getOption (Option::OPTION_STORE_SETTINGS_CHECKOUT, 'disable_prices_on_cart_and_checkout'),
                'show_terms_checkbox' => $optRepository->getOption (Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_terms_checkbox'),
                'terms_checkbox_position' => $optRepository->getOption (Option::OPTION_STORE_SETTINGS_CHECKOUT, 'terms_checkbox_position'),
                'terms_checkbox_text' => $optRepository->getOption (Option::OPTION_STORE_SETTINGS_CHECKOUT, 'terms_checkbox_text'),
                'use_custom_checkboxes' => $optRepository->getOption (Option::OPTION_STORE_SETTINGS_CHECKOUT, 'use_custom_checkboxes'),
                'checkbox_hex_color' => $optRepository->getOption (Option::OPTION_STORE_SETTINGS_CHECKOUT, 'checkbox_hex_color'),
                'show_delivery_time' => $optRepository->getOption (Option::OPTION_STORE_SETTINGS_CHECKOUT, 'show_delivery_time'),
            );
    }
    protected function getDatetimepickerStylesheet(){
        return '<link href="'. Moto\System::getRelativeUrl ('@plugins/moto-store-plugin/src/public/assets/css/jquery.datetimepicker.min.css') . '" rel="stylesheet" type="text/css" />';
    }

    protected function getDatetimepickerOptions(){
        return "<script>
        window.datetimepicker_options_alloweddates = " . $this->buildJsonShedule().";
        window.locked_days = [];
        for(var date_element in window.datetimepicker_options_alloweddates) {
           if (window.datetimepicker_options_alloweddates[date_element].is_locked)
                window.locked_days.push(window.datetimepicker_options_alloweddates[date_element].is_locked);
        }    
        window.datepickerSelectDateCheckout = function(e){
            var o = new Date(e),
                a = o . getDate(),
                t = o . getMonth() + 1,
                i = o . getFullYear(),
                n = i + \"-\" + t + \"-\" + a;
              allowed_dates = window.datetimepicker_options_alloweddates;
             if (allowed_dates[n].custom_hours.length > 0){
               this.setOptions({
                    minTime: false,
                    maxTime: false,
                    allowTimes: allowed_dates[n].custom_hours
                });
             } else {
                 this.setOptions({
                    minTime: allowed_dates[n].minTime,
                    maxTime:  allowed_dates[n].maxTime,
                     allowTimes: false
                 });
             }
             if(allowed_dates[n].is_locked){
              this.setOptions({
                    minTime: allowed_dates[n].minTime,
                    maxTime:  allowed_dates[n].maxTime,
                     allowTimes: false
                 });
                 }
          
        };        
        window.datetimepicker_options = {
            step: " . $this->getDeliveryTimeInterval() . ",
            monthStart: '" . intval(date('n', strtotime("+0day"))) . "',
            monthEnd:  '" .  intval(date('n', strtotime("+7day"))) . "',
            dayOfWeekStart: '1',
            scrollMonth:false,
            scrollInput:false,
            defaultSelect: false,
            scrollBoxOnClick:false,
            allowBlank: false,
            disabledDates : window.locked_days,
            minTime: window.datetimepicker_options_alloweddates['".date('Y-n-j', strtotime("+0day"))."'].minTime ,
            maxTime: window.datetimepicker_options_alloweddates['".date('Y-n-j', strtotime("+0day"))."'].maxTime,
            minDate:0,
            maxDate:'+1970/01/7',
            onSelectDate: window.datepickerSelectDateCheckout,
        };

      </script> ";
    }



    protected function buildJsonShedule()
    {
        $shedule = array();
        for ($i = 0; $i < 7; $i++) {
            $shedule [date('Y-n-j', strtotime("+" . $i . " day"))] = $this->getSheduleRow($i);
        }
        return json_encode($shedule);
    }

    protected function getSheduleRow($offset)
    {
        $timeformat = ("H:i");
        $row = array();
        $openedHours = $this->getOpenedHours($offset,$timeformat);
        $row ['minTime'] = $openedHours ['from'];
        $row ['maxTime'] =  $openedHours ['to'];
        $row ['custom_hours'] =  $openedHours ['custom_hours'];
        $row ['is_locked'] = false;
        $row ['closed_today'] = $openedHours ['closed_today'];
        if($openedHours ['from'] == '' || $row ['closed_today'] ){
            $row ['is_locked'] = date('Y/m/d',strtotime("+".$offset." day")); ;
        }
        return $row;
    }

    protected function getOpenedHours ($offset,$timeformat)
    {
        $day_week_array = array('sunday','monday','tuesday','wednesday','thursday','friday','saturday');
        $now_date = date('Y-m-d',strtotime("+".$offset." day"));
        $today_date = date('Y-m-d',strtotime("+0 day"));
        $today_weekday = date('w',strtotime("+0 day"));
        $now_weekday = date('w',strtotime("+".$offset." day"));
        $custom_open = json_decode($this->getCustomOpen(),true);
        $closed = json_decode($this->getClosedTimes(),true);
        $now_hour = date('H');
        $now_minute = date('i');
        if (is_array($closed)){
            krsort($closed);
        }
        $open_from = '-';
        $open_to = '-';
        $need_check_custom_open = false;
        $today_custom_open = false;
        $array_part_hours_1 = array();
        $array_part_hours_2 = array();
        $is_today = false;
        $closed_today = false;
        foreach ($custom_open as $custom_open_date){
            if (
                isset($custom_open_date['date'])
                && isset($custom_open_date['from'])
                && isset($custom_open_date['to'])
                && ( $now_date == date('Y-m-d', strtotime($custom_open_date['date'])))
            )
            {
                $need_check_custom_open = true;
                $open_from = date($timeformat, strtotime($custom_open_date['from']));
                $open_to = date($timeformat, strtotime($custom_open_date['to']));
                if($today_date == date('Y-m-d', strtotime($custom_open_date['date']))){
                    $today_custom_open = true;
                    }
            }
        }

        if(!$need_check_custom_open) {
            $standart_open = json_decode($this->getStandartOpen(), true);
            $curent_standart_item = $standart_open[$day_week_array[$now_weekday]];
            if ( isset($curent_standart_item['from']) && isset($curent_standart_item['to']) && isset($curent_standart_item['to'])&& ($curent_standart_item['enabled'] == 'true'))
            {
                $open_from = date($timeformat, strtotime($curent_standart_item['from']));
                $open_to = date($timeformat, strtotime($curent_standart_item['to']));
            }
        }
        $closed_from = '0';
        $closed_to = '0';
        foreach ($closed as $closed_item){
            $need_to_add_closed = false;
            if  ( $need_check_custom_open && ('custom_date' == $closed_item['day']))
            {
                $closed_from = date($timeformat, strtotime($closed_item['from']));
                $closed_to = date($timeformat, strtotime($closed_item['to']));
                $need_to_add_closed = true;
            }
            else if( $closed_item['day'] == $day_week_array[$now_weekday])
            {
                $closed_from = date($timeformat, strtotime($closed_item['from']));
                $closed_to = date($timeformat, strtotime($closed_item['to']));
                $need_to_add_closed = true;
            }
            if($today_custom_open && $closed_item['day'] == $day_week_array[$today_weekday]){
                $is_today = true;
            }
            if ($open_from < $closed_from && $open_to > $closed_from &&  $need_to_add_closed === true){
                $array_part_hours_1 = $this->buildTimeArray($open_from,$closed_from,$timeformat, $is_today);
                //$open_from = $open_from . '-' . $closed_from;
                if($open_to > $closed_to){
                    $array_part_hours_2 = $this->buildTimeArray($closed_to,$open_to,$timeformat, $is_today);
                   // $open_to = $closed_to . '-' . $open_to;
                }
                break;
            }

        }
        if ($open_from == '-'){
            $open_from = '';
        }
        if ($open_to == '-'){
            $open_to = '';
        }

        if($open_from !== '' && $offset == 0 && date($timeformat, strtotime("+0day")) > $open_from){
            $open_from = date($timeformat, strtotime("+0day"));
        }

        $custom_hours_array = array_merge($array_part_hours_1,$array_part_hours_2);

        if($open_to !== '' && $offset == 0){
            if (count($custom_hours_array)>0 ){
                if(strtotime(date($timeformat, strtotime("+0day"))) > strtotime(end($custom_hours_array))){
                    $closed_today = true;
                }
            } else if (strtotime(date($timeformat, strtotime("+0day"))) > strtotime($open_to)){
                $closed_today = true;
            }
        }



        return array( 'from' => $open_from, 'to' => $open_to , 'custom_hours' => $custom_hours_array, 'closed_today' => $closed_today) ;
    }
    public  function  buildTimeArray($from,$to,$timeformat,$istoday){

        $nowtime =  date($timeformat);
        $interval = $this->getDeliveryTimeInterval();
        $tStart = strtotime($from);
        $tEnd = strtotime($to);
        $tNow = $tStart;
        $result = array();
        while($tNow <= $tEnd){
            if($istoday){
                if ($nowtime < date($timeformat,$tNow)){
                    $result[] = date($timeformat,$tNow);
                }
            } else {
                $result[] = date($timeformat,$tNow);
            }

            $tNow = strtotime('+' . $interval . ' minutes', $tNow);
        }
        return $result;
    }

    protected function getIsEnabledWorkingHours ()
    {
        $optRepository = SMStatic::getInstance ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_WORKING_HOURS, 'enable_workinghours');
    }

    protected function getDateFormat ()
    {
        $optRepository = SMStatic::getInstance ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');
        $dateFormat = $optRepository ->getOption(Option::OPTION_STORE_SETTINGS_PRODUCT, 'date_format');
        if (!$dateFormat){
            $dateFormat = "Y-m-d";
        }
        return $dateFormat;
    }

    protected function getTimeFormat ()
    {
        $optRepository = SMStatic::getInstance ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        $timeFormat = $optRepository ->getOption(Option::OPTION_STORE_SETTINGS_PRODUCT, 'time_format');
        if (!$timeFormat){
            $timeFormat = "H:m";
        }
        return $timeFormat;
    }

    protected function getDeliveryTimeInterval ()
    {
        $optRepository = SMStatic::getInstance ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        $interval = $optRepository ->getOption(Option::OPTION_STORE_SETTINGS_CHECKOUT, 'delivery_time_interval');
        if (!$interval){
            $interval = 20;
        }
        return $interval;
    }

    protected function getIsEnablsssssdWorkingHours ()
    {
        $optRepository =  SMStatic::getInstance ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_WORKING_HOURS, 'close_shop_now');
    }

    protected function getStandartOpen ()
    {
        $optRepository = SMStatic::getInstance ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_WORKING_HOURS, 'standart_open');
    }

    protected function getCustomOpen ()
    {
        $optRepository =  SMStatic::getInstance ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_WORKING_HOURS, 'custom_open');
    }
    protected function getClosedTimes ()
    {
        $optRepository =  SMStatic::getInstance ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_WORKING_HOURS, 'close');
    }


    /**
     * Present Tax
     * @return int
     */
    protected function presentTax ()
    {
        $this->tax = 0;

        if ($this->step === self::STEP_CONFIRMATION) {
            if ($this->isUseSimplifiedTax()) {
                foreach ($this->getItems() as $item) {
                    if ($this->isPriceIncludeTax()) {
                        $this->tax += $item['subtotal'] / (1 + $this->getSimplifiedTaxRate () / 100) * ($this->getSimplifiedTaxRate () / 100);
                    } else {
                        $this->tax += $item['subtotal'] * ($this->getSimplifiedTaxRate () / 100);
                    }
                }


                if ($this->isUseShippingTax()) {
                    if ($this->isPriceIncludeTax()) {
                        $this->tax += ($this->shipping_price - $this->discount_shipping) / (1 + $this->getSimplifiedTaxRate () / 100) * ($this->getSimplifiedTaxRate () / 100);
                    } else {
                        $this->tax += ($this->shipping_price - $this->discount_shipping) * ($this->getSimplifiedTaxRate () / 100);
                    }
                }
            } else {


                $shippingAddress = $this->cart->getShippingDetails();
                $country_id = !empty ($shippingAddress ['country']) ? $shippingAddress ['country'] : null;
                $state_id = !empty ($shippingAddress ['state']) ? $shippingAddress ['state'] : null;


                /** @var EntityManager $em */
                $em = $this
                    ->getServiceLocator()
                    ->get('MotoStore\EntityManager');

                /** @var TaxRateRepository $rateRepository */
                $rateRepository = $em
                    ->getRepository('MotoStore\Settings\Entity\Tax\Rate');

                foreach ($this->getItems() as $item) {
                    /** @var Product $entity */
                    $entity = $item ['product'];
                    $rates = array();

                    if ($entity->getTaxClassId()) {

                        if ($state_id) {
                            $rates = $rateRepository->getRateByState($entity->getTaxClassId(), $state_id);
                        }

                        if (!$rates && !$state_id && $country_id) {
                            $rates = $rateRepository->getRateByCountry($entity->getTaxClassId(), $country_id);
                        }

                        if ($rates) {
                            /** @var Rate $first */
                            $first = current($rates);
                            if ($this->isPriceIncludeTax()) {
                                $this->tax += $item['subtotal'] / (1 + $first->getRate() / 100) * ($first->getRate() / 100);
                            } else {
                                $this->tax += $item['subtotal'] * ($first->getRate() / 100);
                            }
                        }
                    }
                }
            }
        }
        $this
            ->cart
            ->setTotalTax ($this->tax);

        return $this->tax;
    }

    /**
     * If customer in acc
     * present billing as shipping detail
     * only if user does'nt fill form
     */
    public function presentShippingAddress ()
    {
        $shippingAddress = $this->cart->getShippingDetails ();

        /** @var Customer $identity */
        $identity  = $this
            ->getServiceLocator ()
            ->get ('store.authentication.service')
            ->getIdentity ();

        if ($identity)
        {
            $customer = $this
                ->getServiceLocator ()
                ->get ('MotoStore\EntityManager')
                ->getRepository ('MotoStore\Customer\Entity\Customer')
                ->find ($identity->getId ());
                 if ($customer){
                     $shippingAddress ['first_name'] = $customer->getFirstName ();
                     $shippingAddress ['last_name'] = $customer->getLastName();
                     $shippingAddress ['email'] = $customer->getEmail();
                     $shippingAddress ['company'] = $customer->getCompany();
                     $shippingAddress ['address1'] = $customer->getAddress1();
                     $shippingAddress ['address2'] = $customer->getAddress2();
                     $shippingAddress ['city'] = $customer->getCity();
                     $shippingAddress ['post_code'] = $customer->getPostCode();
                     $shippingAddress ['contact_phone'] = $customer->getContactPhone();
                     $shippingAddress ['country'] = $customer->getCountry () ? $customer->getCountry ()->getId () : null;
                     $shippingAddress ['state'] = $customer->getState () ? $customer->getState ()->getId () : null;
                 } else {
                     $shippingAddress = null;
                 }
        }


        return $shippingAddress;
    }

    /**
     * Present payments
     * @return mixed
     */
    protected function presentPayments ()
    {
        $paymentService = new PaymentServiceClass ($this->getServiceLocator ());
        $paymentCollection  = $paymentService->getEnabledCollection ();
        if ($this->cart->getDisableManualPayment()){
            $manual_payments_possible_names = array('DefaultMethod','AdditionalDefaultMethod','AdditionalDefaultMethod2');
            foreach ($paymentCollection as $key=>$payment){
                if(in_array($payment['name'],$manual_payments_possible_names)){
                    unset ($paymentCollection[$key]);
                }
            }
        }
        return $paymentCollection;
    }

    /**
     * Present country
     * @return array
     */
    protected function presentCountries ()
    {
        /**
         * @var Collection $collection
         */
        $collection = $this
            ->getServiceLocator ()
            ->get ('store.collection.country');

        return $collection->getCollection ();
    }

    protected function presentStates ()
    {
        /**
         * @var Collection $collection
         */
        $collection = $this
            ->getServiceLocator ()
            ->get ('store.collection.state');

        return $collection->getCollection ();
    }

    /**
     * Submit handler
     */
    public function handle ()
    {
        $currentStep = $this
            ->getRequest ()
            ->getPost ('currentStep');

        switch ($currentStep)
        {
            case self::STEP_ACCOUNT_DETAILS:
                    $this->handleAccountDetails ();
                break;

            case self::STEP_ADDRESS:
                    $this->handleAddressDetails ();
                break;

            case self::STEP_SHIPPING:
                    $this->handleShippingDetails ();
                break;

            case self::STEP_CONFIRMATION:
                    $this->handleConfirmationDetails ();

                    Link::redirect ('checkout', self::STEP_CONFIRMATION);
                break;
        }
    }

    /**
     * Handle Success
     */
    public function success ()
    {
        /**
         * @var Provider $paymentProvider
         */
        $paymentProvider = $this
            ->getServiceLocator ()
            ->get ('store.payment.provider');

        /**
         * @var PaymentModule $payment
         */
        $payment =  $paymentProvider
            ->getPaymentMethod ($this->getRequest ()->getQuery ('provider', ''));

        $success =$this->cart->isSuccess ();

        if ($payment && !$success)
        {
            $payment->handle ($this->getRequest ());

            if ($payment->getErrors ())
            {
                $this->errors = array_merge ($this->errors, $payment->getErrors ());
            }
        }

        if ($this->cart->isSuccess ())
        {
            $this
                ->cart
                ->clearOrderData ();
        }
    }

    /**
     * Handle step 1 Account Details
     */
    public function handleAccountDetails ()
    {
        if ($this->getRequest ()->getPost ('exists_account'))
        {
            if ($this->checkoutWithAccount ())
            {
                $this->cart->setValidStep (self::STEP_ACCOUNT_DETAILS);
                Link::redirect ('checkout', self::STEP_ADDRESS);
            }
        }
        else
        {
            $this
                ->cart
                ->setCreateNewAccount ($this->getRequest ()->getPost ('create_account'));

            $this
                ->cart
                ->setValidStep (self::STEP_ACCOUNT_DETAILS);

            Link::redirect ('checkout', self::STEP_ADDRESS);
        }
    }

    /**
     * Handle Address Step 2
     */
    public function handleAddressDetails ()
    {
        $isNewAccountCreation = $this->cart->getCreateNewAccount ()
            && !$this->getServiceLocator ()->get ('store.authentication.service')->getIdentity ();

        $addressType = new AddressType ($isNewAccountCreation);

        $addressType
            ->setEntityManager ($this->getServiceLocator ()->get ('MotoStore\EntityManager'))
            ->init ();

        $addressType
            ->setData ($this->getRequest ()->getPost ());

        $this
            ->cart
            ->setShippingDetails ($addressType->getValues ());


        $post = $this->getRequest ()->getPost ()-> toArray();

        if (isset($post['shiptodiffadress'])){
        $this
            ->cart
            ->setShippingAddress($post['shipping_address']);
    }
        if (isset($post['delivery_date'])){
            $this
                ->cart
                ->setDeliveryDate($post['delivery_date']);
        }
        if ($addressType->isValid ())
        {
            $this
                ->cart
                ->setValidStep (self::STEP_ADDRESS, true);

            $customer_data = $this->getRequest ()->getPost ()->toArray ();
            $disable_manual_payment  = false;
            $this->cart->setDisableManualPayment($disable_manual_payment);
            $need_to_disable_manual_payment = \Moto\Hook::trigger("MOTOSTORE_HOOK_PROCESS_CUSTOMER_DETAILS", $customer_data, false);
            if ($need_to_disable_manual_payment === true){
                $disable_manual_payment = $need_to_disable_manual_payment;
                $this->cart->setDisableManualPayment($disable_manual_payment);
            }
            Link::redirect ('checkout', self::STEP_CONFIRMATION);
        }

        $this->errors = $addressType->getMessages ();
    }

    /**
     * Handle step 3 shipping details
     */
    public function handleShippingDetails ()
    {
//                $this
//                    ->cart
//                    ->setValidStep (self::STEP_SHIPPING, true);
//
//                Link::redirect ('checkout', self::STEP_CONFIRMATION);
//                break;
    }



    /**
     * @return bool
     */
    protected function checkoutWithAccount ()
    {
        $form = new AuthenticationType ();
        $form->init ();

        $form->setData ($this->getRequest ()->getPost ());

        if ($form->isValid ())
        {
            if ($this->makeBuyerAuthentication ($form->getValue('email'), $form->getValue('password')))
            {
                return true;
            }
            $this->errors ['email'] = array ('Incorrect Email or Password');
            $this->errors ['password'] = array ('Incorrect Email or Password');
        }
        else
        {
            $this->errors = $form->getMessages ();
        }
        return false;
    }

    /**
     * Proceed Order Payment
     */
    protected function handleConfirmationDetails ()
    {
        $this->cart->setIsSuccess (false);

        $paymentName = $this
            ->getRequest ()
            ->getPost ('payment_method');

        if (!$paymentName)
        {
            return;
        }


        /**
         * @var Provider $paymentProvider
         */
        $paymentProvider = $this
            ->getServiceLocator ()
            ->get ('store.payment.provider');

        /**
         * @var PaymentModule $payment
         */
        $payment =  $paymentProvider
            ->getPaymentMethod ($paymentName);

        if (!$payment)
        {
            return;
        }


        /**
         * @var EntityManager $em
         */
        $em = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager');

        $orderID = $this->getRequest()->getPost ('order_id')
            ? $this->getRequest()->getPost ('order_id')
            : $this->getRequest()->getQuery ('order_id');


        if ($orderID)
        {
            $order = $em->getRepository ('MotoStore\Order\Entity\Order')->findOneBy(array(
                'order_id' => $orderID
            ));

            if ($order)
            {
                $payment->checkout($order);
                return;
            }
        }


        $order = new Order ();

        $order->createUniqueId ();

        $identity  = $this
            ->getServiceLocator ()
            ->get ('store.authentication.service')
            ->getIdentity ();

        if ($identity)
        {
            $customer = $em
                ->getRepository ('MotoStore\Customer\Entity\Customer')
                ->find ($identity->getId ());

            if ($customer)
            {
                $order->addCustomer($customer);
            }
        }

        $shippingDetails = $this
            ->cart
            ->getShippingDetails ();

        if (!$this->isUseSimplifiedTax()) {
            $this->presentTax();
        }
        $inc_tax = $this->isPriceIncludeTax ();

        $order->setEmail        ($shippingDetails ['email']);
        $order->setFirstName    ($shippingDetails ['first_name']);
        $order->setLastName     ($shippingDetails ['last_name']);
        $order->setCompany      ($shippingDetails ['company']);
        $order->setAddress1     ($shippingDetails ['address1']);
        $order->setAddress2     ($shippingDetails ['address2']);
        $order->setCity         ($shippingDetails ['city']);

        $order->setPostCode     ($shippingDetails ['post_code']);
        $order->setContactPhone ($shippingDetails ['contact_phone']);
        $order->setPaymentGateway ($paymentName);


        if ($shippingDetails ['country'])
        {
            $country = $em
                ->getRepository ('MotoStore\Localization\Entity\Country')
                ->find ($shippingDetails ['country']);

            $order->addCountry ($country);
        }

        if ($shippingDetails ['state'])
        {
            $state = $em
                ->getRepository ('MotoStore\Localization\Entity\State')
                ->find ($shippingDetails ['state']);

            $order->addState ($state);
        }

        $shippingAddress = ($this->cart->getShippingAddress())?:false;
        $shipping_adress_array = false;
        if ($shippingAddress){


            $shipping_adress_array = array();
            $shipping_adress_array['first_name'] = $shippingAddress ['first_name']?:'';
            $shipping_adress_array['last_name'] = $shippingAddress ['last_name']?:'';
            $shipping_adress_array['address1'] = $shippingAddress ['address1']?:'';
            $shipping_adress_array['city'] = $shippingAddress ['city']?:'';
            $shipping_adress_array['post_code'] = $shippingAddress ['post_code']?:'';
            $shipping_adress_array['contact_phone'] = $shippingAddress ['contact_phone']?:'';
            $shipping_adress_array['country'] = $em
                ->getRepository ('MotoStore\Localization\Entity\Country')
                ->find ($shippingAddress ['country']?:'');
            $shipping_adress_array['country'] =  $shipping_adress_array['country'] ? $shipping_adress_array['country']->getName() : null;
             $shipping_adress_array['state'] = $em
                 ->getRepository ('MotoStore\Localization\Entity\State')
                 ->find ($shippingAddress ['state']?:'');
            $shipping_adress_array['state'] = $shipping_adress_array['state'] ? $shipping_adress_array['state']->getName() : null;


            $order->setShippingAddress(json_encode($shipping_adress_array));
        }

        $order->setComment ($this->cart->getComment ());

        $this->applyProducts ($order, $em);
        $order->setDiscount ($this->discount);
        $order->setDiscountShipping ($this->discount_shipping);


        $discount = $this
            ->cart
            ->getDiscount ();

        if ($discount)
        {
            $order->setDiscountCode($discount ['code']);
            $this->trackDiscountUsage ($discount, $em);
        }

        $order->setTotalPrice($this->total);


        if (!$inc_tax)
        {
            $order->setTotalPrice($this->total + $this->tax);
        }

        if ($this->shipping_price == ''){
            $this->shipping_price = 0;
        }
        $order->setSubtotalPrice($this->subtotal);
        $order->setShippingPrice($this->shipping_price);
        $order->setShippingName($this->shipping_name);
        $delivery_date = $this->cart->getDeliveryDate();
        if ($delivery_date){
            $order->setDeliveryDate($delivery_date);
        }


        $status = Order::ORDER_WAITING_PAYMENT;

        if ($order->getTotalPrice () == 0)
        {
            $status = Order::ORDER_PAYMENT_ACCEPTED;
        }

        $order->setStatus ($status);
        $order->setTotalWeight ($this->weight);
        $order->setTotalWidth ($this->width);
        $order->setTotalLength ($this->length);
        $order->setTotalDepth ($this->depth);
        $order->setCurrency($this->getCurrency());
        $order->setTaxPrice ($this->tax);

        if ($this->cart->getCreateNewAccount ())
        {
            $customer = $this->createNewAccount ($order);

            $order
                ->addCustomer ($customer);
        }

        $em->persist ($order);
        $em->flush();

        $this->cart->setLastOrderId ($order->getOrderId ());
        $this->cart->setConfirmationEmail ($order->getEmail());

        /** @var Agent $mailer */
        $mailer = $this
            ->getServiceLocator ()
            ->get ('store.mailer');
        $order->setPaymentGateway ($payment->getOption('display_name'));
        $mailer
            ->sendTemplate (
                array (
                    $order->getEmail() => $order->getFullName ()
                ),
                Template::TEMPLATE_TARGET_ORDER_CONFIRMATION,
                array (
                    'order' => $order,
                    'invoice_link'=>  PDFGenerator::generateInvoice($order->getId()),
                    'currency' => $this->getCurrency(),
                    'shippingAddress' => $shipping_adress_array,
                    'shippingName' => $this->shipping_name
                )
            );



        $webmaster = Settings::getWebmaster();
        /*
        $order->setStatus(str_replace('STORE.ORDER.','', Order::getStatusName ($order->getStatus())));
        $body = SMStatic::getInstance()
            ->get ('store.twig')
            ->render ('store/mail/webmaster-order.twig', array('order' => $order,
                'currency' => $this->getCurrency(),
                'shippingAddress' => $shipping_adress_array,
                'paymentName'=>$payment->getOption('display_name'),
                'shippingName' => $this->shipping_name));
*/
        $title = 'New order received #' . $order->getOrderId();

        if (!empty ($webmaster))
        {
           // $mailer->send ($webmaster ['email'], $webmaster ['name'], $title, $body);

            $mailer
                ->sendTemplate (
                    array (
                        $webmaster ['email'] => $webmaster ['name'],
                    ),
                    Template::TEMPLATE_TARGET_ORDER_CREATED_WEBMASTER,
                    array (
                        'order' => $order,
                        'invoice_link'=>  PDFGenerator::generateInvoice($order->getId()),
                        'currency' => $this->getCurrency(),
                        'shippingAddress' => $shipping_adress_array,
                        'paymentName'=>$payment->getOption('display_name'),
                        'shippingName' => $this->shipping_name
                    ),
                    $title
                );
        }

        $recipient = $this->getConfirmationRecipient ();

        if (!empty ($recipient))
        {
            $mailer
                ->sendTemplate (
                    array (
                        $recipient => null,
                    ),
                    Template::TEMPLATE_TARGET_ORDER_CREATED_WEBMASTER,
                    array (
                        'order' => $order,
                        'invoice_link'=>  PDFGenerator::generateInvoice($order->getId()),
                        'currency' => $this->getCurrency(),
                        'shippingAddress' => $shipping_adress_array,
                        'paymentName'=>$payment->getOption('display_name'),
                        'shippingName' => $this->shipping_name
                    ),
                    $title
                );
           // $mailer->send ($recipient, null, $title, $body);
        }
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        $quickbooks = $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INTEGRATIONS, 'enable_quickbooks');
        if($quickbooks){
            try
            {
                QuickBooks::addPurchase($order);
            }
            catch (Exception $e)
            {

            }

        }
        Moto\Hook::trigger('MOTOSTORE_HOOK_ORDER_CREATED',$order);

        if ($order->getTotalPrice () == 0)
        {
            $this->cart->setIsSuccess (true);
            Link::redirect ('checkout', 'success');
        }

        $payment->checkout ($order);
        exit;
    }

    /**
     * @return string|null
     */
    private function getConfirmationRecipient ()
    {
        return $this->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option')
            ->getOption (
                Option::OPTION_STORE_SETTINGS_MAIL,
                'recipient_' . Template::TEMPLATE_TARGET_ORDER_CONFIRMATION
            );
    }

    /**
     * Apply ordered products to order
     *
     * @param Order $order
     * @param EntityManager $em
     */
    protected function applyProducts (Order $order, EntityManager $em)
    {
        // initiate inventory tracking
        {
            /** @var OptionRepository $optRepository */
            $optRepository = $em
                ->getRepository ('MotoStore\Settings\Entity\Option');
            $trackInventoryFlag = $optRepository->getOption (Option::OPTION_STORE_SETTINGS_PRODUCT, 'track_product_inventory');
            $allowNegativeFlag  = $optRepository->getOption (Option::OPTION_STORE_SETTINGS_PRODUCT, 'allow_negative_inventory');

        }

        $products = array ();

        foreach ($this->getItems()  as $item)
        {
            /**
             * @var Product $product
             */
            $product = $item ['product'];
            /** @var Variant $variant */
            $variant = $item ['variant'];

            $additional = array ();
            $custom_options = $item ['custom_options'];
            $filepath = ($product->getFile()) ?$product->getFile()->getPath() : $product->getFile();
            $orderItem = new \MotoStore\Order\Entity\Product ();

            $orderItem->setName ($product->getLocaleByLanguageCode('en')->getName ());
            $orderItem->setPrice ($item ['unit_price']);
            $orderItem->setProductId ($product->getId());
            $orderItem->setQuantity ($item ['quantity']);
            $orderItem->setSku ($variant && $variant->getSku() ? $variant->getSku() : $product->getSku());
            $orderItem->setUpc($product->getUpc());
            $orderItem->setBrand($product->getBrand()->getName());
            $orderItem->setProduct ($product);
            $orderItem->setWeight ($product->getWeight ());
            $orderItem->setWidth ($product->getWidth ());
            $orderItem->setDepth ($product->getDepth ());
            $orderItem->setLength ($product->getLength ());
            $orderItem->setTotalPrice ($item ['subtotal']);
            $orderItem->setfile ($filepath);
            $orderItem->setOrder ($order);

            if ($variant)
            {
                $variant->trackInventory ($item ['quantity'], $trackInventoryFlag, $allowNegativeFlag);
                /** @var Variant\VariantOption $option */
                $orderItem->setVariantId ($variant->getId());
                foreach ($variant->getOptions() as $option)
                {
                    $additional [$option->getOption()->getName ()] = $option->getValue ()->getName();

                }
            }
            else
            {
                if ($product->trackInventory ($item ['quantity'], $trackInventoryFlag, $allowNegativeFlag) === false)
                {
                    $this->errors [] = sprintf('Only %s items available for sale', $product->getQuantity());
                }
            }
            if(!empty($custom_options)){
                $custom_options_formatted = array();
                foreach ($custom_options as $option)
                {
                    if (isset($option['value']) && $option['value'] != '')
                        $custom_options_formatted [$option['name']] = $option['value'];
                }
                $orderItem->setCustomOptions($custom_options_formatted);
            }
            $orderItem->setAdditional ($additional);

            $products [] = $orderItem;
        }

        $order->addProducts ($products);
    }

    /**
     * Track discount Usage
     *
     * @param $discount
     * @param EntityManager $em
     */
    protected function  trackDiscountUsage ($discount, EntityManager $em)
    {
        /**
         * @var Discount $discount
         */
        $discount = $em
            ->getRepository ('MotoStore\Settings\Entity\Discount')
            ->findOneBy (array (
                'code' => $discount ['code']
            ));

        if ($discount)
        {
            $discount->trackUsage ();
            $em->merge ($discount);
        }
    }

    /**
     * New Account
     *
     * @param Order $order
     * @return Customer
     */
    protected function createNewAccount (Order $order)
    {
        $shipping = $this->cart->getShippingDetails();

        $password = empty ($shipping ['password'])
            ? DoctrineAdapter::generatePassword ()
            : $shipping ['password'];

        $customer = new Customer ();
        $customer->setActive (Customer::CUSTOMER_ACTIVE);
        $customer->setEmail ($order->getEmail());
        $customer->setFirstName ($order->getFirstName());
        $customer->setLastName ($order->getLastName());
        $customer->setCompany ($order->getCompany());
        $customer->setAddress1 ($order->getAddress1());
        $customer->setAddress2 ($order->getAddress2());
        $customer->setCity ($order->getCity());
        $customer->setPassword (DoctrineAdapter::createPasswordHash ($order->getEmail (), $password));
        $customer->setPostCode ($order->getPostCode());
        $customer->setContactPhone ($order->getContactPhone ());
        $customer->attachCountry ($order->getCountry ());
        $customer->attachState ($order->getState ());

        $this->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->persist ($customer);

        $this->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->flush ($customer);

        /** without error handling */
        $this->makeBuyerAuthentication ($customer->getEmail (), $password);

        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        $quickbooks = $optRepository->getOption (Option::OPTION_STORE_SETTINGS_INTEGRATIONS, 'enable_quickbooks');
        if($quickbooks){
            try
            {
                QuickBooks::addCustomer($customer);
            }
            catch (Exception $e)
            {

            }
        }


        $this
            ->getServiceLocator ()
            ->get ('store.mailer')
            ->sendTemplate (
                array ($order->getEmail() => $order->getFullName ()),
                Template::TEMPLATE_TARGET_REGISTRATION,
                array (
                    'customer' => $customer,
                    'password' => $password
                )
            );

        return $customer;
    }

    /**
     * @param $email
     * @param $password
     * @return mixed
     */
    private function makeBuyerAuthentication ($email, $password)
    {
        $authentication = $this
            ->getServiceLocator ()
            ->get ('store.authentication.service');


        $authentication
            ->getAdapter()
            ->setEmail ($email)
            ->setPassword ($password);

        $result = $authentication->authenticate ();

        return $result->isValid ();
    }

    public function getCurrency ()
    {
        $id = $this->cart->getCurrency ();

        $em = $this->getServiceLocator ()
            ->get ('MotoStore\EntityManager');

        if (!$id)
        {
            $id = $em
                ->getRepository('MotoStore\Settings\Entity\Option')
                ->getOption(Option::OPTION_STORE_SETTINGS_PRODUCT, 'default_currency');
        }
        return  $em
            ->getRepository ('MotoStore\Settings\Entity\Currency')
            ->find ($id);
    }
}