<?php

namespace MotoStore\Content\Presenter;


use MotoStore\Content\Helper\Link;
use MotoStore\Content\Helper\Translator;
use MotoStore\Order\Cart\Storage;
use MotoStore\Product\Entity\Product;
use MotoStore\Product\Entity\Property;
use MotoStore\Product\Entity\TierPrice;
use MotoStore\Product\Entity\Variant;
use MotoStore\Settings\Entity\Discount;
use MotoStore\Settings\Entity\Option;
use MotoStore\Content\Content\DI\SMStatic;
use MotoStore\Product\Entity\Property\Relation;
use Doctrine\ORM\Query\Expr\Join;
use Moto;

class ComparePresenter extends AbstractPresenter
{
    /**
     * @var Storage
     */
    protected $compare;

    protected $subtotal = 0;

    protected $discount = 0;

    protected $shipping_enabled = 0;

    protected $expedite_shipping_enabled = 0;

    protected $expedite_shipping_enabled_2 = 0;

    protected $shipping_price = 0;

    protected $shipping_method = 0;

    protected $total = 0;

    protected $weight = 0;

    protected $width = 0;

    protected $length = 0;

    protected $depth = 0;

    protected $items = array();

    protected $itemsCompare = array();

    public function __construct ()
    {
        $this->compare = new Storage ();
    }

    /**
     * Present Page Data
     *
     * @return array
     */
    public function present ($widget = null)
    {
        return array (
            'currentWidget' => $widget,
            'items'     => $this->getCompareItems (),
            'currency'  => $this->presentCurrency (),
            'properties'  => $this->getAllProperties (),
            'disable_prices_on_cart_and_checkout' => $this->isPricesEnabled(),
        );
    }

    public function getCompareItems(){
        if (empty ($this->itemsCompare))
        {
            $this->refreshItemsCompare ();
        }
        return $this->itemsCompare;

    }

    public function getAllProperties(){
        $collection = SMStatic::getInstance ()->get ('store.collection.property');
        $props_collection = $collection->getCollection(function ($props) {
            return array (
                'id' => $props ['id'],
                'name' => $props ['name'],
            );
        });
        return $props_collection;
    }

    protected function refreshItemsCompare ()
    {
        $compare_items = $this->compare->getCompareItems();
        if (Moto\Website\Application::getInstance()->isPreviewMode()) {
            $compare_items = $this->getDummyProductsCollection();
        }

        foreach ($compare_items as $item)
        {
            $id = isset($item ['product_id'])?$item ['product_id']:$item ['id']  ;
            $product = $this->getServiceLocator()
                ->get ('MotoStore\EntityManager')
                ->getRepository ('MotoStore\Product\Entity\Product')
                ->find ($id);
            if (!$product){
                continue;
            }
            $item ['product']       = $product;
            $item ['product_has_special_price'] = $product->getHasSpecialPrice();
            $item ['product_special_date_start'] = $product->getSpecialDateStart();
            $item ['product_special_date_end'] = $product->getSpecialDateEnd();
            $item ['product_special_price'] = $product->getSpecialPrice();
            $this->itemsCompare [] = $item;
        }

    }

    public function getDummyProductsCollection (){
        $collection = SMStatic::getInstance ()
            ->get ('store.collection.product_list')
            ->setLimit(3);
        $result = $collection
            ->getCollectionWithMetaData ();
        return $result ['collection'];

    }


    protected function isPricesEnabled ()
    {
        $optRepository = $this
            ->getServiceLocator ()
            ->get ('MotoStore\EntityManager')
            ->getRepository ('MotoStore\Settings\Entity\Option');

        return $optRepository->getOption (Option::OPTION_STORE_SETTINGS_CHECKOUT, 'disable_prices_on_cart_and_checkout');
    }

}