<?php
/***********************************************************************************************************************
 * @author: <kolomiets.dev@gmail.com>
 **********************************************************************************************************************/

namespace MotoStore\Content\Repository;

use Moto\Application\Pages\PageModel;
use Moto\Application\Pages\PagesTable;
use Moto;

/**
 * Repository of moto pages
 *
 * Class PageRepository
 * @package MotoStore\Content\Repository
 */
class PageRepository
{
    /** @var  PagesTable */
    private $pagesTable;

    /**
     * Store Page Signature
     *
     * @var string
     */
    private static $signature = 'template.store.';

    /**
     * PageRepository constructor.
     * @param PagesTable $pagesTable
     */
    public function __construct(PagesTable $pagesTable)
    {
        $this->pagesTable = $pagesTable;
    }

    /**
     * Find page by store section
     *
     * @param $section
     * @return PageModel|null
     */
    public function findBySection ($section)
    {
        $this->pagesTable->useResultAsModel (true);

        $resultSet = $this->pagesTable
            ->getList (array ('type' => self::$signature . $section), array ('*'), null, 1);

        if (!empty ($resultSet ['records']))
        {
            return current ($resultSet ['records']);
        }
        return null;
    }

    public function getEmptyPage ()
    {
        $page = new PageModel ();

        $page->exchangeArray (array (
            'layout'     => $page->layout,
            'status'     => 'publish',
            'background' => 'moto-background'
        ));

        $page->layout->sections->header->id = 1;
        $page->layout->sections->footer->id = 2;

        return $page;

    }

    /**
     * Not found page
     * @return array|\ArrayObject|PageModel|null
     * @throws \Moto\Json\Server\Exception
     */
    public function getNotFoundPage ()
    {
        $id = \Moto\Website\Settings::get ('notfound_page_id');

        if ($id)
        {
            return  \Moto\Application\Pages\Service::getById($id);
        }

        return $this->getEmptyPage ();
    }

    /**
     * @param $page
     * @return bool
     */
    public function isMainPage($page)
    {
        return (Moto\Util::getValue($page, 'type') === self::$signature . 'home');
    }
}